/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.type.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.camunda.bpm.model.xml.ModelException;
import org.camunda.bpm.model.xml.UnsupportedModelOperationException;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.camunda.bpm.model.xml.impl.type.reference.AttributeReferenceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.impl.util.StringUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.reference.AttributeReference;

public abstract class AttributeReferenceCollection<T extends ModelElementInstance>
extends AttributeReferenceImpl<T>
implements AttributeReference<T> {
    protected String separator = " ";

    public AttributeReferenceCollection(AttributeImpl<String> referenceSourceAttribute) {
        super(referenceSourceAttribute);
    }

    @Override
    protected void updateReference(ModelElementInstance referenceSourceElement, String oldIdentifier, String newIdentifier) {
        String referencingIdentifier = this.getReferenceIdentifier(referenceSourceElement);
        List<String> references = StringUtil.splitListBySeparator(referencingIdentifier, this.separator);
        if (oldIdentifier != null && references.contains(oldIdentifier)) {
            referencingIdentifier = referencingIdentifier.replace(oldIdentifier, newIdentifier);
            this.setReferenceIdentifier(referenceSourceElement, newIdentifier);
        }
    }

    @Override
    protected void removeReference(ModelElementInstance referenceSourceElement, ModelElementInstance referenceTargetElement) {
        String identifier = this.getReferenceIdentifier(referenceSourceElement);
        List<String> references = StringUtil.splitListBySeparator(identifier, this.separator);
        String identifierToRemove = this.getTargetElementIdentifier(referenceTargetElement);
        references.remove(identifierToRemove);
        identifier = StringUtil.joinList(references, this.separator);
        this.setReferenceIdentifier(referenceSourceElement, identifier);
    }

    protected abstract String getTargetElementIdentifier(T var1);

    private Collection<DomElement> getView(ModelElementInstance referenceSourceElement) {
        DomDocument document = referenceSourceElement.getModelInstance().getDocument();
        String identifier = this.getReferenceIdentifier(referenceSourceElement);
        List<String> references = StringUtil.splitListBySeparator(identifier, this.separator);
        ArrayList<DomElement> referenceTargetElements = new ArrayList<DomElement>();
        for (String reference : references) {
            DomElement referenceTargetElement = document.getElementById(reference);
            if (referenceTargetElement != null) {
                referenceTargetElements.add(referenceTargetElement);
                continue;
            }
            throw new ModelException("Unable to find a model element instance for id " + identifier);
        }
        return referenceTargetElements;
    }

    public Collection<T> getReferenceTargetElements(final ModelElementInstance referenceSourceElement) {
        return new Collection<T>(){

            @Override
            public int size() {
                return AttributeReferenceCollection.this.getView(referenceSourceElement).size();
            }

            @Override
            public boolean isEmpty() {
                return AttributeReferenceCollection.this.getView(referenceSourceElement).isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof ModelElementInstanceImpl)) {
                    return false;
                }
                return AttributeReferenceCollection.this.getView(referenceSourceElement).contains(((ModelElementInstanceImpl)o).getDomElement());
            }

            @Override
            public Iterator<T> iterator() {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(AttributeReferenceCollection.this.getView(referenceSourceElement), (ModelInstanceImpl)referenceSourceElement.getModelInstance());
                return modelElementCollection.iterator();
            }

            @Override
            public Object[] toArray() {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(AttributeReferenceCollection.this.getView(referenceSourceElement), (ModelInstanceImpl)referenceSourceElement.getModelInstance());
                return modelElementCollection.toArray();
            }

            @Override
            public <T1> T1[] toArray(T1[] a) {
                Collection<T1> modelElementCollection = ModelUtil.getModelElementCollection(AttributeReferenceCollection.this.getView(referenceSourceElement), (ModelInstanceImpl)referenceSourceElement.getModelInstance());
                return modelElementCollection.toArray(a);
            }

            @Override
            public boolean add(T t) {
                if (!this.contains(t)) {
                    AttributeReferenceCollection.this.performAddOperation(referenceSourceElement, t);
                }
                return true;
            }

            @Override
            public boolean remove(Object o) {
                ModelUtil.ensureInstanceOf(o, ModelElementInstanceImpl.class);
                AttributeReferenceCollection.this.performRemoveOperation(referenceSourceElement, o);
                return true;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(AttributeReferenceCollection.this.getView(referenceSourceElement), (ModelInstanceImpl)referenceSourceElement.getModelInstance());
                return modelElementCollection.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                boolean result = false;
                for (ModelElementInstance o : c) {
                    result |= this.add((T)o);
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                for (Object o : c) {
                    result |= this.remove(o);
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedModelOperationException("retainAll()", "not implemented");
            }

            @Override
            public void clear() {
                AttributeReferenceCollection.this.performClearOperation(referenceSourceElement);
            }
        };
    }

    protected void performClearOperation(ModelElementInstance referenceSourceElement) {
        this.setReferenceIdentifier(referenceSourceElement, "");
    }

    @Override
    protected void setReferenceIdentifier(ModelElementInstance referenceSourceElement, String referenceIdentifier) {
        if (referenceIdentifier != null && !referenceIdentifier.isEmpty()) {
            super.setReferenceIdentifier(referenceSourceElement, referenceIdentifier);
        } else {
            this.referenceSourceAttribute.removeAttribute(referenceSourceElement);
        }
    }

    protected void performRemoveOperation(ModelElementInstance referenceSourceElement, Object o) {
        this.removeReference(referenceSourceElement, (ModelElementInstance)o);
    }

    protected void performAddOperation(ModelElementInstance referenceSourceElement, T referenceTargetElement) {
        String identifier = this.getReferenceIdentifier(referenceSourceElement);
        List<String> references = StringUtil.splitListBySeparator(identifier, this.separator);
        String targetIdentifier = this.getTargetElementIdentifier(referenceTargetElement);
        references.add(targetIdentifier);
        identifier = StringUtil.joinList(references, this.separator);
        this.setReferenceIdentifier(referenceSourceElement, identifier);
    }
}

