/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.junit.rules;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.event.EventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunStateFactory;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.DefaultCoverageTestRunStateFactory;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.MinimalCoverageMatcher;
import org.camunda.bpm.extension.process_test_coverage.listeners.CompensationEventCoverageHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.FlowNodeHistoryEventHandler;
import org.camunda.bpm.extension.process_test_coverage.listeners.PathCoverageParseListener;
import org.camunda.bpm.extension.process_test_coverage.model.AggregatedCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.ClassCoverage;
import org.camunda.bpm.extension.process_test_coverage.model.MethodCoverage;
import org.camunda.bpm.extension.process_test_coverage.util.Api;
import org.camunda.bpm.extension.process_test_coverage.util.CoverageReportUtil;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestCoverageProcessEngineRule
extends ProcessEngineRule {
    private static final Logger logger = Logger.getLogger(TestCoverageProcessEngineRule.class.getCanonicalName());
    private CoverageTestRunState coverageTestRunState;
    private final AtomicBoolean firstRun = new AtomicBoolean(true);
    private boolean detailedCoverageLogging = false;
    private boolean handleTestMethodCoverage = true;
    private boolean handleClassCoverage = true;
    private CoverageTestRunStateFactory coverageTestRunStateFactory = new DefaultCoverageTestRunStateFactory();
    private final Collection<Matcher<Double>> classCoverageAssertionMatchers = new LinkedList<Matcher<Double>>();
    private final Map<String, Collection<Matcher<Double>>> testMethodNameToCoverageMatchers = new HashMap<String, Collection<Matcher<Double>>>();
    private List<String> excludedProcessDefinitionKeys;

    TestCoverageProcessEngineRule() {
    }

    TestCoverageProcessEngineRule(ProcessEngine processEngine) {
        super(processEngine);
    }

    public void addTestMethodCoverageAssertionMatcher(String testMethodName, Matcher<Double> matcher) {
        Collection matchers = this.testMethodNameToCoverageMatchers.computeIfAbsent(testMethodName, k -> new LinkedList());
        matchers.add(matcher);
    }

    public void addClassCoverageAssertionMatcher(MinimalCoverageMatcher matcher) {
        this.classCoverageAssertionMatchers.add((Matcher<Double>)matcher);
    }

    public void setExcludedProcessDefinitionKeys(List<String> excludedProcessDefinitionKeys) {
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
    }

    public void starting(Description description) {
        this.validateClassRuleAnnotations(description);
        if (this.processEngine == null) {
            super.initializeProcessEngine();
        }
        this.initializeClassRunState(description);
        super.starting(description);
        if (this.isRelevantTestMethod(description)) {
            this.initializeMethodRunState(description);
            this.initializeMethodCoverage(description);
        }
    }

    public void finished(Description description) {
        if (this.handleTestMethodCoverage && this.isRelevantTestMethod(description)) {
            this.handleTestMethodCoverage(description);
        }
        if (this.handleClassCoverage && !description.isTest()) {
            this.handleClassCoverage(description);
        }
        if (this.identityService != null) {
            super.finished(description);
        }
    }

    private void validateClassRuleAnnotations(Description description) {
        if (!description.isTest() && this.firstRun.get()) {
            int numberOfCoverageRules = 0;
            for (Field field : description.getTestClass().getFields()) {
                Class<?> fieldType = field.getType();
                if (!((Object)((Object)this)).getClass().isAssignableFrom(fieldType)) continue;
                ++numberOfCoverageRules;
                boolean isClassRule = field.isAnnotationPresent(ClassRule.class);
                boolean isRule = field.isAnnotationPresent(Rule.class);
                if (!isClassRule || isRule) continue;
                throw new RuntimeException(((Object)((Object)this)).getClass().getCanonicalName() + " can only be used as a @ClassRule if it is also a @Rule!");
            }
            if (numberOfCoverageRules > 1) {
                throw new RuntimeException("Only one coverage rule can be used per test class!");
            }
        }
    }

    private void initializeMethodCoverage(Description description) {
        List deployedProcessDefinitions = this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(this.deploymentId).list();
        ArrayList<ProcessDefinition> relevantProcessDefinitions = new ArrayList<ProcessDefinition>();
        for (ProcessDefinition definition : deployedProcessDefinitions) {
            if (this.isExcluded(definition)) continue;
            relevantProcessDefinitions.add(definition);
        }
        this.coverageTestRunState.initializeTestMethodCoverage(this.processEngine, this.deploymentId, relevantProcessDefinitions, description.getMethodName());
    }

    private void initializeClassRunState(Description description) {
        if (this.firstRun.compareAndSet(true, false)) {
            this.coverageTestRunState = this.coverageTestRunStateFactory.create(description.getClassName(), this.excludedProcessDefinitionKeys);
            this.initializeListenerRunState();
        }
    }

    private void initializeMethodRunState(Description description) {
        this.coverageTestRunState.setCurrentTestMethodName(description.getMethodName());
    }

    private void initializeListenerRunState() {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        HistoryEventHandler historyEventHandler = processEngineConfiguration.getHistoryEventHandler();
        if (historyEventHandler instanceof FlowNodeHistoryEventHandler) {
            ((FlowNodeHistoryEventHandler)historyEventHandler).setCoverageTestRunState(this.coverageTestRunState);
        }
        if (Api.Camunda.supportsCustomHistoryEventHandlers()) {
            List historyEventHandlers = processEngineConfiguration.getCustomHistoryEventHandlers();
            for (HistoryEventHandler customHistoryEventHandler : historyEventHandlers) {
                if (!(customHistoryEventHandler instanceof FlowNodeHistoryEventHandler)) continue;
                ((FlowNodeHistoryEventHandler)customHistoryEventHandler).setCoverageTestRunState(this.coverageTestRunState);
            }
        }
        List bpmnParseListeners = processEngineConfiguration.getCustomPostBPMNParseListeners();
        for (BpmnParseListener parseListener : bpmnParseListeners) {
            if (!(parseListener instanceof PathCoverageParseListener)) continue;
            PathCoverageParseListener listener = (PathCoverageParseListener)parseListener;
            listener.setCoverageTestRunState(this.coverageTestRunState);
        }
        EventHandler compensationEventHandler = processEngineConfiguration.getEventHandler("compensate");
        if (compensationEventHandler != null && compensationEventHandler instanceof CompensationEventCoverageHandler) {
            CompensationEventCoverageHandler compensationEventCoverageHandler = (CompensationEventCoverageHandler)compensationEventHandler;
            compensationEventCoverageHandler.setCoverageTestRunState(this.coverageTestRunState);
        } else {
            logger.warning("CompensationEventCoverageHandler not registered with process engine configuration! Compensation boundary events coverage will not be registered.");
        }
    }

    private void handleTestMethodCoverage(Description description) {
        String testName = description.getMethodName();
        MethodCoverage testCoverage = this.coverageTestRunState.getTestMethodCoverage(testName);
        double coveragePercentage = testCoverage.getCoveragePercentage();
        logger.info(testName + " test method coverage is " + coveragePercentage);
        this.logCoverageDetail(testCoverage);
        CoverageReportUtil.createCurrentTestMethodReport(this.coverageTestRunState);
        if (this.testMethodNameToCoverageMatchers.containsKey(testName)) {
            this.assertCoverage(coveragePercentage, this.testMethodNameToCoverageMatchers.get(testName));
        }
    }

    private boolean isRelevantTestMethod(Description description) {
        return description.isTest() && this.deploymentId != null && this.processEngine.getRepositoryService().createProcessDefinitionQuery().deploymentId(this.deploymentId).list().stream().anyMatch(it -> !this.isExcluded((ProcessDefinition)it));
    }

    private void handleClassCoverage(Description description) {
        ClassCoverage classCoverage = this.coverageTestRunState.getClassCoverage();
        classCoverage.assertAllDeploymentsEqual();
        double classCoveragePercentage = classCoverage.getCoveragePercentage();
        logger.info(this.coverageTestRunState.getTestClassName() + " test class coverage is: " + classCoveragePercentage);
        this.logCoverageDetail(classCoverage);
        CoverageReportUtil.createClassReport(this.coverageTestRunState);
        this.assertCoverage(classCoveragePercentage, this.classCoverageAssertionMatchers);
    }

    private void assertCoverage(double coverage, Collection<Matcher<Double>> matchers) {
        for (Matcher<Double> matcher : matchers) {
            Assert.assertThat((Object)coverage, matcher);
        }
    }

    private void logCoverageDetail(AggregatedCoverage coverage) {
        if (logger.isLoggable(Level.FINE) || this.isDetailedCoverageLogging()) {
            logger.log(Level.INFO, coverage.toString());
        }
    }

    private boolean isExcluded(ProcessDefinition processDefinition) {
        if (this.excludedProcessDefinitionKeys != null) {
            return this.excludedProcessDefinitionKeys.contains(processDefinition.getKey());
        }
        return false;
    }

    public boolean isDetailedCoverageLogging() {
        return this.detailedCoverageLogging;
    }

    public void setDetailedCoverageLogging(boolean detailedCoverageLogging) {
        this.detailedCoverageLogging = detailedCoverageLogging;
    }

    public void setHandleTestMethodCoverage(boolean handleTestMethodCoverage) {
        this.handleTestMethodCoverage = handleTestMethodCoverage;
    }

    public void setHandleClassCoverage(boolean handleClassCoverage) {
        this.handleClassCoverage = handleClassCoverage;
    }

    public void setCoverageTestRunStateFactory(CoverageTestRunStateFactory coverageTestRunStateFactory) {
        this.coverageTestRunStateFactory = coverageTestRunStateFactory;
    }

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void succeeded(Description description) {
        super.succeeded(description);
        logger.info(description.getDisplayName() + " succeeded.");
    }

    protected void failed(Throwable e, Description description) {
        super.failed(e, description);
        logger.info(description.getDisplayName() + " failed.");
    }
}

