/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.validation.instruction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.migration.MigrationInstructionValidationReport;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanValidationReport;
import org.camunda.bpm.engine.migration.MigrationVariableValidationReport;

public class MigrationPlanValidationReportImpl
implements MigrationPlanValidationReport {
    protected MigrationPlan migrationPlan;
    protected List<MigrationInstructionValidationReport> instructionReports = new ArrayList<MigrationInstructionValidationReport>();
    protected Map<String, MigrationVariableValidationReport> variableReports = new HashMap<String, MigrationVariableValidationReport>();

    public MigrationPlanValidationReportImpl(MigrationPlan migrationPlan) {
        this.migrationPlan = migrationPlan;
    }

    @Override
    public MigrationPlan getMigrationPlan() {
        return this.migrationPlan;
    }

    @Override
    public boolean hasReports() {
        return this.hasVariableReports() || this.hasInstructionReports();
    }

    public void addInstructionReport(MigrationInstructionValidationReport instructionReport) {
        this.instructionReports.add(instructionReport);
    }

    public void addVariableReport(String variableName, MigrationVariableValidationReport variableReport) {
        this.variableReports.put(variableName, variableReport);
    }

    @Override
    public boolean hasInstructionReports() {
        return !this.instructionReports.isEmpty();
    }

    @Override
    public List<MigrationInstructionValidationReport> getInstructionReports() {
        return this.instructionReports;
    }

    @Override
    public boolean hasVariableReports() {
        return !this.variableReports.isEmpty();
    }

    @Override
    public Map<String, MigrationVariableValidationReport> getVariableReports() {
        return this.variableReports;
    }

    public void writeTo(StringBuilder sb) {
        sb.append("Migration plan for process definition '").append(this.migrationPlan.getSourceProcessDefinitionId()).append("' to '").append(this.migrationPlan.getTargetProcessDefinitionId()).append("' is not valid:\n");
        for (MigrationInstructionValidationReport instructionReport : this.instructionReports) {
            sb.append("\t Migration instruction ").append(instructionReport.getMigrationInstruction()).append(" is not valid:\n");
            for (String failure : instructionReport.getFailures()) {
                sb.append("\t\t").append(failure).append("\n");
            }
        }
        this.variableReports.forEach((name, report) -> {
            sb.append("\t Migration variable ").append((String)name).append(" is not valid:\n");
            for (String failure : report.getFailures()) {
                sb.append("\t\t").append(failure).append("\n");
            }
        });
    }
}

