/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.sql;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.sql.BatchDbSqlSession;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.db.sql.SimpleDbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;

public class DbSqlSessionFactory
implements SessionFactory {
    public static final String MSSQL = "mssql";
    public static final String DB2 = "db2";
    public static final String ORACLE = "oracle";
    public static final String H2 = "h2";
    public static final String MYSQL = "mysql";
    public static final String POSTGRES = "postgres";
    public static final String MARIADB = "mariadb";
    public static final String CRDB = "cockroachdb";
    public static final String[] SUPPORTED_DATABASES = new String[]{"mssql", "db2", "oracle", "h2", "mysql", "postgres", "mariadb", "cockroachdb"};
    protected static final Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> databaseSpecificLimitBeforeStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificInnerLimitAfterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenFilterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenAcquisitionStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeInUpdate = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterInUpdate = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificCountDistinctBeforeStart = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificCountDistinctBeforeEnd = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificCountDistinctAfterEnd = new HashMap<String, String>();
    public static final Map<String, String> optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificEscapeChar = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificOrderByStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeNativeQueryStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd1 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd2 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd3 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDatepart1 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDatepart2 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDatepart3 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDummyTable = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificIfNull = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificTrueConstant = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificFalseConstant = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDistinct = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificNumericCast = new HashMap<String, String>();
    public static final Map<String, Map<String, String>> dbSpecificConstants = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> databaseSpecificDaysComparator = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificCollationForCaseSensitivity = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificAuthJoinStart = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificAuthJoinEnd = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificAuthJoinSeparator = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificAuth1JoinStart = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificAuth1JoinEnd = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificAuth1JoinSeparator = new HashMap<String, String>();
    public static final int MAXIMUM_NUMBER_PARAMS = 2000;
    protected String databaseType;
    protected String databaseTablePrefix = "";
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected IdGenerator idGenerator;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected boolean isDbIdentityUsed = true;
    protected boolean isDbHistoryUsed = true;
    protected boolean cmmnEnabled = true;
    protected boolean dmnEnabled = true;
    protected boolean jdbcBatchProcessing;

    public DbSqlSessionFactory(boolean jdbcBatchProcessing) {
        this.jdbcBatchProcessing = jdbcBatchProcessing;
    }

    @Override
    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    @Override
    public Session openSession() {
        return this.jdbcBatchProcessing ? new BatchDbSqlSession(this) : new SimpleDbSqlSession(this);
    }

    public DbSqlSession openSession(Connection connection, String catalog, String schema) {
        return this.jdbcBatchProcessing ? new BatchDbSqlSession(this, connection, catalog, schema) : new SimpleDbSqlSession(this, connection, catalog, schema);
    }

    public String getInsertStatement(DbEntity object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getUpdateStatement(DbEntity object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.deleteStatements, "delete");
    }

    public String getSelectStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.selectStatements, "select");
    }

    private String getStatement(Class<?> persistentObjectClass, Map<Class<?>, String> cachedStatements, String prefix) {
        Object statement = cachedStatements.get(persistentObjectClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + ClassNameUtil.getClassNameWithoutPackage(persistentObjectClass);
        statement = ((String)statement).substring(0, ((String)statement).length() - 6);
        cachedStatements.put(persistentObjectClass, (String)statement);
        return statement;
    }

    protected static void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = databaseSpecificStatements.get(databaseType);
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public boolean isCmmnEnabled() {
        return this.cmmnEnabled;
    }

    public void setCmmnEnabled(boolean cmmnEnabled) {
        this.cmmnEnabled = cmmnEnabled;
    }

    public boolean isDmnEnabled() {
        return this.dmnEnabled;
    }

    public void setDmnEnabled(boolean dmnEnabled) {
        this.dmnEnabled = dmnEnabled;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    static {
        String defaultOrderBy = "order by ${internalOrderBy}";
        String defaultEscapeChar = "'\\'";
        String defaultDistinctCountBeforeStart = "select count(distinct";
        String defaultDistinctCountBeforeEnd = ")";
        String defaultDistinctCountAfterEnd = "";
        String defaultAuthOnStart = "IN (";
        String defaultAuthOnEnd = ")";
        String defaultAuthOnSeparator = ",";
        databaseSpecificLimitBeforeStatements.put(H2, "");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(H2, "");
        databaseSpecificLimitAfterStatements.put(H2, "LIMIT #{maxResults} OFFSET #{firstResult}");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(H2, "LIMIT #{maxResults}");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(H2, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(H2, "LIMIT #{maxResults}");
        databaseSpecificInnerLimitAfterStatements.put(H2, databaseSpecificLimitAfterStatements.get(H2));
        databaseSpecificLimitBetweenStatements.put(H2, "");
        databaseSpecificLimitBetweenFilterStatements.put(H2, "");
        databaseSpecificLimitBetweenAcquisitionStatements.put(H2, "");
        databaseSpecificLimitBeforeInUpdate.put(H2, "");
        databaseSpecificLimitAfterInUpdate.put(H2, "");
        databaseSpecificOrderByStatements.put(H2, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(H2, "");
        databaseSpecificDistinct.put(H2, "distinct");
        databaseSpecificNumericCast.put(H2, "");
        databaseSpecificCountDistinctBeforeStart.put(H2, defaultDistinctCountBeforeStart);
        databaseSpecificCountDistinctBeforeEnd.put(H2, defaultDistinctCountBeforeEnd);
        databaseSpecificCountDistinctAfterEnd.put(H2, defaultDistinctCountAfterEnd);
        databaseSpecificEscapeChar.put(H2, defaultEscapeChar);
        databaseSpecificBitAnd1.put(H2, "BITAND(");
        databaseSpecificBitAnd2.put(H2, ",CAST(");
        databaseSpecificBitAnd3.put(H2, " AS BIGINT))");
        databaseSpecificDatepart1.put(H2, "");
        databaseSpecificDatepart2.put(H2, "(");
        databaseSpecificDatepart3.put(H2, ")");
        databaseSpecificDummyTable.put(H2, "");
        databaseSpecificTrueConstant.put(H2, "true");
        databaseSpecificFalseConstant.put(H2, "false");
        databaseSpecificIfNull.put(H2, "IFNULL");
        databaseSpecificDaysComparator.put(H2, "DATEDIFF(DAY, ${date}, #{currentTimestamp}) >= ${days}");
        databaseSpecificCollationForCaseSensitivity.put(H2, "");
        databaseSpecificAuthJoinStart.put(H2, defaultAuthOnStart);
        databaseSpecificAuthJoinEnd.put(H2, defaultAuthOnEnd);
        databaseSpecificAuthJoinSeparator.put(H2, defaultAuthOnSeparator);
        databaseSpecificAuth1JoinStart.put(H2, defaultAuthOnStart);
        databaseSpecificAuth1JoinEnd.put(H2, defaultAuthOnEnd);
        databaseSpecificAuth1JoinSeparator.put(H2, defaultAuthOnSeparator);
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "NEW_VALUE_ || '_|_' || PROPERTY_");
        constants.put("constant_for_update", "for update");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "null START_TIME_");
        constants.put("constant.varchar.cast", "'${key}'");
        constants.put("constant.integer.cast", "NULL");
        constants.put("constant.null.reporter", "NULL AS REPORTER_");
        dbSpecificConstants.put(H2, constants);
        for (String mysqlLikeDatabase : Arrays.asList(MYSQL, MARIADB)) {
            databaseSpecificLimitBeforeStatements.put(mysqlLikeDatabase, "");
            optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitAfterStatements.put(mysqlLikeDatabase, "LIMIT #{maxResults} OFFSET #{firstResult}");
            optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(mysqlLikeDatabase, "LIMIT #{maxResults}");
            databaseSpecificLimitBeforeWithoutOffsetStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitAfterWithoutOffsetStatements.put(mysqlLikeDatabase, "LIMIT #{maxResults}");
            databaseSpecificInnerLimitAfterStatements.put(mysqlLikeDatabase, databaseSpecificLimitAfterStatements.get(mysqlLikeDatabase));
            databaseSpecificLimitBetweenStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitBetweenFilterStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitBetweenAcquisitionStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitBeforeInUpdate.put(mysqlLikeDatabase, "INNER JOIN ( SELECT ID_ FROM ");
            databaseSpecificLimitAfterInUpdate.put(mysqlLikeDatabase, databaseSpecificLimitAfterWithoutOffsetStatements.get(mysqlLikeDatabase) + ") tmp USING (ID_)");
            databaseSpecificOrderByStatements.put(mysqlLikeDatabase, defaultOrderBy);
            databaseSpecificLimitBeforeNativeQueryStatements.put(mysqlLikeDatabase, "");
            databaseSpecificDistinct.put(mysqlLikeDatabase, "distinct");
            databaseSpecificNumericCast.put(mysqlLikeDatabase, "");
            databaseSpecificCountDistinctBeforeStart.put(mysqlLikeDatabase, defaultDistinctCountBeforeStart);
            databaseSpecificCountDistinctBeforeEnd.put(mysqlLikeDatabase, defaultDistinctCountBeforeEnd);
            databaseSpecificCountDistinctAfterEnd.put(mysqlLikeDatabase, defaultDistinctCountAfterEnd);
            databaseSpecificEscapeChar.put(mysqlLikeDatabase, "'\\\\'");
            databaseSpecificBitAnd1.put(mysqlLikeDatabase, "");
            databaseSpecificBitAnd2.put(mysqlLikeDatabase, " & ");
            databaseSpecificBitAnd3.put(mysqlLikeDatabase, "");
            databaseSpecificDatepart1.put(mysqlLikeDatabase, "");
            databaseSpecificDatepart2.put(mysqlLikeDatabase, "(");
            databaseSpecificDatepart3.put(mysqlLikeDatabase, ")");
            databaseSpecificDummyTable.put(mysqlLikeDatabase, "");
            databaseSpecificTrueConstant.put(mysqlLikeDatabase, "1");
            databaseSpecificFalseConstant.put(mysqlLikeDatabase, "0");
            databaseSpecificIfNull.put(mysqlLikeDatabase, "IFNULL");
            databaseSpecificDaysComparator.put(mysqlLikeDatabase, "DATEDIFF(#{currentTimestamp}, ${date}) >= ${days}");
            databaseSpecificCollationForCaseSensitivity.put(mysqlLikeDatabase, "");
            databaseSpecificAuthJoinStart.put(mysqlLikeDatabase, "=");
            databaseSpecificAuthJoinEnd.put(mysqlLikeDatabase, "");
            databaseSpecificAuthJoinSeparator.put(mysqlLikeDatabase, "OR AUTH.RESOURCE_ID_ =");
            databaseSpecificAuth1JoinStart.put(mysqlLikeDatabase, "=");
            databaseSpecificAuth1JoinEnd.put(mysqlLikeDatabase, "");
            databaseSpecificAuth1JoinSeparator.put(mysqlLikeDatabase, "OR AUTH1.RESOURCE_ID_ =");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "toggleForeignKey", "toggleForeignKey_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "selectDeploymentsByQueryCriteria", "selectDeploymentsByQueryCriteria_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "selectDeploymentCountByQueryCriteria", "selectDeploymentCountByQueryCriteria_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteExceptionByteArraysByIds", "deleteExceptionByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteErrorDetailsByteArraysByIds", "deleteErrorDetailsByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDetailsByIds", "deleteHistoricDetailsByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDetailByteArraysByIds", "deleteHistoricDetailByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricIdentityLinksByTaskProcessInstanceIds", "deleteHistoricIdentityLinksByTaskProcessInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricIdentityLinksByTaskCaseInstanceIds", "deleteHistoricIdentityLinksByTaskCaseInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDecisionInputInstanceByteArraysByDecisionInstanceIds", "deleteHistoricDecisionInputInstanceByteArraysByDecisionInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDecisionOutputInstanceByteArraysByDecisionInstanceIds", "deleteHistoricDecisionOutputInstanceByteArraysByDecisionInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricVariableInstanceByIds", "deleteHistoricVariableInstanceByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricVariableInstanceByteArraysByIds", "deleteHistoricVariableInstanceByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteCommentsByIds", "deleteCommentsByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteAttachmentByteArraysByIds", "deleteAttachmentByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteAttachmentByIds", "deleteAttachmentByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricIncidentsByBatchIds", "deleteHistoricIncidentsByBatchIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateUserOperationLogByRootProcessInstanceId", "updateUserOperationLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByRootProcessInstanceId", "updateExternalTaskLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByRootProcessInstanceId", "updateHistoricIncidentsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByBatchId", "updateHistoricIncidentsByBatchId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateIdentityLinkLogByRootProcessInstanceId", "updateIdentityLinkLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateUserOperationLogByProcessInstanceId", "updateUserOperationLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByProcessInstanceId", "updateExternalTaskLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByProcessInstanceId", "updateHistoricIncidentsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateIdentityLinkLogByProcessInstanceId", "updateIdentityLinkLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateOperationLogAnnotationByOperationId", "updateOperationLogAnnotationByOperationId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateByteArraysByBatchId", "updateByteArraysByBatchId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateAttachmentsByRootProcessInstanceId", "updateAttachmentsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateAttachmentsByProcessInstanceId", "updateAttachmentsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateAuthorizationsByRootProcessInstanceId", "updateAuthorizationsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateAuthorizationsByProcessInstanceId", "updateAuthorizationsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateCommentsByRootProcessInstanceId", "updateCommentsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateCommentsByProcessInstanceId", "updateCommentsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricActivityInstancesByRootProcessInstanceId", "updateHistoricActivityInstancesByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricActivityInstancesByProcessInstanceId", "updateHistoricActivityInstancesByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDecisionInputInstancesByRootProcessInstanceId", "updateHistoricDecisionInputInstancesByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDecisionInputInstancesByProcessInstanceId", "updateHistoricDecisionInputInstancesByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDecisionInstancesByRootProcessInstanceId", "updateHistoricDecisionInstancesByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDecisionInstancesByProcessInstanceId", "updateHistoricDecisionInstancesByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDecisionOutputInstancesByRootProcessInstanceId", "updateHistoricDecisionOutputInstancesByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDecisionOutputInstancesByProcessInstanceId", "updateHistoricDecisionOutputInstancesByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDetailsByRootProcessInstanceId", "updateHistoricDetailsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricDetailsByProcessInstanceId", "updateHistoricDetailsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateJobLogByRootProcessInstanceId", "updateJobLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateJobLogByProcessInstanceId", "updateJobLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricProcessInstanceEventsByRootProcessInstanceId", "updateHistoricProcessInstanceEventsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricProcessInstanceByProcessInstanceId", "updateHistoricProcessInstanceByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricTaskInstancesByRootProcessInstanceId", "updateHistoricTaskInstancesByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricTaskInstancesByProcessInstanceId", "updateHistoricTaskInstancesByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricVariableInstancesByRootProcessInstanceId", "updateHistoricVariableInstancesByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricVariableInstancesByProcessInstanceId", "updateHistoricVariableInstancesByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateByteArraysByRootProcessInstanceId", "updateByteArraysByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateVariableByteArraysByProcessInstanceId", "updateVariableByteArraysByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateDecisionInputsByteArraysByProcessInstanceId", "updateDecisionInputsByteArraysByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateDecisionOutputsByteArraysByProcessInstanceId", "updateDecisionOutputsByteArraysByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateJobLogByteArraysByProcessInstanceId", "updateJobLogByteArraysByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByteArraysByProcessInstanceId", "updateExternalTaskLogByteArraysByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateAttachmentByteArraysByProcessInstanceId", "updateAttachmentByteArraysByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByRootProcessInstanceId", "updateExternalTaskLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByProcessInstanceId", "updateExternalTaskLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateIdentityLinkLogByRootProcessInstanceId", "updateIdentityLinkLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateIdentityLinkLogByProcessInstanceId", "updateIdentityLinkLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByRootProcessInstanceId", "updateHistoricIncidentsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByProcessInstanceId", "updateHistoricIncidentsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateUserOperationLogByRootProcessInstanceId", "updateUserOperationLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateUserOperationLogByProcessInstanceId", "updateUserOperationLogByProcessInstanceId_mysql");
            constants = new HashMap();
            constants.put("constant.event", "'event'");
            constants.put("constant.op_message", "CONCAT(NEW_VALUE_, '_|_', PROPERTY_)");
            constants.put("constant_for_update", "for update");
            constants.put("constant.datepart.quarter", "QUARTER");
            constants.put("constant.datepart.month", "MONTH");
            constants.put("constant.datepart.minute", "MINUTE");
            constants.put("constant.null.startTime", "null START_TIME_");
            constants.put("constant.varchar.cast", "'${key}'");
            constants.put("constant.integer.cast", "NULL");
            constants.put("constant.null.reporter", "NULL AS REPORTER_");
            dbSpecificConstants.put(mysqlLikeDatabase, constants);
        }
        for (String postgresLikeDatabase : Arrays.asList(POSTGRES, CRDB)) {
            databaseSpecificLimitBeforeStatements.put(postgresLikeDatabase, "");
            optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(postgresLikeDatabase, "");
            databaseSpecificLimitAfterStatements.put(postgresLikeDatabase, "LIMIT #{maxResults} OFFSET #{firstResult}");
            optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(postgresLikeDatabase, "LIMIT #{maxResults}");
            databaseSpecificLimitBeforeWithoutOffsetStatements.put(postgresLikeDatabase, "");
            databaseSpecificLimitAfterWithoutOffsetStatements.put(postgresLikeDatabase, "LIMIT #{maxResults}");
            databaseSpecificInnerLimitAfterStatements.put(postgresLikeDatabase, databaseSpecificLimitAfterStatements.get(postgresLikeDatabase));
            databaseSpecificLimitBetweenStatements.put(postgresLikeDatabase, "");
            databaseSpecificLimitBetweenFilterStatements.put(postgresLikeDatabase, "");
            databaseSpecificLimitBetweenAcquisitionStatements.put(postgresLikeDatabase, "");
            databaseSpecificLimitBeforeInUpdate.put(postgresLikeDatabase, "WHERE ID_ IN (SELECT ID_ FROM ");
            databaseSpecificLimitAfterInUpdate.put(postgresLikeDatabase, databaseSpecificLimitAfterWithoutOffsetStatements.get(postgresLikeDatabase) + ")");
            databaseSpecificOrderByStatements.put(postgresLikeDatabase, defaultOrderBy);
            databaseSpecificLimitBeforeNativeQueryStatements.put(postgresLikeDatabase, "");
            databaseSpecificDistinct.put(postgresLikeDatabase, "distinct");
            databaseSpecificCountDistinctBeforeStart.put(postgresLikeDatabase, "SELECT COUNT(*) FROM (SELECT DISTINCT");
            databaseSpecificCountDistinctBeforeEnd.put(postgresLikeDatabase, "");
            databaseSpecificCountDistinctAfterEnd.put(postgresLikeDatabase, ") countDistinct");
            databaseSpecificEscapeChar.put(postgresLikeDatabase, defaultEscapeChar);
            databaseSpecificBitAnd1.put(postgresLikeDatabase, "");
            databaseSpecificBitAnd2.put(postgresLikeDatabase, " & ");
            databaseSpecificBitAnd3.put(postgresLikeDatabase, "");
            databaseSpecificDatepart1.put(postgresLikeDatabase, "extract(");
            databaseSpecificDatepart2.put(postgresLikeDatabase, " from ");
            databaseSpecificDatepart3.put(postgresLikeDatabase, ")");
            databaseSpecificDummyTable.put(postgresLikeDatabase, "");
            databaseSpecificTrueConstant.put(postgresLikeDatabase, "true");
            databaseSpecificFalseConstant.put(postgresLikeDatabase, "false");
            databaseSpecificIfNull.put(postgresLikeDatabase, "COALESCE");
            databaseSpecificCollationForCaseSensitivity.put(postgresLikeDatabase, "");
            databaseSpecificAuthJoinStart.put(postgresLikeDatabase, defaultAuthOnStart);
            databaseSpecificAuthJoinEnd.put(postgresLikeDatabase, defaultAuthOnEnd);
            databaseSpecificAuthJoinSeparator.put(postgresLikeDatabase, defaultAuthOnSeparator);
            databaseSpecificAuth1JoinStart.put(postgresLikeDatabase, defaultAuthOnStart);
            databaseSpecificAuth1JoinEnd.put(postgresLikeDatabase, defaultAuthOnEnd);
            databaseSpecificAuth1JoinSeparator.put(postgresLikeDatabase, defaultAuthOnSeparator);
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "insertByteArray", "insertByteArray_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateByteArray", "updateByteArray_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectByteArray", "selectByteArray_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectByteArrays", "selectByteArrays_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectResourceByDeploymentIdAndResourceNames", "selectResourceByDeploymentIdAndResourceNames_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectResourceByDeploymentIdAndResourceId", "selectResourceByDeploymentIdAndResourceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectResourceByDeploymentIdAndResourceIds", "selectResourceByDeploymentIdAndResourceIds_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectResourcesByDeploymentId", "selectResourcesByDeploymentId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectResourceById", "selectResourceById_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectLatestResourcesByDeploymentName", "selectLatestResourcesByDeploymentName_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "insertIdentityInfo", "insertIdentityInfo_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateIdentityInfo", "updateIdentityInfo_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectIdentityInfoById", "selectIdentityInfoById_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectIdentityInfoByUserIdAndKey", "selectIdentityInfoByUserIdAndKey_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectIdentityInfoByUserId", "selectIdentityInfoByUserId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectIdentityInfoDetails", "selectIdentityInfoDetails_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "insertComment", "insertComment_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectCommentsByTaskId", "selectCommentsByTaskId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectCommentsByProcessInstanceId", "selectCommentsByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectCommentByTaskIdAndCommentId", "selectCommentByTaskIdAndCommentId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectEventsByTaskId", "selectEventsByTaskId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectFilterByQueryCriteria", "selectFilterByQueryCriteria_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "selectFilter", "selectFilter_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteAttachmentsByRemovalTime", "deleteAttachmentsByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteCommentsByRemovalTime", "deleteCommentsByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricActivityInstancesByRemovalTime", "deleteHistoricActivityInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricDecisionInputInstancesByRemovalTime", "deleteHistoricDecisionInputInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricDecisionInstancesByRemovalTime", "deleteHistoricDecisionInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricDecisionOutputInstancesByRemovalTime", "deleteHistoricDecisionOutputInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricDetailsByRemovalTime", "deleteHistoricDetailsByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteExternalTaskLogByRemovalTime", "deleteExternalTaskLogByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricIdentityLinkLogByRemovalTime", "deleteHistoricIdentityLinkLogByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricIncidentsByRemovalTime", "deleteHistoricIncidentsByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteJobLogByRemovalTime", "deleteJobLogByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricProcessInstancesByRemovalTime", "deleteHistoricProcessInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricTaskInstancesByRemovalTime", "deleteHistoricTaskInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricVariableInstancesByRemovalTime", "deleteHistoricVariableInstancesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteUserOperationLogByRemovalTime", "deleteUserOperationLogByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteHistoricBatchesByRemovalTime", "deleteHistoricBatchesByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteAuthorizationsByRemovalTime", "deleteAuthorizationsByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "deleteTaskMetricsByRemovalTime", "deleteTaskMetricsByRemovalTime_postgres_or_db2");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateAttachmentsByRootProcessInstanceId", "updateAttachmentsByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateAttachmentsByProcessInstanceId", "updateAttachmentsByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateAuthorizationsByRootProcessInstanceId", "updateAuthorizationsByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateAuthorizationsByProcessInstanceId", "updateAuthorizationsByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateCommentsByRootProcessInstanceId", "updateCommentsByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateCommentsByProcessInstanceId", "updateCommentsByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricActivityInstancesByRootProcessInstanceId", "updateHistoricActivityInstancesByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricActivityInstancesByProcessInstanceId", "updateHistoricActivityInstancesByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDecisionInputInstancesByRootProcessInstanceId", "updateHistoricDecisionInputInstancesByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDecisionInputInstancesByProcessInstanceId", "updateHistoricDecisionInputInstancesByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDecisionInstancesByRootProcessInstanceId", "updateHistoricDecisionInstancesByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDecisionInstancesByProcessInstanceId", "updateHistoricDecisionInstancesByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDecisionOutputInstancesByRootProcessInstanceId", "updateHistoricDecisionOutputInstancesByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDecisionOutputInstancesByProcessInstanceId", "updateHistoricDecisionOutputInstancesByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDetailsByRootProcessInstanceId", "updateHistoricDetailsByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricDetailsByProcessInstanceId", "updateHistoricDetailsByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateJobLogByRootProcessInstanceId", "updateJobLogByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateJobLogByProcessInstanceId", "updateJobLogByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricProcessInstanceEventsByRootProcessInstanceId", "updateHistoricProcessInstanceEventsByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricProcessInstanceByProcessInstanceId", "updateHistoricProcessInstanceByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricTaskInstancesByRootProcessInstanceId", "updateHistoricTaskInstancesByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricTaskInstancesByProcessInstanceId", "updateHistoricTaskInstancesByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricVariableInstancesByRootProcessInstanceId", "updateHistoricVariableInstancesByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricVariableInstancesByProcessInstanceId", "updateHistoricVariableInstancesByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateByteArraysByRootProcessInstanceId", "updateByteArraysByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateVariableByteArraysByProcessInstanceId", "updateVariableByteArraysByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateDecisionInputsByteArraysByProcessInstanceId", "updateDecisionInputsByteArraysByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateDecisionOutputsByteArraysByProcessInstanceId", "updateDecisionOutputsByteArraysByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateJobLogByteArraysByProcessInstanceId", "updateJobLogByteArraysByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateExternalTaskLogByteArraysByProcessInstanceId", "updateExternalTaskLogByteArraysByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateAttachmentByteArraysByProcessInstanceId", "updateAttachmentByteArraysByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateExternalTaskLogByRootProcessInstanceId", "updateExternalTaskLogByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateExternalTaskLogByProcessInstanceId", "updateExternalTaskLogByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateIdentityLinkLogByRootProcessInstanceId", "updateIdentityLinkLogByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateIdentityLinkLogByProcessInstanceId", "updateIdentityLinkLogByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricIncidentsByRootProcessInstanceId", "updateHistoricIncidentsByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateHistoricIncidentsByProcessInstanceId", "updateHistoricIncidentsByProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateUserOperationLogByRootProcessInstanceId", "updateUserOperationLogByRootProcessInstanceId_postgres");
            DbSqlSessionFactory.addDatabaseSpecificStatement(postgresLikeDatabase, "updateUserOperationLogByProcessInstanceId", "updateUserOperationLogByProcessInstanceId_postgres");
            constants = new HashMap();
            constants.put("constant.event", "'event'");
            constants.put("constant.op_message", "NEW_VALUE_ || '_|_' || PROPERTY_");
            constants.put("constant_for_update", "for update");
            constants.put("constant.datepart.quarter", "QUARTER");
            constants.put("constant.datepart.month", "MONTH");
            constants.put("constant.datepart.minute", "MINUTE");
            constants.put("constant.null.startTime", "null START_TIME_");
            constants.put("constant.varchar.cast", "cast('${key}' as varchar(64))");
            constants.put("constant.integer.cast", "cast(NULL as integer)");
            constants.put("constant.null.reporter", "CAST(NULL AS VARCHAR) AS REPORTER_");
            dbSpecificConstants.put(postgresLikeDatabase, constants);
        }
        databaseSpecificDaysComparator.put(POSTGRES, "EXTRACT (DAY FROM #{currentTimestamp} - ${date}) >= ${days}");
        databaseSpecificNumericCast.put(POSTGRES, "");
        databaseSpecificDaysComparator.put(CRDB, "CAST( EXTRACT (HOUR FROM #{currentTimestamp} - ${date}) / 24 AS INT ) >= ${days}");
        databaseSpecificNumericCast.put(CRDB, "::NUMERIC");
        databaseSpecificLimitBeforeStatements.put(ORACLE, "select * from ( select a.*, ROWNUM rnum from (");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(ORACLE, "select * from ( select a.*, ROWNUM rnum from (");
        databaseSpecificLimitAfterStatements.put(ORACLE, "  ) a where ROWNUM < #{lastRow}) where rnum  >= #{firstRow}");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(ORACLE, "  ) a where ROWNUM <= #{maxResults})");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(ORACLE, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(ORACLE, "AND ROWNUM <= #{maxResults}");
        databaseSpecificInnerLimitAfterStatements.put(ORACLE, databaseSpecificLimitAfterStatements.get(ORACLE));
        databaseSpecificLimitBetweenStatements.put(ORACLE, "");
        databaseSpecificLimitBetweenFilterStatements.put(ORACLE, "");
        databaseSpecificLimitBetweenAcquisitionStatements.put(ORACLE, "");
        databaseSpecificLimitBeforeInUpdate.put(ORACLE, "");
        databaseSpecificLimitAfterInUpdate.put(ORACLE, "");
        databaseSpecificOrderByStatements.put(ORACLE, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(ORACLE, "");
        databaseSpecificDistinct.put(ORACLE, "distinct");
        databaseSpecificNumericCast.put(ORACLE, "");
        databaseSpecificCountDistinctBeforeStart.put(ORACLE, defaultDistinctCountBeforeStart);
        databaseSpecificCountDistinctBeforeEnd.put(ORACLE, defaultDistinctCountBeforeEnd);
        databaseSpecificCountDistinctAfterEnd.put(ORACLE, defaultDistinctCountAfterEnd);
        databaseSpecificEscapeChar.put(ORACLE, defaultEscapeChar);
        databaseSpecificDummyTable.put(ORACLE, "FROM DUAL");
        databaseSpecificBitAnd1.put(ORACLE, "BITAND(");
        databaseSpecificBitAnd2.put(ORACLE, ",");
        databaseSpecificBitAnd3.put(ORACLE, ")");
        databaseSpecificDatepart1.put(ORACLE, "to_number(to_char(");
        databaseSpecificDatepart2.put(ORACLE, ",");
        databaseSpecificDatepart3.put(ORACLE, "))");
        databaseSpecificTrueConstant.put(ORACLE, "1");
        databaseSpecificFalseConstant.put(ORACLE, "0");
        databaseSpecificIfNull.put(ORACLE, "NVL");
        databaseSpecificDaysComparator.put(ORACLE, "${date} <= #{currentTimestamp} - ${days}");
        databaseSpecificCollationForCaseSensitivity.put(ORACLE, "");
        databaseSpecificAuthJoinStart.put(ORACLE, defaultAuthOnStart);
        databaseSpecificAuthJoinEnd.put(ORACLE, defaultAuthOnEnd);
        databaseSpecificAuthJoinSeparator.put(ORACLE, defaultAuthOnSeparator);
        databaseSpecificAuth1JoinStart.put(ORACLE, defaultAuthOnStart);
        databaseSpecificAuth1JoinEnd.put(ORACLE, defaultAuthOnEnd);
        databaseSpecificAuth1JoinSeparator.put(ORACLE, defaultAuthOnSeparator);
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricProcessInstanceDurationReport", "selectHistoricProcessInstanceDurationReport_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricTaskInstanceDurationReport", "selectHistoricTaskInstanceDurationReport_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricTaskInstanceCountByTaskNameReport", "selectHistoricTaskInstanceCountByTaskNameReport_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectFilterByQueryCriteria", "selectFilterByQueryCriteria_oracleDb2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricProcessInstanceIdsForCleanup", "selectHistoricProcessInstanceIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricDecisionInstanceIdsForCleanup", "selectHistoricDecisionInstanceIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricCaseInstanceIdsForCleanup", "selectHistoricCaseInstanceIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricBatchIdsForCleanup", "selectHistoricBatchIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectTaskMetricIdsForCleanup", "selectTaskMetricIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteAttachmentsByRemovalTime", "deleteAttachmentsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteCommentsByRemovalTime", "deleteCommentsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricActivityInstancesByRemovalTime", "deleteHistoricActivityInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDecisionInputInstancesByRemovalTime", "deleteHistoricDecisionInputInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDecisionInstancesByRemovalTime", "deleteHistoricDecisionInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDecisionOutputInstancesByRemovalTime", "deleteHistoricDecisionOutputInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDetailsByRemovalTime", "deleteHistoricDetailsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteExternalTaskLogByRemovalTime", "deleteExternalTaskLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricIdentityLinkLogByRemovalTime", "deleteHistoricIdentityLinkLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricIncidentsByRemovalTime", "deleteHistoricIncidentsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteJobLogByRemovalTime", "deleteJobLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricProcessInstancesByRemovalTime", "deleteHistoricProcessInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricTaskInstancesByRemovalTime", "deleteHistoricTaskInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricVariableInstancesByRemovalTime", "deleteHistoricVariableInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteUserOperationLogByRemovalTime", "deleteUserOperationLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricBatchesByRemovalTime", "deleteHistoricBatchesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteAuthorizationsByRemovalTime", "deleteAuthorizationsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteTaskMetricsByRemovalTime", "deleteTaskMetricsByRemovalTime_oracle");
        constants = new HashMap();
        constants.put("constant.event", "cast('event' as nvarchar2(255))");
        constants.put("constant.op_message", "NEW_VALUE_ || '_|_' || PROPERTY_");
        constants.put("constant_for_update", "for update");
        constants.put("constant.datepart.quarter", "'Q'");
        constants.put("constant.datepart.month", "'MM'");
        constants.put("constant.datepart.minute", "'MI'");
        constants.put("constant.null.startTime", "null START_TIME_");
        constants.put("constant.varchar.cast", "'${key}'");
        constants.put("constant.integer.cast", "NULL");
        constants.put("constant.null.reporter", "NULL AS REPORTER_");
        dbSpecificConstants.put(ORACLE, constants);
        databaseSpecificLimitBeforeStatements.put(DB2, "SELECT SUB.* FROM (");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(DB2, "");
        databaseSpecificInnerLimitAfterStatements.put(DB2, ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitAfterStatements.put(DB2, databaseSpecificInnerLimitAfterStatements.get(DB2) + " ORDER BY SUB.rnk");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(DB2, "FETCH FIRST ${maxResults} ROWS ONLY");
        String db2LimitBetweenWithoutColumns = ", row_number() over (ORDER BY ${internalOrderBy}) rnk FROM ( select distinct ";
        databaseSpecificLimitBetweenStatements.put(DB2, db2LimitBetweenWithoutColumns + "RES.* ");
        databaseSpecificLimitBetweenFilterStatements.put(DB2, db2LimitBetweenWithoutColumns + "RES.ID_, RES.REV_, RES.RESOURCE_TYPE_, RES.NAME_, RES.OWNER_ ");
        databaseSpecificLimitBetweenAcquisitionStatements.put(DB2, db2LimitBetweenWithoutColumns + "RES.ID_, RES.REV_, RES.TYPE_, RES.LOCK_EXP_TIME_, RES.LOCK_OWNER_, RES.EXCLUSIVE_, RES.PROCESS_INSTANCE_ID_, RES.DUEDATE_, RES.PRIORITY_ ");
        databaseSpecificLimitBeforeInUpdate.put(DB2, "");
        databaseSpecificLimitAfterInUpdate.put(DB2, "");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(DB2, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(DB2, "FETCH FIRST ${maxResults} ROWS ONLY");
        databaseSpecificOrderByStatements.put(DB2, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(DB2, "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${internalOrderBy}) rnk FROM (");
        databaseSpecificDistinct.put(DB2, "");
        databaseSpecificNumericCast.put(DB2, "");
        databaseSpecificCountDistinctBeforeStart.put(DB2, defaultDistinctCountBeforeStart);
        databaseSpecificCountDistinctBeforeEnd.put(DB2, defaultDistinctCountBeforeEnd);
        databaseSpecificCountDistinctAfterEnd.put(DB2, defaultDistinctCountAfterEnd);
        databaseSpecificEscapeChar.put(DB2, defaultEscapeChar);
        databaseSpecificBitAnd1.put(DB2, "BITAND(");
        databaseSpecificBitAnd2.put(DB2, ", CAST(");
        databaseSpecificBitAnd3.put(DB2, " AS Integer))");
        databaseSpecificDatepart1.put(DB2, "");
        databaseSpecificDatepart2.put(DB2, "(");
        databaseSpecificDatepart3.put(DB2, ")");
        databaseSpecificDummyTable.put(DB2, "FROM SYSIBM.SYSDUMMY1");
        databaseSpecificTrueConstant.put(DB2, "1");
        databaseSpecificFalseConstant.put(DB2, "0");
        databaseSpecificIfNull.put(DB2, "NVL");
        databaseSpecificDaysComparator.put(DB2, "${date} + ${days} DAYS <= #{currentTimestamp}");
        databaseSpecificCollationForCaseSensitivity.put(DB2, "");
        databaseSpecificAuthJoinStart.put(DB2, defaultAuthOnStart);
        databaseSpecificAuthJoinEnd.put(DB2, defaultAuthOnEnd);
        databaseSpecificAuthJoinSeparator.put(DB2, defaultAuthOnSeparator);
        databaseSpecificAuth1JoinStart.put(DB2, defaultAuthOnStart);
        databaseSpecificAuth1JoinEnd.put(DB2, defaultAuthOnEnd);
        databaseSpecificAuth1JoinSeparator.put(DB2, defaultAuthOnSeparator);
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectMeterLogAggregatedByTimeInterval", "selectMeterLogAggregatedByTimeInterval_db2_or_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricCaseActivityInstanceByNativeQuery", "selectHistoricCaseActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricCaseInstanceByNativeQuery", "selectHistoricCaseInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricVariableInstanceByNativeQuery", "selectHistoricVariableInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectUserByNativeQuery", "selectUserByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricDecisionInstancesByNativeQuery", "selectHistoricDecisionInstancesByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectFilterByQueryCriteria", "selectFilterByQueryCriteria_oracleDb2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteAttachmentsByRemovalTime", "deleteAttachmentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteCommentsByRemovalTime", "deleteCommentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricActivityInstancesByRemovalTime", "deleteHistoricActivityInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDecisionInputInstancesByRemovalTime", "deleteHistoricDecisionInputInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDecisionInstancesByRemovalTime", "deleteHistoricDecisionInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDecisionOutputInstancesByRemovalTime", "deleteHistoricDecisionOutputInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDetailsByRemovalTime", "deleteHistoricDetailsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteExternalTaskLogByRemovalTime", "deleteExternalTaskLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricIdentityLinkLogByRemovalTime", "deleteHistoricIdentityLinkLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricIncidentsByRemovalTime", "deleteHistoricIncidentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteJobLogByRemovalTime", "deleteJobLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricProcessInstancesByRemovalTime", "deleteHistoricProcessInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricTaskInstancesByRemovalTime", "deleteHistoricTaskInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricVariableInstancesByRemovalTime", "deleteHistoricVariableInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteUserOperationLogByRemovalTime", "deleteUserOperationLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricBatchesByRemovalTime", "deleteHistoricBatchesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteAuthorizationsByRemovalTime", "deleteAuthorizationsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteTaskMetricsByRemovalTime", "deleteTaskMetricsByRemovalTime_postgres_or_db2");
        constants = new HashMap();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "CAST(CONCAT(CONCAT(COALESCE(NEW_VALUE_,''), '_|_'), COALESCE(PROPERTY_,'')) as varchar(255))");
        constants.put("constant_for_update", "for read only with rs use and keep update locks");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "CAST(NULL as timestamp) as START_TIME_");
        constants.put("constant.varchar.cast", "cast('${key}' as varchar(64))");
        constants.put("constant.integer.cast", "cast(NULL as integer)");
        constants.put("constant.null.reporter", "CAST(NULL AS VARCHAR(255)) AS REPORTER_");
        dbSpecificConstants.put(DB2, constants);
        databaseSpecificLimitBeforeStatements.put(MSSQL, "SELECT SUB.* FROM (");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(MSSQL, "");
        databaseSpecificInnerLimitAfterStatements.put(MSSQL, ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitAfterStatements.put(MSSQL, databaseSpecificInnerLimitAfterStatements.get(MSSQL) + " ORDER BY SUB.rnk");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(MSSQL, "");
        String mssqlLimitBetweenWithoutColumns = ", row_number() over (ORDER BY ${internalOrderBy}) rnk FROM ( select distinct ";
        databaseSpecificLimitBetweenStatements.put(MSSQL, mssqlLimitBetweenWithoutColumns + "RES.* ");
        databaseSpecificLimitBetweenFilterStatements.put(MSSQL, "");
        databaseSpecificLimitBetweenAcquisitionStatements.put(MSSQL, mssqlLimitBetweenWithoutColumns + "RES.ID_, RES.REV_, RES.TYPE_, RES.LOCK_EXP_TIME_, RES.LOCK_OWNER_, RES.EXCLUSIVE_, RES.PROCESS_INSTANCE_ID_, RES.DUEDATE_, RES.PRIORITY_ ");
        databaseSpecificLimitBeforeInUpdate.put(MSSQL, "");
        databaseSpecificLimitAfterInUpdate.put(MSSQL, "");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(MSSQL, "TOP (#{maxResults})");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(MSSQL, "");
        databaseSpecificOrderByStatements.put(MSSQL, "");
        databaseSpecificLimitBeforeNativeQueryStatements.put(MSSQL, "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${internalOrderBy}) rnk FROM (");
        databaseSpecificDistinct.put(MSSQL, "");
        databaseSpecificNumericCast.put(MSSQL, "");
        databaseSpecificCountDistinctBeforeStart.put(MSSQL, defaultDistinctCountBeforeStart);
        databaseSpecificCountDistinctBeforeEnd.put(MSSQL, defaultDistinctCountBeforeEnd);
        databaseSpecificCountDistinctAfterEnd.put(MSSQL, defaultDistinctCountAfterEnd);
        databaseSpecificEscapeChar.put(MSSQL, defaultEscapeChar);
        databaseSpecificBitAnd1.put(MSSQL, "");
        databaseSpecificBitAnd2.put(MSSQL, " &");
        databaseSpecificBitAnd3.put(MSSQL, "");
        databaseSpecificDatepart1.put(MSSQL, "datepart(");
        databaseSpecificDatepart2.put(MSSQL, ",");
        databaseSpecificDatepart3.put(MSSQL, ")");
        databaseSpecificDummyTable.put(MSSQL, "");
        databaseSpecificTrueConstant.put(MSSQL, "1");
        databaseSpecificFalseConstant.put(MSSQL, "0");
        databaseSpecificIfNull.put(MSSQL, "ISNULL");
        databaseSpecificDaysComparator.put(MSSQL, "DATEDIFF(DAY, ${date}, #{currentTimestamp}) >= ${days}");
        databaseSpecificCollationForCaseSensitivity.put(MSSQL, "COLLATE Latin1_General_CS_AS");
        databaseSpecificAuthJoinStart.put(MSSQL, defaultAuthOnStart);
        databaseSpecificAuthJoinEnd.put(MSSQL, defaultAuthOnEnd);
        databaseSpecificAuthJoinSeparator.put(MSSQL, defaultAuthOnSeparator);
        databaseSpecificAuth1JoinStart.put(MSSQL, defaultAuthOnStart);
        databaseSpecificAuth1JoinEnd.put(MSSQL, defaultAuthOnEnd);
        databaseSpecificAuth1JoinSeparator.put(MSSQL, defaultAuthOnSeparator);
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectMeterLogAggregatedByTimeInterval", "selectMeterLogAggregatedByTimeInterval_db2_or_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricCaseActivityInstanceByNativeQuery", "selectHistoricCaseActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricCaseInstanceByNativeQuery", "selectHistoricCaseInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricVariableInstanceByNativeQuery", "selectHistoricVariableInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectUserByNativeQuery", "selectUserByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockDeploymentLockProperty", "lockDeploymentLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockHistoryCleanupJobLockProperty", "lockHistoryCleanupJobLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockStartupLockProperty", "lockStartupLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockTelemetryLockProperty", "lockTelemetryLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockInstallationIdLockProperty", "lockInstallationIdLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectEventSubscriptionsByNameAndExecution", "selectEventSubscriptionsByNameAndExecution_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectEventSubscriptionsByExecutionAndType", "selectEventSubscriptionsByExecutionAndType_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricDecisionInstancesByNativeQuery", "selectHistoricDecisionInstancesByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateAttachmentsByRootProcessInstanceId", "updateAttachmentsByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateAttachmentsByProcessInstanceId", "updateAttachmentsByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateAuthorizationsByRootProcessInstanceId", "updateAuthorizationsByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateAuthorizationsByProcessInstanceId", "updateAuthorizationsByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateCommentsByRootProcessInstanceId", "updateCommentsByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateCommentsByProcessInstanceId", "updateCommentsByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricActivityInstancesByRootProcessInstanceId", "updateHistoricActivityInstancesByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricActivityInstancesByProcessInstanceId", "updateHistoricActivityInstancesByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricBatch", "updateHistoricBatch_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricBatchRemovalTimeById", "updateHistoricBatchRemovalTimeById_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInputInstancesByRootProcessInstanceId", "updateHistoricDecisionInputInstancesByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInputInstancesByProcessInstanceId", "updateHistoricDecisionInputInstancesByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInputInstancesByRootDecisionInstanceId", "updateHistoricDecisionInputInstancesByRootDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInputInstancesByDecisionInstanceId", "updateHistoricDecisionInputInstancesByDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInstancesByRootProcessInstanceId", "updateHistoricDecisionInstancesByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInstancesByProcessInstanceId", "updateHistoricDecisionInstancesByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInstancesByRootDecisionInstanceId", "updateHistoricDecisionInstancesByRootDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionInstancesByDecisionInstanceId", "updateHistoricDecisionInstancesByDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionOutputInstancesByRootProcessInstanceId", "updateHistoricDecisionOutputInstancesByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionOutputInstancesByProcessInstanceId", "updateHistoricDecisionOutputInstancesByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionOutputInstancesByRootDecisionInstanceId", "updateHistoricDecisionOutputInstancesByRootDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDecisionOutputInstancesByDecisionInstanceId", "updateHistoricDecisionOutputInstancesByDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDetailsByRootProcessInstanceId", "updateHistoricDetailsByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricDetailsByProcessInstanceId", "updateHistoricDetailsByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateExternalTaskLogByRootProcessInstanceId", "updateExternalTaskLogByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateExternalTaskLogByProcessInstanceId", "updateExternalTaskLogByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateIdentityLinkLogByRootProcessInstanceId", "updateIdentityLinkLogByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateIdentityLinkLogByProcessInstanceId", "updateIdentityLinkLogByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricIncidentsByRootProcessInstanceId", "updateHistoricIncidentsByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricIncidentsByProcessInstanceId", "updateHistoricIncidentsByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricIncidentsByBatchId", "updateHistoricIncidentsByBatchId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateJobLogByRootProcessInstanceId", "updateJobLogByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateJobLogByProcessInstanceId", "updateJobLogByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateJobLogByBatchId", "updateJobLogByBatchId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricProcessInstanceEventsByRootProcessInstanceId", "updateHistoricProcessInstanceEventsByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricProcessInstanceByProcessInstanceId", "updateHistoricProcessInstanceByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricTaskInstancesByRootProcessInstanceId", "updateHistoricTaskInstancesByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricTaskInstancesByProcessInstanceId", "updateHistoricTaskInstancesByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricVariableInstancesByRootProcessInstanceId", "updateHistoricVariableInstancesByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateHistoricVariableInstancesByProcessInstanceId", "updateHistoricVariableInstancesByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateUserOperationLogByRootProcessInstanceId", "updateUserOperationLogByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateUserOperationLogByProcessInstanceId", "updateUserOperationLogByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateByteArraysByRootProcessInstanceId", "updateByteArraysByRootProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateVariableByteArraysByProcessInstanceId", "updateVariableByteArraysByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateDecisionInputsByteArraysByProcessInstanceId", "updateDecisionInputsByteArraysByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateDecisionOutputsByteArraysByProcessInstanceId", "updateDecisionOutputsByteArraysByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateJobLogByteArraysByProcessInstanceId", "updateJobLogByteArraysByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateExternalTaskLogByteArraysByProcessInstanceId", "updateExternalTaskLogByteArraysByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateAttachmentByteArraysByProcessInstanceId", "updateAttachmentByteArraysByProcessInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateDecisionInputByteArraysByRootDecisionInstanceId", "updateDecisionInputByteArraysByRootDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateDecisionOutputByteArraysByRootDecisionInstanceId", "updateDecisionOutputByteArraysByRootDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateDecisionInputByteArraysByDecisionInstanceId", "updateDecisionInputByteArraysByDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateDecisionOutputByteArraysByDecisionInstanceId", "updateDecisionOutputByteArraysByDecisionInstanceId_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "updateByteArraysByBatchId", "updateByteArraysByBatchId_mssql");
        constants = new HashMap();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "NEW_VALUE_ + '_|_' + PROPERTY_");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "CAST(NULL AS datetime2) AS START_TIME_");
        constants.put("constant.varchar.cast", "'${key}'");
        constants.put("constant.integer.cast", "NULL");
        constants.put("constant.null.reporter", "NULL AS REPORTER_");
        dbSpecificConstants.put(MSSQL, constants);
    }
}

