/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;

public abstract class AbstractSetStateCmd
implements Command<Void> {
    protected static final String SUSPENSION_STATE_PROPERTY = "suspensionState";
    protected boolean includeSubResources;
    protected boolean isLogUserOperationDisabled;
    protected Date executionDate;

    public AbstractSetStateCmd(boolean includeSubResources, Date executionDate) {
        this.includeSubResources = includeSubResources;
        this.executionDate = executionDate;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.checkParameters(commandContext);
        this.checkAuthorization(commandContext);
        if (this.executionDate == null) {
            AbstractSetStateCmd cmd;
            this.updateSuspensionState(commandContext, this.getNewSuspensionState());
            if (this.isIncludeSubResources() && (cmd = this.getNextCommand()) != null) {
                cmd.disableLogUserOperation();
                commandContext.runWithoutAuthorization(cmd);
            }
            this.triggerHistoryEvent(commandContext);
        } else {
            this.scheduleSuspensionStateUpdate(commandContext);
        }
        if (!this.isLogUserOperationDisabled()) {
            this.logUserOperation(commandContext);
        }
        return null;
    }

    protected void triggerHistoryEvent(CommandContext commandContext) {
    }

    public void disableLogUserOperation() {
        this.isLogUserOperationDisabled = true;
    }

    protected boolean isLogUserOperationDisabled() {
        return this.isLogUserOperationDisabled;
    }

    protected boolean isIncludeSubResources() {
        return this.includeSubResources;
    }

    protected void scheduleSuspensionStateUpdate(CommandContext commandContext) {
        TimerEntity timer = new TimerEntity();
        JobHandlerConfiguration jobHandlerConfiguration = this.getJobHandlerConfiguration();
        timer.setDuedate(this.executionDate);
        timer.setJobHandlerType(this.getDelayedExecutionJobHandlerType());
        timer.setJobHandlerConfigurationRaw(jobHandlerConfiguration.toCanonicalString());
        timer.setDeploymentId(this.getDeploymentId(commandContext));
        commandContext.getJobManager().schedule(timer);
    }

    protected String getDelayedExecutionJobHandlerType() {
        return null;
    }

    protected JobHandlerConfiguration getJobHandlerConfiguration() {
        return null;
    }

    protected AbstractSetStateCmd getNextCommand() {
        return null;
    }

    protected String getDeploymentId(CommandContext commandContext) {
        return null;
    }

    protected abstract void checkAuthorization(CommandContext var1);

    protected abstract void checkParameters(CommandContext var1);

    protected abstract void updateSuspensionState(CommandContext var1, SuspensionState var2);

    protected abstract void logUserOperation(CommandContext var1);

    protected abstract String getLogEntryOperation();

    protected abstract SuspensionState getNewSuspensionState();

    protected String getDeploymentIdByProcessDefinition(CommandContext commandContext, String processDefinitionId) {
        ProcessDefinitionEntity definition = commandContext.getProcessDefinitionManager().getCachedResourceDefinitionEntity(processDefinitionId);
        if (definition == null) {
            definition = commandContext.getProcessDefinitionManager().findLatestDefinitionById(processDefinitionId);
        }
        if (definition != null) {
            return definition.getDeploymentId();
        }
        return null;
    }

    protected String getDeploymentIdByProcessDefinitionKey(CommandContext commandContext, String processDefinitionKey, boolean tenantIdSet, String tenantId) {
        ProcessDefinitionEntity definition = null;
        if (tenantIdSet) {
            definition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        } else {
            List<ProcessDefinitionEntity> definitions = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionsByKey(processDefinitionKey);
            ProcessDefinitionEntity processDefinitionEntity = definition = definitions.isEmpty() ? null : definitions.get(0);
        }
        if (definition != null) {
            return definition.getDeploymentId();
        }
        return null;
    }

    protected String getDeploymentIdByJobDefinition(CommandContext commandContext, String jobDefinitionId) {
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        JobDefinitionEntity jobDefinition = jobDefinitionManager.findById(jobDefinitionId);
        if (jobDefinition != null && jobDefinition.getProcessDefinitionId() != null) {
            return this.getDeploymentIdByProcessDefinition(commandContext, jobDefinition.getProcessDefinitionId());
        }
        return null;
    }
}

