/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.AbstractTransactionProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ConfigurationLogger;
import org.camunda.bpm.engine.impl.cfg.jta.JtaTransactionContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.JtaTransactionInterceptor;

public class JtaProcessEngineConfiguration
extends AbstractTransactionProcessEngineConfiguration {
    private static final ConfigurationLogger LOG = ProcessEngineLogger.CONFIG_LOGGER;
    protected TransactionManager transactionManager;

    @Override
    protected CommandInterceptor createTransactionInterceptor(boolean requiresNew) {
        return new JtaTransactionInterceptor(this.transactionManager, requiresNew, this);
    }

    @Override
    protected void initTransactionManager() {
        if (this.transactionManager == null) {
            if (this.transactionManagerJndiName == null || this.transactionManagerJndiName.length() == 0) {
                throw LOG.invalidConfigTransactionManagerIsNull();
            }
            try {
                this.transactionManager = (TransactionManager)new InitialContext().lookup(this.transactionManagerJndiName);
            }
            catch (NamingException e) {
                throw LOG.invalidConfigCannotFindTransactionManger(this.transactionManagerJndiName + "'.", e);
            }
        }
    }

    @Override
    protected void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new JtaTransactionContextFactory(this.transactionManager);
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

