/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class AbstractSetJobRetriesCmd {
    protected static final String RETRIES = "retries";

    protected void setJobRetriesByJobId(String jobId, int retries, CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(jobId);
        if (job != null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateRetriesJob(job);
            }
            if (job.isInInconsistentLockState()) {
                job.resetLock();
            }
        } else {
            throw new ProcessEngineException("No job found with id '" + jobId + "'.");
        }
        int oldRetries = job.getRetries();
        job.setRetries(retries);
        PropertyChange propertyChange = new PropertyChange(RETRIES, oldRetries, job.getRetries());
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), job.getId(), job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), propertyChange);
    }

    protected String getLogEntryOperation() {
        return "SetJobRetries";
    }
}

