/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.io.Serializable;
import java.util.Set;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class ConditionalEventDefinition
extends EventSubscriptionDeclaration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String conditionAsString;
    protected final Condition condition;
    protected boolean interrupting;
    protected String variableName;
    protected Set<String> variableEvents;
    protected ActivityImpl conditionalActivity;

    public ConditionalEventDefinition(Condition condition, ActivityImpl conditionalActivity) {
        super(null, EventType.CONDITONAL);
        this.activityId = conditionalActivity.getActivityId();
        this.conditionalActivity = conditionalActivity;
        this.condition = condition;
    }

    public ActivityImpl getConditionalActivity() {
        return this.conditionalActivity;
    }

    public void setConditionalActivity(ActivityImpl conditionalActivity) {
        this.conditionalActivity = conditionalActivity;
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public Set<String> getVariableEvents() {
        return this.variableEvents;
    }

    public void setVariableEvents(Set<String> variableEvents) {
        this.variableEvents = variableEvents;
    }

    public String getConditionAsString() {
        return this.conditionAsString;
    }

    public void setConditionAsString(String conditionAsString) {
        this.conditionAsString = conditionAsString;
    }

    public boolean shouldEvaluateForVariableEvent(VariableEvent event) {
        return !(this.variableName != null && !event.getVariableInstance().getName().equals(this.variableName) || this.variableEvents != null && !this.variableEvents.isEmpty() && !this.variableEvents.contains(event.getEventName()));
    }

    public boolean evaluate(DelegateExecution execution) {
        if (this.condition != null) {
            return this.condition.evaluate(execution, execution);
        }
        throw new IllegalStateException("Conditional event must have a condition!");
    }

    public boolean tryEvaluate(DelegateExecution execution) {
        if (this.condition != null) {
            return this.condition.tryEvaluate(execution, execution);
        }
        throw new IllegalStateException("Conditional event must have a condition!");
    }

    public boolean tryEvaluate(VariableEvent variableEvent, DelegateExecution execution) {
        return (variableEvent == null || this.shouldEvaluateForVariableEvent(variableEvent)) && this.tryEvaluate(execution);
    }
}

