/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions.bpmn;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;
import org.camunda.bpm.engine.test.assertions.bpmn.BpmnAwareTests;

public abstract class AbstractAssertions {
    static ThreadLocal<ProcessEngine> processEngine = new ThreadLocal();

    public static ProcessEngine processEngine() {
        ProcessEngine processEngine = AbstractAssertions.processEngine.get();
        if (processEngine != null) {
            return processEngine;
        }
        Map processEngines = ProcessEngines.getProcessEngines();
        if (processEngines.size() == 1) {
            processEngine = (ProcessEngine)processEngines.values().iterator().next();
            AbstractAssertions.init(processEngine);
            return processEngine;
        }
        String message = processEngines.size() == 0 ? "No ProcessEngine found to be registered with " + ProcessEngines.class.getSimpleName() + "!" : String.format(processEngines.size() + " ProcessEngines initialized. Call %s.init(ProcessEngine processEngine) first!", BpmnAwareTests.class.getSimpleName());
        throw new IllegalStateException(message);
    }

    public static void init(ProcessEngine processEngine) {
        AbstractAssertions.processEngine.set(processEngine);
        AbstractProcessAssert.resetLastAsserts();
    }

    public static void reset() {
        processEngine.remove();
        AbstractProcessAssert.resetLastAsserts();
    }
}

