/*
 * Decompiled with CFR 0.152.
 */
package ti3-0-1.org.barfuin.texttree.api;

import java.util.EnumMap;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ti3-0-1.org.barfuin.texttree.api.Callout;
import ti3-0-1.org.barfuin.texttree.api.CycleProtection;
import ti3-0-1.org.barfuin.texttree.api.IdentityScheme;
import ti3-0-1.org.barfuin.texttree.api.Node;
import ti3-0-1.org.barfuin.texttree.api.color.ColorScheme;
import ti3-0-1.org.barfuin.texttree.api.color.DefaultColorScheme;
import ti3-0-1.org.barfuin.texttree.api.color.NoColorScheme;
import ti3-0-1.org.barfuin.texttree.api.style.AnnotationPosition;
import ti3-0-1.org.barfuin.texttree.api.style.TreeStyle;
import ti3-0-1.org.barfuin.texttree.api.style.TreeStyles;

public final class TreeOptions {
    private static final IdentityScheme DEFAULT_IDENTITY_SCHEME = IdentityScheme.ByIdentity;
    private static final TreeStyle DEFAULT_TREE_STYLE = TreeStyles.ASCII_ROUNDED;
    private static final CycleProtection DEFAULT_CYCLE_PROTECTION = CycleProtection.On;
    private static final ColorScheme NO_COLOR_SCHEME = new NoColorScheme();
    private static final AnnotationPosition DEFAULT_ANNOT_POS = AnnotationPosition.NextLine;
    private static final int DEFAULT_MAX_DEPTH = 100;
    private static final int DEFAULT_VERT_SPACING = 0;
    private IdentityScheme identityScheme = DEFAULT_IDENTITY_SCHEME;
    private TreeStyle style = DEFAULT_TREE_STYLE;
    private CycleProtection cycleProtection = DEFAULT_CYCLE_PROTECTION;
    private ColorScheme colorScheme = NO_COLOR_SCHEME;
    private AnnotationPosition annotationPosition = DEFAULT_ANNOT_POS;
    private int maxDepth = 100;
    private boolean cycleAsPruned = false;
    private int verticalSpacing = 0;
    private EnumMap<Callout, String> calloutOverrides = new EnumMap(Callout.class);
    private BiFunction<Callout, Node, String> calloutProcessor = null;

    @Nonnull
    public IdentityScheme getIdentityScheme() {
        return this.identityScheme;
    }

    public void setIdentityScheme(@Nullable IdentityScheme pIdentityScheme) {
        this.identityScheme = pIdentityScheme != null ? pIdentityScheme : DEFAULT_IDENTITY_SCHEME;
    }

    @Nonnull
    public TreeStyle getStyle() {
        return this.style;
    }

    public void setStyle(@Nullable TreeStyle pStyle) {
        this.style = pStyle != null ? pStyle : DEFAULT_TREE_STYLE;
    }

    @Nonnull
    public CycleProtection getCycleProtection() {
        return this.cycleProtection;
    }

    public void setCycleProtection(@Nullable CycleProtection pCycleProtection) {
        this.cycleProtection = pCycleProtection != null ? pCycleProtection : DEFAULT_CYCLE_PROTECTION;
    }

    public void setEnableDefaultColoring(boolean pEnableDefaultColoring) {
        this.colorScheme = pEnableDefaultColoring ? new DefaultColorScheme() : NO_COLOR_SCHEME;
    }

    @Nonnull
    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(@Nullable ColorScheme pColorScheme) {
        this.colorScheme = pColorScheme != null ? pColorScheme : NO_COLOR_SCHEME;
    }

    @Nonnull
    public AnnotationPosition getAnnotationPosition() {
        return this.annotationPosition;
    }

    public void setAnnotationPosition(@Nullable AnnotationPosition pAnnotationPosition) {
        this.annotationPosition = pAnnotationPosition != null ? pAnnotationPosition : DEFAULT_ANNOT_POS;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int pMaxDepth) {
        if (pMaxDepth < 0) {
            throw new IllegalArgumentException("max depth cannot be negative");
        }
        this.maxDepth = pMaxDepth;
    }

    public boolean isCycleAsPruned() {
        return this.cycleAsPruned;
    }

    public void setCycleAsPruned(boolean pCycleAsPruned) {
        this.cycleAsPruned = pCycleAsPruned;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int pVerticalSpacing) {
        if (pVerticalSpacing < 0) {
            throw new IllegalArgumentException("vertical spacing cannot be negative");
        }
        this.verticalSpacing = pVerticalSpacing;
    }

    public void setCalloutText(@Nonnull Callout pCalloutType, @Nullable String pText) {
        this.calloutOverrides.put(pCalloutType, pText);
    }

    @CheckForNull
    public String getCalloutText(@Nonnull Callout pCalloutType) {
        return this.calloutOverrides.get((Object)pCalloutType);
    }

    public void setCalloutProcessor(@Nullable BiFunction<Callout, Node, String> pCalloutProcessor) {
        this.calloutProcessor = pCalloutProcessor;
    }

    @CheckForNull
    public BiFunction<Callout, Node, String> getCalloutProcessor() {
        return this.calloutProcessor;
    }

    public static TreeOptions copyOf(@Nonnull TreeOptions pTreeOptions) {
        Objects.requireNonNull(pTreeOptions, "pTreeOptions must not be null");
        TreeOptions result = new TreeOptions();
        result.setIdentityScheme(pTreeOptions.getIdentityScheme());
        result.setStyle(pTreeOptions.getStyle());
        result.setCycleProtection(pTreeOptions.getCycleProtection());
        result.setColorScheme(pTreeOptions.getColorScheme());
        result.setAnnotationPosition(pTreeOptions.getAnnotationPosition());
        result.setMaxDepth(pTreeOptions.getMaxDepth());
        result.setCycleAsPruned(pTreeOptions.isCycleAsPruned());
        result.setVerticalSpacing(pTreeOptions.getVerticalSpacing());
        result.calloutOverrides = new EnumMap<Callout, String>(pTreeOptions.calloutOverrides);
        result.setCalloutProcessor(pTreeOptions.getCalloutProcessor());
        return result;
    }
}

