/*
 * Decompiled with CFR 0.152.
 */
package ti3-0-1.com.fasterxml.jackson.databind.ser.std;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import ti3-0-1.com.fasterxml.jackson.core.JsonGenerator;
import ti3-0-1.com.fasterxml.jackson.core.JsonParser;
import ti3-0-1.com.fasterxml.jackson.databind.JavaType;
import ti3-0-1.com.fasterxml.jackson.databind.JsonMappingException;
import ti3-0-1.com.fasterxml.jackson.databind.JsonNode;
import ti3-0-1.com.fasterxml.jackson.databind.SerializerProvider;
import ti3-0-1.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import ti3-0-1.com.fasterxml.jackson.databind.ser.std.ClassSerializer;
import ti3-0-1.com.fasterxml.jackson.databind.ser.std.FileSerializer;
import ti3-0-1.com.fasterxml.jackson.databind.ser.std.NullSerializer;
import ti3-0-1.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import ti3-0-1.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import ti3-0-1.com.fasterxml.jackson.databind.ser.std.UUIDSerializer;

public class StdJdkSerializers {
    public static Collection<Map.Entry<Class<?>, Object>> all() {
        HashMap<Class<Void>, Object> sers = new HashMap<Class<Void>, Object>();
        sers.put(URL.class, new ToStringSerializer(URL.class));
        sers.put(URI.class, new ToStringSerializer(URI.class));
        sers.put(Currency.class, new ToStringSerializer(Currency.class));
        sers.put(UUID.class, new UUIDSerializer());
        sers.put(Pattern.class, new ToStringSerializer(Pattern.class));
        sers.put(Locale.class, new ToStringSerializer(Locale.class));
        sers.put(AtomicBoolean.class, AtomicBooleanSerializer.class);
        sers.put(AtomicInteger.class, AtomicIntegerSerializer.class);
        sers.put(AtomicLong.class, AtomicLongSerializer.class);
        sers.put(File.class, FileSerializer.class);
        sers.put(Class.class, ClassSerializer.class);
        sers.put(Void.class, NullSerializer.instance);
        sers.put(Void.TYPE, NullSerializer.instance);
        return sers.entrySet();
    }

    public static class AtomicLongSerializer
    extends StdScalarSerializer<AtomicLong> {
        public AtomicLongSerializer() {
            super(AtomicLong.class, false);
        }

        @Override
        public void serialize(AtomicLong value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(value.get());
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("integer", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.LONG);
        }
    }

    public static class AtomicIntegerSerializer
    extends StdScalarSerializer<AtomicInteger> {
        public AtomicIntegerSerializer() {
            super(AtomicInteger.class, false);
        }

        @Override
        public void serialize(AtomicInteger value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(value.get());
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("integer", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }
    }

    public static class AtomicBooleanSerializer
    extends StdScalarSerializer<AtomicBoolean> {
        public AtomicBooleanSerializer() {
            super(AtomicBoolean.class, false);
        }

        @Override
        public void serialize(AtomicBoolean value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeBoolean(value.get());
        }

        @Override
        @Deprecated
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("boolean", true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            visitor.expectBooleanFormat(typeHint);
        }
    }
}

