/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.util;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.util.ReflectUtil;
import org.barfuin.gradle.taskinfo.util.TaskIdentityFactory;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;

@NotThreadSafe
public class TaskNodeHolder {
    private static final List<String> IGNORED_NODE_TYPES = Collections.singletonList("org.gradle.execution.plan.OrdinalNode");
    private final Project project;
    private final Object delegate;
    private final Task task;
    private String identity = null;
    private boolean isInternalNode = false;
    private boolean isTaskInAnotherBuild = false;

    public TaskNodeHolder(@Nonnull Project pProject, @Nonnull Object pDelegate) {
        this.project = Objects.requireNonNull(pProject, "pProject was null");
        this.delegate = Objects.requireNonNull(pDelegate, "pDelegate was null");
        this.task = pDelegate instanceof Task ? (Task)pDelegate : (ReflectUtil.hasField(pDelegate, "task") ? (Task)ReflectUtil.readField(this.delegate, "task field", Collections.singletonList("task")) : null);
    }

    public static boolean hasRelevantNodeType(@Nonnull Object pNode) {
        return !IGNORED_NODE_TYPES.contains(pNode.getClass().getName());
    }

    @CheckForNull
    public Task getTask() {
        return this.task;
    }

    public boolean isOneOfOurTasks() {
        return this.getTask() instanceof AbstractInfoTask;
    }

    public boolean isInternalNode() {
        if (this.identity == null) {
            throw new IllegalStateException("Bug: isInternalNode() called before getIdentity()");
        }
        return this.isInternalNode;
    }

    public boolean isTaskInAnotherBuild() {
        if (this.identity == null) {
            throw new IllegalStateException("Bug: isTaskInAnotherBuild() called before getIdentity()");
        }
        return this.isTaskInAnotherBuild;
    }

    @Nonnull
    public String getIdentity() {
        if (this.identity == null) {
            TaskIdentityFactory identityFactory = new TaskIdentityFactory(this.project);
            this.identity = identityFactory.forNode(this.delegate);
            this.isInternalNode = identityFactory.wasInternalNode();
            this.isTaskInAnotherBuild = identityFactory.wasTaskInAnotherBuild();
        }
        return this.identity;
    }

    public String getDisplayName() {
        return this.getTask() != null ? this.getTask().getName() : this.delegate.toString();
    }

    @Nonnull
    public Class<?> getType() {
        Class<?> result = this.delegate.getClass();
        if (this.getTask() != null) {
            result = this.readType(this.getTask());
        }
        return result;
    }

    @Nonnull
    private Class<?> readType(@Nonnull Task pTask) {
        Class<?> result = null;
        try {
            TaskIdentity taskIdentity = ((TaskInternal)pTask).getTaskIdentity();
            result = this.readTypeDirectly(taskIdentity);
        }
        catch (LinkageError | RuntimeException throwable) {
            // empty catch block
        }
        if (result == null) {
            result = pTask.getClass();
        }
        return result;
    }

    @Nonnull
    private Class<?> readTypeDirectly(@Nonnull TaskIdentity<?> pTaskIdentity) {
        return pTaskIdentity.type;
    }

    @Nonnull
    public List<TaskNodeHolder> getDependencySuccessors() {
        Iterable dependencies = (Iterable)ReflectUtil.callMethodIfPresent(this.delegate, "getDependencySuccessors", new Object[0]);
        if (!(dependencies != null && dependencies.iterator().hasNext() || this.task == null)) {
            dependencies = this.task.getTaskDependencies().getDependencies(this.task);
        }
        if (dependencies != null) {
            return this.wrapIntoList(dependencies);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<TaskNodeHolder> getFinalizers() {
        Iterable finalizerTasks = null;
        if (ReflectUtil.hasField(this.delegate, "finalizers")) {
            finalizerTasks = (Iterable)ReflectUtil.readField(this.delegate, "finalizer tasks", Collections.singletonList("finalizers"));
        }
        if (finalizerTasks == null || !finalizerTasks.iterator().hasNext()) {
            finalizerTasks = (Iterable)ReflectUtil.callMethodIfPresent(this.delegate, "getFinalizers", new Object[0]);
        }
        if (finalizerTasks != null) {
            return this.wrapIntoList(finalizerTasks);
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<TaskNodeHolder> wrapIntoList(@Nonnull Iterable<?> pNodes) {
        List<TaskNodeHolder> result = StreamSupport.stream(pNodes.spliterator(), false).filter(TaskNodeHolder::hasRelevantNodeType).map(node -> new TaskNodeHolder(this.project, node)).collect(Collectors.toList());
        return result;
    }

    @Nonnull
    public TaskInfoDto asTaskInfoDto(boolean pFinalizer, boolean pColorEnabled) {
        TaskInfoDto result = new TaskInfoDto(this.getIdentity(), pFinalizer, this.getTask() != null, pColorEnabled);
        result.setName(this.getDisplayName());
        result.setGroup(this.getTask() != null ? this.getTask().getGroup() : null);
        result.setType(this.getType().getName());
        return result;
    }
}

