/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.util;

import java.util.Collections;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.util.ReflectUtil;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.util.GradleVersion;

public class TaskIdentityFactory {
    private final Project project;
    private boolean wasInternalNode = false;
    private boolean wasTaskInAnotherBuild = false;

    public TaskIdentityFactory(@Nonnull Project pProject) {
        this.project = Objects.requireNonNull(pProject, "pProject was null");
    }

    @Nonnull
    public String forNode(@Nonnull Object pNode) {
        if (pNode instanceof Task) {
            return this.forTaskNode((Task)pNode);
        }
        Task task = this.tryReadTaskField(pNode);
        if (task != null) {
            return this.forTaskNode(task);
        }
        if (ReflectUtil.hasField(pNode, "action")) {
            this.wasInternalNode = true;
            return this.forActionNode(pNode);
        }
        if (ReflectUtil.hasField(pNode, "node")) {
            this.wasInternalNode = true;
            return this.forResolveMutationsNode(pNode);
        }
        if (ReflectUtil.hasField(pNode, "taskIdentityPath") || ReflectUtil.hasField(pNode, "task")) {
            this.wasTaskInAnotherBuild = true;
            if (ReflectUtil.hasField(pNode, "task")) {
                return this.forTaskNode((Task)ReflectUtil.readField(pNode, "task field", Collections.singletonList("task")));
            }
            return this.forTaskInAnotherBuild(pNode);
        }
        Object result = this.tryForTransformationNode(pNode);
        if (result == null) {
            this.wasInternalNode = true;
            result = "unknownNode" + this.getIdHash(pNode);
            this.project.getLogger().warn("WARNING: While working with Gradle's internal execution queue and task dependencies, we encountered a node of type '" + pNode.getClass().getName() + "' which is either an unknown type, or does not have expected fields. When this happens, it normally means you are using a new version of Gradle which is not fully supported by this plugin yet. You are using " + GradleVersion.current().toString() + ". Open an issue at https://gitlab.com/barfuin/gradle-taskinfo/-/issues. Thank you!");
        }
        return result;
    }

    @CheckForNull
    private Task tryReadTaskField(@Nonnull Object pNode) {
        if (!(!ReflectUtil.hasField(pNode, "task") || ReflectUtil.isInstanceOf("org.gradle.execution.plan.TaskInAnotherBuild", pNode) || ReflectUtil.isInstanceOf("org.gradle.execution.plan.TaskNode", pNode) && "TaskInAnotherBuild".equals(pNode.getClass().getSimpleName()) || ReflectUtil.isInstanceOf("org.gradle.execution.taskgraph.TaskInfo", pNode) && "TaskInAnotherBuild".equals(pNode.getClass().getSimpleName()))) {
            Task result = (Task)ReflectUtil.readField(pNode, "task field", Collections.singletonList("task"));
            if (!ReflectUtil.isInstanceOf("org.gradle.execution.taskgraph.TaskInfo", pNode) || !ReflectUtil.isInstanceOf("org.gradle.composite.internal.CompositeBuildTaskDelegate", result)) {
                return result;
            }
        }
        return null;
    }

    private String getPathWithSeparator(Project pProject) {
        Object result = pProject.getPath();
        if (!":".equals(result)) {
            result = (String)result + ":";
        }
        return result;
    }

    @Nonnull
    private String forTaskNode(@Nonnull Task pTask) {
        return ((TaskInternal)pTask).getIdentityPath().getPath();
    }

    @Nonnull
    private String forActionNode(@Nonnull Object pNode) {
        Project owningProject;
        Object result = null;
        Object action = ReflectUtil.readField(pNode, "work node action", Collections.singletonList("action"), true);
        if (action != null && (owningProject = (Project)ReflectUtil.callMethodIfPresent(action, "getOwningProject", new Object[0])) != null) {
            result = this.getPathWithSeparator(owningProject);
        }
        if (result == null) {
            result = "";
        }
        result = (String)result + "workNodeAction" + this.getIdHash(pNode);
        return result;
    }

    @Nonnull
    private String forResolveMutationsNode(@Nonnull Object pResolveMutationsNode) {
        Task task;
        String idHash = this.getIdHash(pResolveMutationsNode);
        Object taskNode = ReflectUtil.readField(pResolveMutationsNode, "task node", Collections.singletonList("node"), true);
        if (taskNode != null && (task = this.tryReadTaskField(taskNode)) != null) {
            return this.forTaskNode(task) + " (resolveMutations" + idHash + ")";
        }
        return "resolveMutations" + idHash;
    }

    @Nonnull
    private String forTaskInAnotherBuild(@Nonnull Object pNodeInAnotherBuild) {
        Object taskId = ReflectUtil.readField(pNodeInAnotherBuild, "task identity path", Collections.singletonList("taskIdentityPath"), false);
        return Objects.requireNonNull(taskId).toString();
    }

    @CheckForNull
    private String tryForTransformationNode(@Nonnull Object pTransformationNode) {
        Object projectInternal = ReflectUtil.callMethodIfPresent(pTransformationNode, "getOwningProject", new Object[0]);
        Object result = (String)ReflectUtil.callMethodIfPresent(projectInternal, "getPath", new Object[0]);
        if (result != null && !":".equals(result)) {
            result = (String)result + ":";
        }
        if (result != null) {
            this.wasInternalNode = true;
            result = (String)result + "transformationStep" + this.getIdHash(pTransformationNode);
        }
        return result;
    }

    private String getIdHash(@Nonnull Object pObject) {
        int minLen = 8;
        Object idHash = Integer.toHexString(System.identityHashCode(pObject));
        if (((String)idHash).length() < 8) {
            idHash = "00000000".substring(0, 8 - ((String)idHash).length()) + (String)idHash;
        }
        return idHash;
    }

    public boolean wasInternalNode() {
        return this.wasInternalNode;
    }

    public boolean wasTaskInAnotherBuild() {
        return this.wasTaskInAnotherBuild;
    }
}

