/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.EntryNodeProvider;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.TaskProbe;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import ti3-0-1.org.barfuin.texttree.api.CycleProtection;
import ti3-0-1.org.barfuin.texttree.api.IdentityScheme;
import ti3-0-1.org.barfuin.texttree.api.TextTree;
import ti3-0-1.org.barfuin.texttree.api.TreeOptions;
import ti3-0-1.org.barfuin.texttree.api.style.AnnotationPosition;

public abstract class AbstractTaskInfoTreeTask
extends AbstractInfoTask {
    private static final long NODES_COUNT_TO_FORCE_CLIPPED = 1000L;
    private final Property<Boolean> isAnyTaskFromAnotherBuild;
    private final Property<Boolean> isNonTaskNodesPresent;

    public AbstractTaskInfoTreeTask() {
        this.setDescription("Displays task dependencies of a given task as a tree, and their task types.");
        this.isAnyTaskFromAnotherBuild = this.getProject().getObjects().property(Boolean.class);
        this.isNonTaskNodesPresent = this.getProject().getObjects().property(Boolean.class);
    }

    @Override
    public void configureOnTaskGraph(@Nonnull TaskExecutionGraph pTaskGraph) {
        TaskNodeHolder entryNode = this.getEffectiveEntryNode(pTaskGraph);
        if (entryNode != null) {
            TaskProbe taskProbe = this.buildTaskProbe();
            this.getTaskInfo().set((Object)taskProbe.buildHierarchy(entryNode));
            this.getIsAnyTaskFromAnotherBuild().set((Object)taskProbe.isAnyTaskFromAnotherBuild());
            this.getIsNonTaskNodesPresent().set((Object)taskProbe.isNonTaskNodesPresent());
        }
    }

    @CheckForNull
    TaskNodeHolder getEffectiveEntryNode(@Nonnull TaskExecutionGraph pTaskGraph) {
        EntryNodeProvider ep = new EntryNodeProvider(this.getProject(), pTaskGraph);
        return ep.getEffectiveEntryNode();
    }

    @Override
    @TaskAction
    public void execute() {
        this.outputTaskInfo((TaskInfoDto)this.getTaskInfo().get());
        if (((Boolean)this.getIsNonTaskNodesPresent().get()).booleanValue() && ((Boolean)this.getCfgInternal().get()).booleanValue()) {
            this.printHintOnInternalNodes("Nodes", (Boolean)this.getCfgColor().get());
        }
        if (((Boolean)this.getIsAnyTaskFromAnotherBuild().get()).booleanValue()) {
            String msg = "The above includes at least one task from another build. Tasks from the included build(s) have probably been executed,\nand may not show their dependencies here. You are seeing this because taskinfo.disableSafeguard=true.";
            this.getLogger().lifecycle(msg);
        }
    }

    public TaskProbe buildTaskProbe() {
        return new TaskProbe(this.getProject(), (Boolean)this.getCfgColor().get(), (Boolean)this.getCfgInternal().get());
    }

    private void outputTaskInfo(TaskInfoDto pTaskInfo) {
        long nodesCount;
        boolean clipped = (Boolean)this.getCfgClipped().get();
        if (!clipped && (nodesCount = this.countTreeNodes(pTaskInfo)) > 1000L) {
            clipped = true;
            this.getLogger().lifecycle("The number of nodes in a fully expanded tree is {}, which exceeds a limit of {}. Repeated tasks will be collapsed by forcing the 'clipped' configuration option to 'true'.", new Object[]{nodesCount, 1000L});
        }
        TreeOptions options = this.buildTreeOptions(clipped);
        String tree = TextTree.newInstance(options).render(pTaskInfo);
        this.getLogger().lifecycle(tree);
    }

    private long countTreeNodes(@Nonnull TaskInfoDto pTaskInfo) {
        return 1L + pTaskInfo.getDependencies().stream().mapToLong(this::countTreeNodes).sum();
    }

    @Nonnull
    private TreeOptions buildTreeOptions(boolean pClipped) {
        TreeOptions options = new TreeOptions();
        options.setAnnotationPosition((Boolean)this.getCfgShowTaskTypes().get() != false ? AnnotationPosition.Aligned : AnnotationPosition.None);
        options.setEnableDefaultColoring((Boolean)this.getCfgColor().get());
        options.setIdentityScheme(IdentityScheme.ByKey);
        options.setCycleProtection(pClipped ? CycleProtection.PruneRepeating : CycleProtection.On);
        options.setCycleAsPruned(true);
        return options;
    }

    @Nonnull
    @Internal
    Property<Boolean> getIsAnyTaskFromAnotherBuild() {
        return this.isAnyTaskFromAnotherBuild;
    }

    @Nonnull
    @Internal
    Property<Boolean> getIsNonTaskNodesPresent() {
        return this.isNonTaskNodesPresent;
    }
}

