/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.ColorizableAppender;
import org.barfuin.gradle.taskinfo.EntryNodeProvider;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.TaskProbe;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskAction;
import ti3-0-1.org.apache.commons.lang3.StringUtils;

public abstract class AbstractTaskInfoOrderTask
extends AbstractInfoTask {
    private final ListProperty<TaskInfoDto> taskInfos;
    private final Property<Boolean> containsIncludedBuilds;
    private final Property<Boolean> isNonTaskNodesPresent;
    private final Property<String> entryNodeLabel;

    public AbstractTaskInfoOrderTask() {
        this.setDescription("Displays which tasks would be executed in what order for a given task, and their task types.");
        this.taskInfos = this.getProject().getObjects().listProperty(TaskInfoDto.class);
        this.containsIncludedBuilds = this.getProject().getObjects().property(Boolean.class);
        this.isNonTaskNodesPresent = this.getProject().getObjects().property(Boolean.class);
        this.entryNodeLabel = this.getProject().getObjects().property(String.class);
    }

    @Override
    public void configureOnTaskGraph(@Nonnull TaskExecutionGraph pTaskGraph) {
        EntryNodeProvider ep = new EntryNodeProvider(this.getProject(), pTaskGraph);
        this.entryNodeLabel.set((Object)ep.getLabel());
        TaskProbe taskProbe = new TaskProbe(this.getProject(), (Boolean)this.getCfgColor().get(), (Boolean)this.getCfgInternal().get());
        List<TaskNodeHolder> taskNodeHolders = taskProbe.buildOrder();
        this.taskInfos.set(taskNodeHolders.stream().map(th -> th.asTaskInfoDto(false, (Boolean)this.getCfgColor().get())).toList());
        this.containsIncludedBuilds.set((Object)(!this.getProject().getGradle().getIncludedBuilds().isEmpty() ? 1 : 0));
        this.isNonTaskNodesPresent.set((Object)taskProbe.isNonTaskNodesPresent());
    }

    @Override
    @TaskAction
    public void execute() {
        this.outputTaskInfo((List)this.taskInfos.get());
        if (((Boolean)this.isNonTaskNodesPresent.get()).booleanValue() && ((Boolean)this.getCfgInternal().get()).booleanValue()) {
            this.printHintOnInternalNodes("Items", (Boolean)this.getCfgColor().get());
        }
        if (((Boolean)this.containsIncludedBuilds.get()).booleanValue()) {
            String msg = "The above may be missing information on tasks from included builds. The tiTree task may have a little more information. You are seeing this because taskinfo.disableSafeguard=true.";
            this.getLogger().lifecycle(msg);
        }
    }

    private void outputTaskInfo(List<TaskInfoDto> pTaskInfos) {
        String output = this.renderTaskInfo(pTaskInfos);
        this.getLogger().lifecycle(output);
    }

    private String renderTaskInfo(List<TaskInfoDto> pTaskInfos) {
        int m = this.getLengthOfLongestTaskName(pTaskInfos);
        ColorizableAppender appender = new ColorizableAppender((Boolean)this.getCfgColor().get());
        appender.newline();
        appender.append("In order to execute [");
        appender.append((String)this.entryNodeLabel.get());
        appender.append("], the following tasks would be executed in this order:");
        appender.newline();
        appender.newline();
        for (int i = 0; i < pTaskInfos.size(); ++i) {
            TaskInfoDto taskInfo = pTaskInfos.get(i);
            String path = taskInfo.getPath();
            appender.colorNumbers();
            appender.append(String.format("%3d", i + 1));
            appender.append('.');
            appender.colorReset();
            appender.append(' ');
            if (!taskInfo.isTaskNode()) {
                appender.colorAnnotations();
            }
            appender.append(path);
            if (!taskInfo.isTaskNode()) {
                appender.colorReset();
            }
            if (((Boolean)this.getCfgShowTaskTypes().get()).booleanValue()) {
                appender.append(StringUtils.repeat(' ', m - path.length() + 1));
                appender.colorAnnotations();
                appender.append('(');
                appender.append(taskInfo.getType());
                appender.append(')');
                appender.colorReset();
            }
            appender.newline();
        }
        return appender.toString();
    }

    private int getLengthOfLongestTaskName(List<TaskInfoDto> pTaskInfos) {
        return Collections.max(pTaskInfos, Comparator.comparing(dto -> dto.getPath().length())).getPath().length();
    }
}

