/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.EntryNodeProvider;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.TaskProbe;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import ti3-0-1.com.fasterxml.jackson.databind.ObjectMapper;

public abstract class AbstractTaskInfoJsonTask
extends AbstractInfoTask {
    private RegularFileProperty outputFile = null;

    public AbstractTaskInfoJsonTask() {
        this.setDescription("Creates a JSON file with task dependencies of a given task, and their task types.");
        this.outputFile = this.getProject().getObjects().fileProperty();
    }

    @Override
    public void configureOnTaskGraph(@Nonnull TaskExecutionGraph pTaskGraph) {
        EntryNodeProvider ep = new EntryNodeProvider(this.getProject(), pTaskGraph);
        TaskNodeHolder entryNode = ep.getEffectiveEntryNode();
        if (entryNode != null) {
            Task entryTask = entryNode.getTask();
            this.outputFile.set(new File(((Directory)this.getProject().getLayout().getBuildDirectory().get()).getAsFile(), "taskinfo/taskinfo-" + (entryTask != null ? entryTask.getName() : "null") + ".json"));
            this.getTaskInfo().set((Object)new TaskProbe(this.getProject(), false, (Boolean)this.getCfgInternal().get()).buildHierarchy(entryNode));
        }
    }

    @Override
    @TaskAction
    public void execute() {
        try {
            Files.createDirectories(((RegularFile)this.outputFile.get()).getAsFile().getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GradleException("Failed to create directory: " + ((RegularFile)this.outputFile.get()).getAsFile().getParentFile().getAbsolutePath(), (Throwable)e);
        }
        this.outputTaskInfo();
    }

    private void outputTaskInfo() {
        try {
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(((RegularFile)this.outputFile.get()).getAsFile(), this.getTaskInfo().get());
        }
        catch (IOException | RuntimeException e) {
            throw new GradleException("Failed to write output JSON file: " + ((RegularFile)this.outputFile.get()).getAsFile().getAbsolutePath(), (Throwable)e);
        }
    }

    @Nonnull
    @Internal
    public Property<TaskInfoDto> getTaskInfoData() {
        return this.getTaskInfo();
    }

    @Nonnull
    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }
}

