/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.TaskInfoDto;
import org.barfuin.gradle.taskinfo.util.ReflectUtil;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;

public class TaskProbe {
    private final Project project;
    private final boolean cfgColor;
    private final boolean cfgInternal;
    private List<TaskNodeHolder> executionQueue = null;
    private boolean nonTaskNodesPresent = false;
    private boolean tasksFromAnotherBuildPresent = false;
    private final HashMap<String, TaskInfoDto> traversedTasks = new HashMap();

    public TaskProbe(@Nonnull Project pProject, boolean pCfgColor, boolean pCfgInternal) {
        this.project = Objects.requireNonNull(pProject, "Bug: constructor parameter 'pProject' was null");
        this.cfgColor = pCfgColor;
        this.cfgInternal = pCfgInternal;
    }

    TaskProbe(@Nonnull Project pProject, boolean pCfgColor, boolean pCfgInternal, List<TaskNodeHolder> pExecutionQueue) {
        this(pProject, pCfgColor, pCfgInternal);
        this.executionQueue = pExecutionQueue;
    }

    @Nonnull
    public TaskInfoDto buildHierarchy(@Nonnull TaskNodeHolder pEntryNode) {
        Objects.requireNonNull(pEntryNode, "Bug: Argument 'pEntryNode' was null");
        this.executionQueue = this.readExecutionQueue();
        Map<String, Integer> queueIndex = this.indexQueue(this.executionQueue);
        TaskInfoDto taskInfo = this.traverse(pEntryNode, queueIndex, false, new ArrayDeque<String>());
        return taskInfo;
    }

    @Nonnull
    public List<TaskNodeHolder> buildOrder() {
        return this.readExecutionQueue();
    }

    private List<TaskNodeHolder> readExecutionQueue() {
        if (this.executionQueue != null) {
            return this.executionQueue;
        }
        TaskExecutionGraph taskGraph = this.project.getGradle().getTaskGraph();
        Object executionPlan = ReflectUtil.getExecutionPlan(taskGraph);
        return this.getExecutionQueue(executionPlan);
    }

    @Nonnull
    private List<TaskNodeHolder> getExecutionQueue(@Nonnull Object pExecutionPlan) {
        Iterable<?> rawQueue = this.getRawQueue(pExecutionPlan);
        ArrayList<TaskNodeHolder> result = new ArrayList<TaskNodeHolder>();
        for (Object element : rawQueue) {
            if (!TaskNodeHolder.hasRelevantNodeType(element)) continue;
            TaskNodeHolder holder = new TaskNodeHolder(this.project, element);
            holder.getIdentity();
            if (holder.isInternalNode() && !this.cfgInternal) continue;
            if (holder.getTask() == null) {
                this.nonTaskNodesPresent = true;
            }
            if (holder.isOneOfOurTasks()) continue;
            result.add(holder);
        }
        return result;
    }

    @Nonnull
    private Iterable<?> getRawQueue(@Nonnull Object pExecutionPlan) {
        Object obj = ReflectUtil.readField(pExecutionPlan, "node mapping", List.of("nodeMapping"));
        Collection rawQueue = obj instanceof Map ? ((Map)obj).values() : (Collection)obj;
        return rawQueue;
    }

    private Map<String, Integer> indexQueue(@Nonnull List<TaskNodeHolder> pExecutionQueue) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(pExecutionQueue.size() + 1);
        for (int idx = 0; idx < pExecutionQueue.size(); ++idx) {
            String path = pExecutionQueue.get(idx).getIdentity();
            result.put(path, idx);
        }
        return result;
    }

    @Nonnull
    private TaskInfoDto traverse(@Nonnull TaskNodeHolder pTaskNode, @Nonnull Map<String, Integer> pQueueIndex, boolean pFinalizer, @Nonnull Deque<String> pPreviousNodeStack) {
        String path = pTaskNode.getIdentity();
        if (this.traversedTasks.containsKey(path)) {
            return this.traversedTasks.get(path);
        }
        if (pTaskNode.isInternalNode()) {
            this.nonTaskNodesPresent = true;
        }
        if (pTaskNode.isTaskInAnotherBuild()) {
            this.tasksFromAnotherBuildPresent = true;
        }
        TaskInfoDto result = pTaskNode.asTaskInfoDto(pFinalizer, this.cfgColor);
        if (pQueueIndex.containsKey(path)) {
            result.setQueuePosition(pQueueIndex.get(path) + 1);
        }
        if (!pPreviousNodeStack.contains(path)) {
            pPreviousNodeStack.push(path);
            for (TaskNodeHolder tn : pTaskNode.getDependencySuccessors()) {
                this.addDependency(result, this.traverse(tn, pQueueIndex, false, pPreviousNodeStack));
            }
            for (TaskNodeHolder tn : pTaskNode.getFinalizers()) {
                this.addDependency(result, this.traverse(tn, pQueueIndex, true, pPreviousNodeStack));
            }
            pPreviousNodeStack.pop();
        }
        this.traversedTasks.put(path, result);
        return result;
    }

    private void addDependency(@Nonnull TaskInfoDto pNode, @Nonnull TaskInfoDto pDependency) {
        if (pDependency.isTaskNode() || this.cfgInternal || this.isTaskInAnotherBuild(pDependency)) {
            pNode.addDependency(pDependency);
        } else {
            for (TaskInfoDto dep : pDependency.getDependencies()) {
                this.addDependency(pNode, dep);
            }
        }
    }

    private boolean isTaskInAnotherBuild(@Nonnull TaskInfoDto pNode) {
        return pNode.getType() != null && pNode.getType().startsWith("org.gradle.execution.plan.TaskInAnotherBuild");
    }

    public boolean isNonTaskNodesPresent() {
        return this.nonTaskNodesPresent;
    }

    public boolean isAnyTaskFromAnotherBuild() {
        return this.tasksFromAnotherBuildPresent;
    }
}

