/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.tools.ant.BuildException;
import org.barfuin.gradle.taskinfo.TaskInfoExtension;
import org.barfuin.gradle.taskinfo.tasks.AbstractInfoTask;
import org.barfuin.gradle.taskinfo.tasks.AbstractTaskInfoJsonTask;
import org.barfuin.gradle.taskinfo.tasks.AbstractTaskInfoOrderTask;
import org.barfuin.gradle.taskinfo.tasks.AbstractTaskInfoTreeTask;
import org.barfuin.gradle.taskinfo.util.GradleVersionUtil;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class GradleTaskInfoPlugin
implements Plugin<Project> {
    public static final String PLUGIN_ID = "org.barfuin.gradle.taskinfo";
    public static final String TASKINFO_TASK_NAME = "tiTree";
    public static final String TASKINFO_JSON_TASK_NAME = "tiJson";
    public static final String TASKINFO_ORDERED_TASK_NAME = "tiOrder";
    public static final String TASKINFO_EXT_NAME = "taskinfo";

    public void apply(@Nonnull Project pProject) {
        this.checkforIncludedBuilds(pProject);
        TaskContainer tasks = pProject.getTasks();
        TaskInfoExtension ext = (TaskInfoExtension)pProject.getExtensions().create(TASKINFO_EXT_NAME, TaskInfoExtension.class, new Object[0]);
        ArrayList<TaskProvider> ourTasks = new ArrayList<TaskProvider>();
        ourTasks.add(tasks.register(TASKINFO_TASK_NAME, AbstractTaskInfoTreeTask.class, t -> this.wireTaskConfig((AbstractInfoTask)((Object)t), ext)));
        ourTasks.add(tasks.register(TASKINFO_ORDERED_TASK_NAME, AbstractTaskInfoOrderTask.class, t -> this.wireTaskConfig((AbstractInfoTask)((Object)t), ext)));
        ourTasks.add(tasks.register(TASKINFO_JSON_TASK_NAME, AbstractTaskInfoJsonTask.class, t -> this.wireTaskConfig((AbstractInfoTask)((Object)t), ext)));
        pProject.getGradle().getTaskGraph().whenReady(executionGraph -> ourTasks.forEach(provider -> {
            provider.configure(t -> this.disableAllNormalTasks((TaskExecutionGraph)executionGraph, Collections.singletonList(t)));
            provider.configure(t -> t.configureOnTaskGraph((TaskExecutionGraph)executionGraph));
        }));
    }

    private void wireTaskConfig(@Nonnull AbstractInfoTask pTask, @Nonnull TaskInfoExtension pExt) {
        Project project = pTask.getProject();
        Provider overrideClipped = project.getProviders().gradleProperty("taskinfo.clipped").map(s -> s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s.trim())));
        pTask.getCfgClipped().set(overrideClipped.orElse(pExt.isClipped()));
        Provider overrideColor = project.getProviders().gradleProperty("taskinfo.color").map(s -> s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s.trim())));
        pTask.getCfgColor().set(overrideColor.orElse(pExt.isColor()));
        Provider overrideShowTaskTypes = project.getProviders().gradleProperty("taskinfo.showTaskTypes").map(s -> s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s.trim())));
        pTask.getCfgShowTaskTypes().set(overrideShowTaskTypes.orElse(pExt.isShowTaskTypes()));
        Provider overrideInternal = project.getProviders().gradleProperty("taskinfo.internal").map(s -> s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s.trim())));
        pTask.getCfgInternal().set(overrideInternal.orElse(pExt.isInternal()));
    }

    private void checkforIncludedBuilds(@Nonnull Project pProject) {
        if (this.isSafeguardActive(pProject) && !pProject.getGradle().getIncludedBuilds().isEmpty()) {
            throw new GradleException("The plugin 'org.barfuin.gradle.taskinfo' does not support composite builds at this time.\nYou can still run it by adding -Ptaskinfo.disableSafeguard=true to your Gradle invocation.In that case, tasks from the included builds will be executed.");
        }
    }

    private boolean isSafeguardActive(@Nonnull Project pProject) {
        boolean disabled = false;
        try {
            Object v = pProject.getProperties().get("taskinfo.disableSafeguard");
            disabled = v instanceof String && Boolean.parseBoolean((String)v);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        return !disabled;
    }

    private void disableAllNormalTasks(TaskExecutionGraph pExecutionGraph, List<AbstractInfoTask> pOurTasks) {
        AbstractInfoTask ourTask = this.findAnyOfOurTasks(pExecutionGraph, pOurTasks);
        if (ourTask != null) {
            GradleVersionUtil.validateMinimumGradleVersion(ourTask.getName());
            pExecutionGraph.getAllTasks().forEach(task -> {
                if (!(task instanceof AbstractInfoTask)) {
                    task.setEnabled(false);
                }
            });
        }
    }

    @CheckForNull
    private AbstractInfoTask findAnyOfOurTasks(TaskExecutionGraph pExecutionGraph, List<AbstractInfoTask> pOurTasks) {
        AbstractInfoTask result = null;
        for (AbstractInfoTask ourTask : pOurTasks) {
            if (!pExecutionGraph.hasTask((Task)ourTask)) continue;
            result = ourTask;
            break;
        }
        return result;
    }
}

