/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.gradle.taskinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.barfuin.gradle.taskinfo.util.ReflectUtil;
import org.barfuin.gradle.taskinfo.util.TaskNodeHolder;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.execution.plan.QueryableExecutionPlan;

public class EntryNodeProvider {
    private final Project project;
    private final TaskExecutionGraph taskGraph;
    private final SortedSet<String> entryNodePaths = new TreeSet<String>();
    private final List<TaskNodeHolder> entryNodes = new ArrayList<TaskNodeHolder>();
    private String invokedTask = null;

    public EntryNodeProvider(@Nonnull Project pProject, @Nonnull TaskExecutionGraph pTaskGraph) {
        this(pProject, pTaskGraph, true);
    }

    EntryNodeProvider(@Nonnull Project pProject, @Nonnull TaskExecutionGraph pTaskGraph, boolean pAnalyze) {
        this.project = Objects.requireNonNull(pProject, "pProject was null");
        this.taskGraph = Objects.requireNonNull(pTaskGraph, "pTaskGraph was null");
        if (pAnalyze) {
            this.analyzeTaskGraph();
        }
    }

    private void analyzeTaskGraph() {
        Object executionPlan = ReflectUtil.getExecutionPlan(this.taskGraph);
        this.analyzeTaskGraphInternal(executionPlan);
    }

    void analyzeTaskGraphInternal(@Nonnull Object pExecutionPlan) {
        Iterable rawEntryNodes = new ArrayList();
        boolean tasksScheduled = true;
        if (pExecutionPlan instanceof QueryableExecutionPlan) {
            QueryableExecutionPlan qep = (QueryableExecutionPlan)pExecutionPlan;
            if (qep.size() > 0) {
                ArrayList rawEntryNodeList = new ArrayList();
                ReflectUtil.callScheduledNodesVistor(qep.getScheduledNodes(), (ln, entryNds) -> rawEntryNodeList.addAll(entryNds));
                rawEntryNodes = rawEntryNodeList;
            } else {
                tasksScheduled = false;
            }
        }
        if (tasksScheduled && !rawEntryNodes.iterator().hasNext()) {
            rawEntryNodes = (Iterable)ReflectUtil.readField(pExecutionPlan, "list of invoked tasks", List.of("entryNodes"));
        }
        this.invokedTask = this.readInvokedTaskname(rawEntryNodes);
        this.processEntryNodes(rawEntryNodes);
    }

    private void processEntryNodes(@Nonnull Iterable<?> pEntryNodes) {
        boolean taskInfoInvoked = false;
        for (Object realNode : pEntryNodes) {
            TaskNodeHolder holder = new TaskNodeHolder(this.project, realNode);
            if (holder.isOneOfOurTasks()) {
                taskInfoInvoked = true;
                continue;
            }
            this.entryNodes.add(holder);
            this.entryNodePaths.add(holder.getIdentity());
        }
        if (taskInfoInvoked && this.entryNodes.isEmpty()) {
            throw new GradleException("No task specified for " + this.invokedTask + ".");
        }
        if (taskInfoInvoked && this.entryNodes.size() > 1 && !"tiOrder".equals(this.invokedTask)) {
            this.project.getLogger().warn("WARNING: More than one task specified as argument of {} {}. Will report on '{}'.", new Object[]{this.invokedTask, this.entryNodePaths, this.entryNodes.get(0).getIdentity()});
        }
    }

    @Nonnull
    private String readInvokedTaskname(@Nonnull Iterable<?> pEntryNodes) {
        TreeSet<String> candidates = new TreeSet<String>();
        for (Object realNode : pEntryNodes) {
            TaskNodeHolder holder = new TaskNodeHolder(this.project, realNode);
            if (!holder.isOneOfOurTasks()) continue;
            candidates.add(holder.getDisplayName());
        }
        return candidates.size() == 1 ? (String)candidates.first() : "task info";
    }

    @CheckForNull
    public TaskNodeHolder getEffectiveEntryNode() {
        return this.entryNodes.isEmpty() ? null : this.entryNodes.get(0);
    }

    @Nonnull
    public String getLabel() {
        return String.join((CharSequence)", ", this.entryNodePaths);
    }
}

