/*
 * Copyright 2020-2025 Barfuin and the gradle-taskinfo contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.barfuin.gradle.taskinfo;

import java.io.Serial;
import java.io.Serializable;

import javax.annotation.Nonnull;
import javax.inject.Inject;

import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;


/**
 * Gradle extension for configuring this plugin.
 */
public class TaskInfoExtension
    implements Serializable
{
    @Serial
    private static final long serialVersionUID = 4L;

    private final Property<Boolean> clipped;

    private final Property<Boolean> color;

    private final Property<Boolean> showTaskTypes;

    private final Property<Boolean> internal;



    @Inject
    public TaskInfoExtension(@Nonnull final ObjectFactory pObjectFactory)
    {
        clipped = pObjectFactory.property(Boolean.class).convention(Boolean.FALSE);
        color = pObjectFactory.property(Boolean.class).convention(Boolean.TRUE);
        showTaskTypes = pObjectFactory.property(Boolean.class).convention(Boolean.TRUE);
        internal = pObjectFactory.property(Boolean.class).convention(Boolean.FALSE);
    }



    @Nonnull
    public Property<Boolean> isClipped()
    {
        return clipped;
    }



    public void setClipped(final boolean pClipped)
    {
        clipped.set(Boolean.valueOf(pClipped));
    }



    @Nonnull
    public Property<Boolean> isColor()
    {
        return color;
    }



    public void setColor(final boolean pColor)
    {
        color.set(Boolean.valueOf(pColor));
    }



    @Nonnull
    public Property<Boolean> isShowTaskTypes()
    {
        return showTaskTypes;
    }



    public void setShowTaskTypes(final boolean pShowTaskTypes)
    {
        showTaskTypes.set(Boolean.valueOf(pShowTaskTypes));
    }



    @Nonnull
    public Property<Boolean> isInternal()
    {
        return internal;
    }



    public void setInternal(final boolean pInternal)
    {
        internal.set(Boolean.valueOf(pInternal));
    }
}
