/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.evo.classindex.processor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.atteo.evo.classindex.IndexAnnotated;
import org.atteo.evo.classindex.IndexSubclasses;

public class ClassIndexProcessor
extends AbstractProcessor {
    private Multimap<TypeElement, TypeElement> subclassMap = HashMultimap.create();
    private Multimap<TypeElement, TypeElement> annotatedMap = HashMultimap.create();
    private Multimap<PackageElement, TypeElement> packageMap = HashMultimap.create();
    private Set<String> indexedAnnotations;
    private Types types;
    private Filer filer;

    public ClassIndexProcessor() {
        this.indexedAnnotations = Collections.emptySet();
    }

    protected ClassIndexProcessor(Class<?> ... classes) {
        this.indexedAnnotations = new HashSet<String>();
        for (Class<?> klass : classes) {
            this.indexedAnnotations.add(klass.getCanonicalName());
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Sets.newHashSet((Object[])new String[]{"*"});
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (Element element : roundEnv.getRootElements()) {
                TypeElement annotationElement;
                if (!(element instanceof TypeElement)) continue;
                TypeElement typeElement = (TypeElement)element;
                if (!this.indexedAnnotations.isEmpty()) {
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                        if (!this.indexedAnnotations.contains(annotationElement.getQualifiedName().toString())) continue;
                        this.annotatedMap.put((Object)annotationElement, (Object)typeElement);
                    }
                    continue;
                }
                this.indexSubclasses(typeElement, typeElement);
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                    if (annotationElement.getAnnotation(IndexAnnotated.class) == null) continue;
                    this.annotatedMap.put((Object)annotationElement, (Object)typeElement);
                }
                PackageElement packageElement = (PackageElement)element.getEnclosingElement();
                if (packageElement.getAnnotation(IndexSubclasses.class) == null) continue;
                this.packageMap.put((Object)packageElement, (Object)typeElement);
            }
            if (!roundEnv.processingOver()) {
                return false;
            }
            for (TypeElement typeElement : this.subclassMap.keySet()) {
                this.writeElements(this.subclassMap.get((Object)typeElement), "META-INF/services/" + typeElement.getQualifiedName().toString());
            }
            for (TypeElement typeElement : this.annotatedMap.keySet()) {
                this.writeElements(this.annotatedMap.get((Object)typeElement), "META-INF/annotations/" + typeElement.getQualifiedName().toString());
            }
            for (PackageElement packageElement : this.packageMap.keySet()) {
                this.writeElements(this.packageMap.get((Object)packageElement), packageElement.getQualifiedName().toString().replace(".", "/") + "/" + "jaxb.index");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private void writeElements(Iterable<TypeElement> elementList, String resourceName) throws IOException {
        FileObject file = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceName, new Element[0]);
        Writer writer = file.openWriter();
        for (TypeElement element : elementList) {
            writer.write(element.getQualifiedName().toString());
            writer.write("\n");
        }
        writer.close();
    }

    private void indexSubclasses(TypeElement rootElement, TypeElement element) {
        for (TypeMirror typeMirror : this.types.directSupertypes(element.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            DeclaredType superType = (DeclaredType)typeMirror;
            TypeElement superTypeElement = (TypeElement)superType.asElement();
            if (superTypeElement.getAnnotation(IndexSubclasses.class) != null) {
                this.subclassMap.put((Object)superTypeElement, (Object)rootElement);
            }
            this.indexSubclasses(rootElement, superTypeElement);
        }
    }
}

