/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.GlobalStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;

public class TreeStructureViewBuilder {
    private StructureViewNodeFactory nodeFactory;
    private static final Comparator<IStructureViewNode> ALPHABETICAL_COMPARATOR = new Comparator<IStructureViewNode>(){

        @Override
        public int compare(IStructureViewNode o1, IStructureViewNode o2) {
            IProgramElement sv1 = o1.getStructureNode();
            IProgramElement sv2 = o2.getStructureNode();
            if (sv1 != null && sv2 != null) {
                if (sv2.getKind() == IProgramElement.Kind.IMPORT_REFERENCE) {
                    return 1;
                }
                if (sv1.getKind() == IProgramElement.Kind.IMPORT_REFERENCE) {
                    return -1;
                }
                return sv1.getName().compareTo(sv2.getName());
            }
            return 0;
        }
    };
    private static final Comparator<IStructureViewNode> DECLARATIONAL_COMPARATOR = new Comparator<IStructureViewNode>(){

        @Override
        public int compare(IStructureViewNode o1, IStructureViewNode o2) {
            IProgramElement sv1 = o1.getStructureNode();
            IProgramElement sv2 = o2.getStructureNode();
            if (sv1 != null && sv2 != null) {
                if (sv2.getKind() == IProgramElement.Kind.IMPORT_REFERENCE) {
                    return 1;
                }
                if (sv1.getKind() == IProgramElement.Kind.IMPORT_REFERENCE) {
                    return -1;
                }
                if (sv1.getSourceLocation() == null || sv2.getSourceLocation() == null) {
                    return 0;
                }
                if (sv1.getSourceLocation().getLine() < sv2.getSourceLocation().getLine()) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    };

    public TreeStructureViewBuilder(StructureViewNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public void buildView(StructureView view, IHierarchy model) {
        StructureViewProperties.Hierarchy hierarchy;
        FileStructureView fileView;
        IProgramElement modelRoot = null;
        modelRoot = this.isFileView(view) ? ((fileView = (FileStructureView)view).getSourceFile() == null ? IHierarchy.NO_STRUCTURE : model.findElementForSourceFile(fileView.getSourceFile())) : model.getRoot();
        IStructureViewNode viewRoot = null;
        if (!this.isFileView(view) && ((hierarchy = ((GlobalStructureView)view).getGlobalViewProperties().getHierarchy()).equals(StructureViewProperties.Hierarchy.CROSSCUTTING) || hierarchy.equals(StructureViewProperties.Hierarchy.INHERITANCE))) {
            viewRoot = this.buildCustomTree((GlobalStructureView)view, model);
        }
        if (viewRoot == null) {
            viewRoot = this.createViewNode(modelRoot, view.getViewProperties());
        }
        if (view.getViewProperties().getSorting() == StructureViewProperties.Sorting.ALPHABETICAL || !this.isFileView(view) && ((GlobalStructureView)view).getGlobalViewProperties().getHierarchy().equals(StructureViewProperties.Hierarchy.DECLARATION)) {
            this.sortView(viewRoot, ALPHABETICAL_COMPARATOR);
        } else {
            this.sortView(viewRoot, DECLARATIONAL_COMPARATOR);
        }
        this.addPackageNode(view, viewRoot);
        view.setRootNode(viewRoot);
    }

    private void addPackageNode(StructureView view, IStructureViewNode viewRoot) {
        if (this.isFileView(view)) {
            // empty if block
        }
    }

    private IStructureViewNode createViewNode(IProgramElement node, StructureViewProperties properties) {
        Object parent;
        if (node == null) {
            return null;
        }
        ArrayList<IStructureViewNode> children = new ArrayList<IStructureViewNode>();
        if (node.isRunnable() && node.getParent() != null && ((parent = node.getParent()).getKind().equals(IProgramElement.Kind.CLASS) || parent.getKind().equals(IProgramElement.Kind.ASPECT))) {
            parent.setRunnable(true);
            node.setRunnable(false);
        }
        if (node.getChildren() != null) {
            for (Object e : node.getChildren()) {
                IProgramElement IProgramElement2 = (IProgramElement)e;
                if (!this.acceptNode(IProgramElement2, properties)) continue;
                children.add(this.createViewNode(IProgramElement2, properties));
            }
        }
        IStructureViewNode viewNode = this.nodeFactory.createNode(node, children);
        return viewNode;
    }

    private boolean isFileView(StructureView view) {
        return view instanceof FileStructureView && !(view instanceof GlobalStructureView);
    }

    private boolean acceptGranularity(IProgramElement.Kind kind, StructureViewProperties.Granularity granularity) {
        if (granularity == StructureViewProperties.Granularity.DECLARED_ELEMENTS) {
            return true;
        }
        if (granularity == StructureViewProperties.Granularity.MEMBER && kind != IProgramElement.Kind.CODE) {
            return true;
        }
        if (granularity == StructureViewProperties.Granularity.TYPE && (kind == IProgramElement.Kind.PROJECT || kind == IProgramElement.Kind.PACKAGE || kind.isSourceFile() || kind.isType())) {
            return true;
        }
        if (granularity == StructureViewProperties.Granularity.FILE && (kind == IProgramElement.Kind.PROJECT || kind == IProgramElement.Kind.PACKAGE || kind.isSourceFile())) {
            return true;
        }
        return granularity == StructureViewProperties.Granularity.PACKAGE && (kind == IProgramElement.Kind.PROJECT || kind == IProgramElement.Kind.PACKAGE);
    }

    private boolean acceptNode(IProgramElement node, StructureViewProperties properties) {
        if (node != null) {
            IProgramElement pNode = node;
            if (!this.acceptGranularity(pNode.getKind(), properties.getGranularity())) {
                return false;
            }
            if (pNode.getKind().isMember()) {
                if (properties.getFilteredMemberAccessibility().contains(pNode.getAccessibility())) {
                    return false;
                }
                if (properties.getFilteredMemberKinds().contains(pNode.getKind())) {
                    return false;
                }
                for (IProgramElement.Modifiers element : pNode.getModifiers()) {
                    if (!properties.getFilteredMemberModifiers().contains(element)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void sortView(IStructureViewNode node, Comparator<IStructureViewNode> comparator) {
        if (node == null || node.getChildren() == null) {
            return;
        }
        node.getChildren().sort(comparator);
        for (Object o : node.getChildren()) {
            IStructureViewNode nextNode = (IStructureViewNode)o;
            if (nextNode == null) continue;
            this.sortView(nextNode, comparator);
        }
    }

    private IStructureViewNode buildCustomTree(GlobalStructureView view, IHierarchy model) {
        IProgramElement rootNode = model.getRoot();
        IStructureViewNode treeNode = this.nodeFactory.createNode(rootNode);
        ArrayList rootNodes = new ArrayList();
        this.getRoots(rootNode, rootNodes, view.getGlobalViewProperties().getHierarchy());
        Iterator it = rootNodes.iterator();
        while (it.hasNext()) {
            if (view.getGlobalViewProperties().getHierarchy().equals(StructureViewProperties.Hierarchy.CROSSCUTTING)) {
                treeNode.add(this.getCrosscuttingChildren((IProgramElement)it.next()));
                continue;
            }
            if (!view.getGlobalViewProperties().getHierarchy().equals(StructureViewProperties.Hierarchy.INHERITANCE)) continue;
            treeNode.add(this.getInheritanceChildren((IProgramElement)it.next(), view.getViewProperties().getRelations()));
        }
        return treeNode;
    }

    private void getRoots(IProgramElement rootNode, List roots, StructureViewProperties.Hierarchy hierarchy) {
    }

    public boolean acceptNodeAsRoot(IProgramElement node, StructureViewProperties.Hierarchy hierarchy) {
        if (hierarchy.equals(StructureViewProperties.Hierarchy.CROSSCUTTING)) {
            return node.getKind().equals(IProgramElement.Kind.ADVICE) || node.getKind().equals(IProgramElement.Kind.POINTCUT);
        }
        if (hierarchy.equals(StructureViewProperties.Hierarchy.INHERITANCE)) {
            return node.getKind().equals(IProgramElement.Kind.CLASS);
        }
        return false;
    }

    private IStructureViewNode getInheritanceChildren(IProgramElement node, List associations) {
        throw new RuntimeException("unimplemented");
    }

    private IStructureViewNode getCrosscuttingChildren(IProgramElement node) {
        throw new RuntimeException("unimplemented");
    }
}

