/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.core;

import java.util.HashMap;
import java.util.Map;

public final class JavaOptions {
    public static final String COMPLIANCE_LEVEL = "org.eclipse.jdt.core.compiler.compliance";
    public static final String SOURCE_COMPATIBILITY_LEVEL = "org.eclipse.jdt.core.compiler.source";
    public static final String TARGET_COMPATIBILITY_LEVEL = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    public static final String VERSION_13 = "1.3";
    public static final String VERSION_14 = "1.4";
    public static final String VERSION_15 = "1.5";
    public static final String VERSION_16 = "1.6";
    public static final String CHARACTER_ENCODING = "org.eclipse.jdt.core.encoding";
    public static final String PRESERVE_ALL_LOCALS = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE = "optimize out";
    public static final String WARN_METHOD_WITH_CONSTRUCTOR_NAME = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    public static final String WARN_OVERRIDING_PACKAGE_DEFAULT_METHOD = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    public static final String WARN_DEPRECATION = "org.eclipse.jdt.core.compiler.problem.deprecation";
    public static final String WARN_HIDDEN_CATCH_BLOCKS = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    public static final String WARN_UNUSED_LOCALS = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    public static final String WARN_UNUSED_PARAMETER = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    public static final String WARN_UNUSED_IMPORTS = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    public static final String WARN_SYNTHETIC_ACCESS = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    public static final String WARN_ASSERT_IDENITIFIER = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    public static final String WARN_NON_NLS = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    public static final String IGNORE = "ignore";
    public static final String WARNING = "warning";
    public static final String DEBUG_SOURCE = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    public static final String DEBUG_LINES = "org.eclipse.jdt.core.compiler.debug.localVariable";
    public static final String DEBUG_VARS = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    private static Map<String, String> defaultOptionsMap;

    public static Map<String, String> getDefaultJavaOptions() {
        if (defaultOptionsMap != null) {
            return defaultOptionsMap;
        }
        defaultOptionsMap = new HashMap<String, String>();
        defaultOptionsMap.put(COMPLIANCE_LEVEL, VERSION_14);
        defaultOptionsMap.put(SOURCE_COMPATIBILITY_LEVEL, VERSION_13);
        defaultOptionsMap.put(PRESERVE_ALL_LOCALS, OPTIMIZE);
        defaultOptionsMap.put(WARN_METHOD_WITH_CONSTRUCTOR_NAME, IGNORE);
        defaultOptionsMap.put(WARN_OVERRIDING_PACKAGE_DEFAULT_METHOD, IGNORE);
        defaultOptionsMap.put(WARN_DEPRECATION, IGNORE);
        defaultOptionsMap.put(WARN_HIDDEN_CATCH_BLOCKS, IGNORE);
        defaultOptionsMap.put(WARN_UNUSED_LOCALS, IGNORE);
        defaultOptionsMap.put(WARN_UNUSED_PARAMETER, IGNORE);
        defaultOptionsMap.put(WARN_UNUSED_IMPORTS, IGNORE);
        defaultOptionsMap.put(WARN_SYNTHETIC_ACCESS, IGNORE);
        defaultOptionsMap.put(WARN_ASSERT_IDENITIFIER, IGNORE);
        defaultOptionsMap.put(WARN_NON_NLS, IGNORE);
        defaultOptionsMap.put(DEBUG_SOURCE, GENERATE);
        defaultOptionsMap.put(DEBUG_LINES, GENERATE);
        defaultOptionsMap.put(DEBUG_VARS, DO_NOT_GENERATE);
        return defaultOptionsMap;
    }

    public static boolean isValidJvmVersion(String value) {
        return VERSION_13.equals(value) || VERSION_14.equals(value) || VERSION_15.equals(value) || VERSION_16.equals(value);
    }

    public static boolean isValidPreserveAllLocalsOption(String option) {
        return PRESERVE.equals(option) || OPTIMIZE.equals(option);
    }

    public static boolean isIgnoreOrWarning(String option) {
        return IGNORE.equals(option) || WARNING.equals(option);
    }

    public static boolean isGenerateOrNot(String option) {
        return GENERATE.equals(option) || DO_NOT_GENERATE.equals(option);
    }
}

