/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.gradient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fop.render.gradient.GradientMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function {
    private int functionType;
    private List<Double> domain;
    private List<Double> range;
    private int bitsPerSample = 1;
    private int order = 1;
    private List<Double> encode;
    private float[] cZero;
    private float[] cOne;
    private double interpolationExponentN = 1.0;
    private List<Function> functions;
    private List<Float> bounds;
    private byte[] datasource;
    private List<Integer> size;

    public Function(List<Double> domain, List<Double> range, float[] cZero, float[] cOne, double interpolationExponentN) {
        this(2, domain, range);
        this.cZero = cZero;
        this.cOne = cOne;
        this.interpolationExponentN = interpolationExponentN;
    }

    public Function(List<Double> domain, List<Double> range, List<Function> functions, List<Float> bounds, List<Double> encode) {
        this(3, domain, range);
        this.functions = functions;
        this.bounds = bounds;
        this.encode = this.makeEncode(encode);
    }

    public void setCZero(float[] cZero) {
        this.cZero = cZero;
    }

    public void setCOne(float[] cOne) {
        this.cOne = cOne;
    }

    private List<Double> makeEncode(List<Double> encode) {
        if (encode != null) {
            return encode;
        }
        encode = new ArrayList<Double>(this.functions.size() * 2);
        for (int i = 0; i < this.functions.size(); ++i) {
            encode.add(0.0);
            encode.add(1.0);
        }
        return encode;
    }

    private Function(int functionType, List<Double> domain, List<Double> range) {
        this.functionType = functionType;
        this.domain = domain == null ? Arrays.asList(0.0, 1.0) : domain;
        this.range = range;
    }

    public Function(List<Double> domain, List<Double> range, List<Double> encode, byte[] datasource, int bitsPerSample, List<Integer> size) {
        this(0, domain, range);
        this.encode = encode;
        this.datasource = datasource;
        this.bitsPerSample = bitsPerSample;
        this.size = size;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public List<Float> getBounds() {
        return this.bounds;
    }

    public List<Double> getDomain() {
        return this.domain;
    }

    public List<Double> getEncode() {
        return this.encode;
    }

    public List<Function> getFunctions() {
        if (this.functions == null) {
            return Collections.emptyList();
        }
        return this.functions;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public double getInterpolationExponentN() {
        return this.interpolationExponentN;
    }

    public int getOrder() {
        return this.order;
    }

    public List<Double> getRange() {
        return this.range;
    }

    public float[] getCZero() {
        return this.cZero;
    }

    public float[] getCOne() {
        return this.cOne;
    }

    public String output(StringBuilder out, GradientMaker.DoubleFormatter doubleFormatter, SubFunctionRenderer subFunctionRenderer) {
        out.append("<<\n/FunctionType " + this.functionType + "\n");
        this.outputDomain(out, doubleFormatter);
        if (this.functionType == 0) {
            this.outputEncode(out, doubleFormatter);
            this.outputBitsPerSample(out);
            this.outputOrder(out);
            this.outputRange(out, doubleFormatter);
            out.append("\n/DataSource <");
            for (byte b : this.datasource) {
                out.append(String.format("%02x", b & 0xFF));
            }
            out.append(">\n");
            out.append("/Size [");
            for (Integer i : this.size) {
                out.append(i);
                out.append(" ");
            }
            out.append("]\n");
            out.append(">>");
        } else if (this.functionType == 2) {
            this.outputRange(out, doubleFormatter);
            this.outputCZero(out, doubleFormatter);
            this.outputCOne(out, doubleFormatter);
            this.outputInterpolationExponentN(out, doubleFormatter);
            out.append(">>");
        } else if (this.functionType == 3) {
            this.outputRange(out, doubleFormatter);
            if (!this.functions.isEmpty()) {
                out.append("/Functions [ ");
                for (int i = 0; i < this.functions.size(); ++i) {
                    subFunctionRenderer.outputFunction(out, i);
                    out.append(' ');
                }
                out.append("]\n");
            }
            this.outputEncode(out, doubleFormatter);
            out.append("/Bounds ");
            if (this.bounds != null) {
                GradientMaker.outputDoubles(out, doubleFormatter, this.bounds);
            } else if (!this.functions.isEmpty()) {
                int numberOfFunctions = this.functions.size();
                String functionsFraction = doubleFormatter.formatDouble(1.0 / (double)numberOfFunctions);
                out.append("[ ");
                int i = 0;
                while (i + 1 < numberOfFunctions) {
                    out.append(functionsFraction);
                    out.append(" ");
                    ++i;
                }
                out.append("]");
            }
            out.append("\n>>");
        } else if (this.functionType == 4) {
            this.outputRange(out, doubleFormatter);
            out.append(">>");
        }
        return out.toString();
    }

    private void outputDomain(StringBuilder p, GradientMaker.DoubleFormatter doubleFormatter) {
        p.append("/Domain ");
        GradientMaker.outputDoubles(p, doubleFormatter, this.domain);
        p.append("\n");
    }

    private void outputBitsPerSample(StringBuilder out) {
        out.append("/BitsPerSample " + this.bitsPerSample + "\n");
    }

    private void outputOrder(StringBuilder out) {
        if (this.order == 1 || this.order == 3) {
            out.append("\n/Order " + this.order + "\n");
        }
    }

    private void outputRange(StringBuilder out, GradientMaker.DoubleFormatter doubleFormatter) {
        if (this.range != null) {
            out.append("/Range ");
            GradientMaker.outputDoubles(out, doubleFormatter, this.range);
            out.append("\n");
        }
    }

    private void outputEncode(StringBuilder out, GradientMaker.DoubleFormatter doubleFormatter) {
        out.append("/Encode ");
        GradientMaker.outputDoubles(out, doubleFormatter, this.encode);
        out.append("\n");
    }

    private void outputCZero(StringBuilder out, GradientMaker.DoubleFormatter doubleFormatter) {
        if (this.cZero != null) {
            out.append("/C0 [ ");
            for (float c : this.cZero) {
                out.append(doubleFormatter.formatDouble(c));
                out.append(" ");
            }
            out.append("]\n");
        }
    }

    private void outputCOne(StringBuilder out, GradientMaker.DoubleFormatter doubleFormatter) {
        if (this.cOne != null) {
            out.append("/C1 [ ");
            for (float c : this.cOne) {
                out.append(doubleFormatter.formatDouble(c));
                out.append(" ");
            }
            out.append("]\n");
        }
    }

    private void outputInterpolationExponentN(StringBuilder out, GradientMaker.DoubleFormatter doubleFormatter) {
        out.append("/N ");
        out.append(doubleFormatter.formatDouble(this.interpolationExponentN));
        out.append("\n");
    }

    public static interface SubFunctionRenderer {
        public void outputFunction(StringBuilder var1, int var2);
    }
}

