/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fop.afp.modca.AbstractStructuredObject;
import org.apache.fop.afp.modca.Registry;
import org.apache.fop.afp.modca.triplets.AbstractTriplet;
import org.apache.fop.afp.modca.triplets.CommentTriplet;
import org.apache.fop.afp.modca.triplets.FullyQualifiedNameTriplet;
import org.apache.fop.afp.modca.triplets.ObjectClassificationTriplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripletStructuredObject
extends AbstractStructuredObject {
    protected List<AbstractTriplet> triplets = new ArrayList<AbstractTriplet>();

    protected int getTripletDataLength() {
        int dataLength = 0;
        for (AbstractTriplet triplet : this.triplets) {
            dataLength += triplet.getDataLength();
        }
        return dataLength;
    }

    public boolean hasTriplets() {
        return this.triplets.size() > 0;
    }

    protected void writeTriplets(OutputStream os) throws IOException {
        if (this.hasTriplets()) {
            this.writeObjects(this.triplets, os);
            this.triplets = null;
        }
    }

    private AbstractTriplet getTriplet(byte tripletId) {
        for (AbstractTriplet trip : this.triplets) {
            if (trip.getId() != tripletId) continue;
            return trip;
        }
        return null;
    }

    public boolean hasTriplet(byte tripletId) {
        return this.getTriplet(tripletId) != null;
    }

    public void addTriplet(AbstractTriplet triplet) {
        this.triplets.add(triplet);
    }

    public void addTriplets(Collection<AbstractTriplet> tripletCollection) {
        if (tripletCollection != null) {
            this.triplets.addAll(tripletCollection);
        }
    }

    protected List<AbstractTriplet> getTriplets() {
        return this.triplets;
    }

    public void setFullyQualifiedName(byte fqnType, byte fqnFormat, String fqName) {
        this.addTriplet(new FullyQualifiedNameTriplet(fqnType, fqnFormat, fqName, false));
    }

    public void setFullyQualifiedName(byte fqnType, byte fqnFormat, String fqName, boolean utf16be) {
        this.addTriplet(new FullyQualifiedNameTriplet(fqnType, fqnFormat, fqName, utf16be));
    }

    public String getFullyQualifiedName() {
        FullyQualifiedNameTriplet fqNameTriplet = (FullyQualifiedNameTriplet)this.getTriplet((byte)2);
        if (fqNameTriplet != null) {
            return fqNameTriplet.getFullyQualifiedName();
        }
        LOG.warn((Object)(this + " has no fully qualified name"));
        return null;
    }

    public void setObjectClassification(byte objectClass, Registry.ObjectType objectType, boolean dataInContainer, boolean containerHasOEG, boolean dataInOCD) {
        this.addTriplet(new ObjectClassificationTriplet(objectClass, objectType, dataInContainer, containerHasOEG, dataInOCD));
    }

    public void setComment(String commentString) {
        this.addTriplet(new CommentTriplet(101, commentString));
    }
}

