/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api.client;

import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPBServerImpl;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.app.security.authorize.TezAMPolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGClientServer
extends AbstractService {
    static final Logger LOG = LoggerFactory.getLogger(DAGClientServer.class);
    ClientToAMTokenSecretManager secretManager;
    DAGClientHandler realInstance;
    RPC.Server server;
    InetSocketAddress bindAddress;
    final FileSystem stagingFs;

    public DAGClientServer(DAGClientHandler realInstance, ApplicationAttemptId attemptId, FileSystem stagingFs) {
        super("DAGClientRPCServer");
        this.realInstance = realInstance;
        this.secretManager = new ClientToAMTokenSecretManager(attemptId, null);
        this.stagingFs = stagingFs;
    }

    public void serviceStart() {
        try {
            Configuration conf = this.getConfig();
            InetSocketAddress addr = new InetSocketAddress(0);
            DAGClientAMProtocolBlockingPBServerImpl service = new DAGClientAMProtocolBlockingPBServerImpl(this.realInstance, this.stagingFs);
            BlockingService blockingService = DAGClientAMProtocolRPC.DAGClientAMProtocol.newReflectiveBlockingService((DAGClientAMProtocolRPC.DAGClientAMProtocol.BlockingInterface)service);
            int numHandlers = conf.getInt("tez.am.client.am.thread-count", 2);
            if (numHandlers < 2) {
                numHandlers = 2;
            }
            this.server = this.createServer(DAGClientAMProtocolBlockingPB.class, addr, conf, numHandlers, blockingService, "tez.am.client.am.port-range");
            if (conf.getBoolean("hadoop.security.authorization", false)) {
                this.refreshServiceAcls(conf, new TezAMPolicyProvider());
            }
            this.server.start();
            InetSocketAddress serverBindAddress = NetUtils.getConnectAddress((Server)this.server);
            this.bindAddress = NetUtils.createSocketAddrForHost((String)serverBindAddress.getAddress().getCanonicalHostName(), (int)serverBindAddress.getPort());
            LOG.info("Instantiated DAGClientRPCServer at " + this.bindAddress);
        }
        catch (Exception e) {
            LOG.error("Failed to start DAGClientServer: ", (Throwable)e);
            throw new TezUncheckedException((Throwable)e);
        }
    }

    private void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void serviceStop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setClientAMSecretKey(ByteBuffer key) {
        if (key != null && key.hasRemaining()) {
            this.secretManager.setMasterKey(key.array());
        }
    }

    private RPC.Server createServer(Class<?> pbProtocol, InetSocketAddress addr, Configuration conf, int numHandlers, BlockingService blockingService, String portRangeConfig) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, pbProtocol, ProtobufRpcEngine.class);
        RPC.Server server = new RPC.Builder(conf).setProtocol(pbProtocol).setInstance((Object)blockingService).setBindAddress(addr.getHostName()).setPort(addr.getPort()).setNumHandlers(numHandlers).setVerbose(false).setPortRangeConfig(portRangeConfig).setSecretManager((SecretManager)this.secretManager).build();
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, pbProtocol, (Object)blockingService);
        return server;
    }
}

