/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hour$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp) - Returns the hour component of the string/timestamp.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       12\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0010 \u00012B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005q\t\u0003\u0005W\u0001\tE\t\u0015!\u0003I\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011\u0015q\u0006\u0001\"\u0011`\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015!\b\u0001\"\u0011v\u0011\u00159\b\u0001\"\u0015y\u0011\u0015q\b\u0001\"\u0011\u0000\u0011%\tY\u0002AA\u0001\n\u0003\ti\u0002C\u0005\u0002$\u0001\t\n\u0011\"\u0001\u0002&!I\u00111\b\u0001\u0012\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0003\u0002\u0011\u0011!C!\u0003\u0007B\u0011\"a\u0015\u0001\u0003\u0003%\t!!\u0016\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA3\u0001\u0005\u0005I\u0011IA4\u0011%\t)\bAA\u0001\n\u0003\t9\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0011\u0002\u0004\u001eI\u0011qU\u0010\u0002\u0002#\u0005\u0011\u0011\u0016\u0004\t=}\t\t\u0011#\u0001\u0002,\"1qK\u0006C\u0001\u0003sC\u0011\"a/\u0017\u0003\u0003%)%!0\t\u0013\u0005}f#!A\u0005\u0002\u0006\u0005\u0007\"CAd-E\u0005I\u0011AA\u001f\u0011%\tIMFA\u0001\n\u0003\u000bY\rC\u0005\u0002ZZ\t\n\u0011\"\u0001\u0002>!I\u00111\u001c\f\u0002\u0002\u0013%\u0011Q\u001c\u0002\u0005\u0011>,(O\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u0019\u0001Q&\r\u001b8{A\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011aFM\u0005\u0003g}\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059*\u0014B\u0001\u001c \u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$a\u0002)s_\u0012,8\r\u001e\t\u0003qyJ!aP\u001d\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003\t\u0003\"AL\"\n\u0005\u0011{\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n!\u0002^5nKj{g.Z%e+\u0005A\u0005c\u0001\u001dJ\u0017&\u0011!*\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051\u001bfBA'R!\tq\u0015(D\u0001P\u0015\t\u00016&\u0001\u0004=e>|GOP\u0005\u0003%f\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!+O\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00043j[\u0006C\u0001\u0018\u0001\u0011\u0015\u0001U\u00011\u0001C\u0011\u001d1U\u0001%AA\u0002!#\"!W/\t\u000b\u00013\u0001\u0019\u0001\"\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001a!\r\tg-\u001b\b\u0003E\u0012t!AT2\n\u0003iJ!!Z\u001d\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0004'\u0016\f(BA3:!\tQW.D\u0001l\u0015\ta7%A\u0003usB,7/\u0003\u0002oW\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0011\u000f\u0005\u0002ke&\u00111o\u001b\u0002\t\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u0011\u0011G\u001e\u0005\u0006\r&\u0001\raS\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0003sr\u0004\"\u0001\u000f>\n\u0005mL$aA!os\")QP\u0003a\u0001s\u0006IA/[7fgR\fW\u000e]\u0001\nI><UM\\\"pI\u0016$b!!\u0001\u0002\u000e\u0005]\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dq$A\u0004d_\u0012,w-\u001a8\n\t\u0005-\u0011Q\u0001\u0002\t\u000bb\u0004(oQ8eK\"9\u0011qB\u0006A\u0002\u0005E\u0011aA2uqB!\u00111AA\n\u0013\u0011\t)\"!\u0002\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011D\u0006A\u0002\u0005\u0005\u0011AA3w\u0003\u0011\u0019w\u000e]=\u0015\u000be\u000by\"!\t\t\u000f\u0001c\u0001\u0013!a\u0001\u0005\"9a\t\u0004I\u0001\u0002\u0004A\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003OQ3AQA\u0015W\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001bs\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0012q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u007fQ3\u0001SA\u0015\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\t\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0013\u0001\u00026bm\u0006L1\u0001VA%\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0006E\u00029\u00033J1!a\u0017:\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rI\u0018\u0011\r\u0005\n\u0003G\n\u0012\u0011!a\u0001\u0003/\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA5!\u0015\tY'!\u001dz\u001b\t\tiGC\u0002\u0002pe\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003s\ny\bE\u00029\u0003wJ1!! :\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0019\u0014\u0003\u0003\u0005\r!_\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u0014Q\u0011\u0005\t\u0003G\"\u0012\u0011!a\u0001s\"\u001a\u0002!!#\u0002\u0010\u0006E\u0015QSAL\u00037\u000bi*!)\u0002$B\u0019a&a#\n\u0007\u00055uDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005M\u0015aR0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002Bw.\u001e:!G>l\u0007o\u001c8f]R\u0004sN\u001a\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e|C/[7fgR\fW\u000e\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!'\u0002\u0013*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00191s5\u0002t'L\u001a1AE\u0012$(\u000e\u001d;ke:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112e)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002 \u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAS\u0003\u0015\td&\u000e\u00181\u0003\u0011Au.\u001e:\u0011\u0005922\u0003\u0002\f\u0002.v\u0002r!a,\u00026\nC\u0015,\u0004\u0002\u00022*\u0019\u00111W\u001d\u0002\u000fI,h\u000e^5nK&!\u0011qWAY\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003S\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\nQ!\u00199qYf$R!WAb\u0003\u000bDQ\u0001Q\rA\u0002\tCqAR\r\u0011\u0002\u0003\u0007\u0001*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$B!!4\u0002VB!\u0001(SAh!\u0015A\u0014\u0011\u001b\"I\u0013\r\t\u0019.\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005]7$!AA\u0002e\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u000e\u0005\u0003\u0002H\u0005\u0005\u0018\u0002BAr\u0003\u0013\u0012aa\u00142kK\u000e$\b")
public class Hour
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$2() {
        return Hour$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(Hour hour) {
        return Hour$.MODULE$.unapply(hour);
    }

    public static Option<String> apply$default$2() {
        return Hour$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<String>>, Hour> tupled() {
        return Hour$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, Hour>> curried() {
        return Hour$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        Hour hour = this;
        synchronized (hour) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        Hour hour = this;
        synchronized (hour) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(BoxesRunTime.unboxToLong((Object)timestamp), this.zoneId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(13).append(dtu).append(".getHours(").append((String)c).append(", ").append(zid).append(")").toString());
    }

    public Hour copy(Expression child, Option<String> timeZoneId) {
        return new Hour(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Hour";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.child();
                break;
            }
            case 1: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hour;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hour)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hour hour = (Hour)x$1;
        Expression expression = this.child();
        Expression expression2 = hour.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = hour.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!hour.canEqual(this)) return false;
        return true;
    }

    public Hour(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public Hour(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

