/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Decode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(bin, charset) - Decodes the first argument using the second argument character set.", examples="\n    Examples:\n      > SELECT _FUNC_(encode('abc', 'utf-8'), 'utf-8');\n       abc\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u000f\u001e\u0001*B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015A\u0005\u0001\"\u0011=\u0011\u0015I\u0005\u0001\"\u0011=\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015\u0001\u0007\u0001\"\u0015b\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u001dA\b!!A\u0005\u0002eDq\u0001 \u0001\u0012\u0002\u0013\u0005Q\u0010\u0003\u0005\u0002\u0012\u0001\t\n\u0011\"\u0001~\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003wA\u0011\"!\u0013\u0001\u0003\u0003%\t!a\u0013\t\u0013\u0005U\u0003!!A\u0005B\u0005]s!CA;;\u0005\u0005\t\u0012AA<\r!aR$!A\t\u0002\u0005e\u0004BB\"\u0017\t\u0003\t9\tC\u0005\u0002\nZ\t\t\u0011\"\u0012\u0002\f\"I\u0011Q\u0012\f\u0002\u0002\u0013\u0005\u0015q\u0012\u0005\n\u0003+3\u0012\u0011!CA\u0003/C\u0011\"!+\u0017\u0003\u0003%I!a+\u0003\r\u0011+7m\u001c3f\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011#\u0002\u0001,_IB\u0004C\u0001\u0017.\u001b\u0005i\u0012B\u0001\u0018\u001e\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002-a%\u0011\u0011'\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9\u0001K]8ek\u000e$\bCA\u001a:\u0013\tQDG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0002cS:,\u0012!\u0010\t\u0003YyJ!aP\u000f\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003cS:\u0004\u0013aB2iCJ\u001cX\r^\u0001\tG\"\f'o]3uA\u00051A(\u001b8jiz\"2!\u0012$H!\ta\u0003\u0001C\u0003<\u000b\u0001\u0007Q\bC\u0003B\u000b\u0001\u0007Q(\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00031\u0003\"!\u0014)\u000e\u00039S!aT\u0011\u0002\u000bQL\b/Z:\n\u0005Es%\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001U!\r)V\f\u0014\b\u0003-ns!a\u0016.\u000e\u0003aS!!W\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0014B\u0001/5\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u0007M+\u0017O\u0003\u0002]i\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u0019!-Z4\u0011\u0005M\u001a\u0017B\u000135\u0005\r\te.\u001f\u0005\u0006M*\u0001\rAY\u0001\u0007S:\u0004X\u000f^\u0019\t\u000b!T\u0001\u0019\u00012\u0002\r%t\u0007/\u001e;3\u0003%!wnR3o\u0007>$W\rF\u0002lcZ\u0004\"\u0001\\8\u000e\u00035T!A\\\u000f\u0002\u000f\r|G-Z4f]&\u0011\u0001/\u001c\u0002\t\u000bb\u0004(oQ8eK\")!o\u0003a\u0001g\u0006\u00191\r\u001e=\u0011\u00051$\u0018BA;n\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa^\u0006A\u0002-\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0004\u000bj\\\bbB\u001e\r!\u0003\u0005\r!\u0010\u0005\b\u00032\u0001\n\u00111\u0001>\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A \u0016\u0003{}\\#!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017!\u0014AC1o]>$\u0018\r^5p]&!\u0011qBA\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007M\ni#C\u0002\u00020Q\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AYA\u001b\u0011%\t9$EA\u0001\u0002\u0004\tY#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003{\u0001R!a\u0010\u0002F\tl!!!\u0011\u000b\u0007\u0005\rC'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0012\u0002B\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti%a\u0015\u0011\u0007M\ny%C\u0002\u0002RQ\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u00028M\t\t\u00111\u0001c\u0003\u0019)\u0017/^1mgR!\u0011QJA-\u0011!\t9\u0004FA\u0001\u0002\u0004\u0011\u0007f\u0004\u0001\u0002^\u0005\r\u0014QMA5\u0003W\ny'!\u001d\u0011\u00071\ny&C\u0002\u0002bu\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002h\u0005QvLR+O\u0007~C#-\u001b8-A\rD\u0017M]:fi&\u0002S\u0006\t#fG>$Wm\u001d\u0011uQ\u0016\u0004c-\u001b:ti\u0002\n'oZ;nK:$\b%^:j]\u001e\u0004C\u000f[3!g\u0016\u001cwN\u001c3!CJ<W/\\3oi\u0002\u001a\u0007.\u0019:bGR,'\u000fI:fi:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\nAK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015f]\u000e|G-\u001a\u0015(C\n\u001cw\u0005\f\u0011(kR4W\u0006O\u0014*Y\u0001:S\u000f\u001e4.q\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I1cG*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002t\u0005)\u0011GL\u001b/a\u00051A)Z2pI\u0016\u0004\"\u0001\f\f\u0014\tY\tY\b\u000f\t\b\u0003{\n\u0019)P\u001fF\u001b\t\tyHC\u0002\u0002\u0002R\nqA];oi&lW-\u0003\u0003\u0002\u0006\u0006}$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011qO\u0001\ti>\u001cFO]5oOR\u0011\u0011qC\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u000b\u0006E\u00151\u0013\u0005\u0006we\u0001\r!\u0010\u0005\u0006\u0003f\u0001\r!P\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI*!*\u0011\u000bM\nY*a(\n\u0007\u0005uEG\u0001\u0004PaRLwN\u001c\t\u0006g\u0005\u0005V(P\u0005\u0004\u0003G#$A\u0002+va2,'\u0007\u0003\u0005\u0002(j\t\t\u00111\u0001F\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002.B!\u0011\u0011DAX\u0013\u0011\t\t,a\u0007\u0003\r=\u0013'.Z2u\u0001")
public class Decode
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression bin;
    private final Expression charset;

    public static Option<Tuple2<Expression, Expression>> unapply(Decode decode) {
        return Decode$.MODULE$.unapply(decode);
    }

    public static Function1<Tuple2<Expression, Expression>, Decode> tupled() {
        return Decode$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Decode>> curried() {
        return Decode$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression bin() {
        return this.bin;
    }

    public Expression charset() {
        return this.charset;
    }

    @Override
    public Expression left() {
        return this.bin();
    }

    @Override
    public Expression right() {
        return this.charset();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        String fromCharset = ((UTF8String)input2).toString();
        return UTF8String.fromString((String)new String((byte[])input1, fromCharset));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(bytes, charset) -> new StringBuilder(215).append("\n        try {\n          ").append(ev.value()).append(" = UTF8String.fromString(new String(").append((String)bytes).append(", ").append((String)charset).append(".toString()));\n        } catch (java.io.UnsupportedEncodingException e) {\n          org.apache.spark.unsafe.Platform.throwException(e);\n        }\n      ").toString());
    }

    public Decode copy(Expression bin, Expression charset) {
        return new Decode(bin, charset);
    }

    public Expression copy$default$1() {
        return this.bin();
    }

    public Expression copy$default$2() {
        return this.charset();
    }

    @Override
    public String productPrefix() {
        return "Decode";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.bin();
                break;
            }
            case 1: {
                expression = this.charset();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Decode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Decode)) return false;
        boolean bl = true;
        if (!bl) return false;
        Decode decode = (Decode)x$1;
        Expression expression = this.bin();
        Expression expression2 = decode.bin();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.charset();
        Expression expression4 = decode.charset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!decode.canEqual(this)) return false;
        return true;
    }

    public Decode(Expression bin, Expression charset) {
        this.bin = bin;
        this.charset = charset;
        ExpectsInputTypes.$init$(this);
    }
}

