/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitwiseCount$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the number of bits that are set in the argument expr as an unsigned 64-bit integer, or NULL if the argument is NULL.", examples="\n    Examples:\n      > SELECT _FUNC_(0);\n       0\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005u!)a\b\u0001C\u0001\u007f!)!\t\u0001C!\u0007\")a\u000b\u0001C!/\")1\f\u0001C!9\")Q\r\u0001C!M\")q\r\u0001C!Q\")a\u000f\u0001C)o\"9Q\u0010AA\u0001\n\u0003q\b\"CA\u0001\u0001E\u0005I\u0011AA\u0002\u0011%\tI\u0002AA\u0001\n\u0003\nY\u0002C\u0005\u0002,\u0001\t\t\u0011\"\u0001\u0002.!I\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003{\u0001\u0011\u0011!C!\u0003\u007fA\u0011\"!\u0014\u0001\u0003\u0003%\t!a\u0014\t\u0013\u0005e\u0003!!A\u0005B\u0005ms!CA=5\u0005\u0005\t\u0012AA>\r!I\"$!A\t\u0002\u0005u\u0004B\u0002 \u0014\t\u0003\tY\t\u0003\u0005\\'\u0005\u0005IQIAG\u0011%\tyiEA\u0001\n\u0003\u000b\t\nC\u0005\u0002\u0016N\t\t\u0011\"!\u0002\u0018\"I\u00111U\n\u0002\u0002\u0013%\u0011Q\u0015\u0002\r\u0005&$x/[:f\u0007>,h\u000e\u001e\u0006\u00037q\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QDH\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000b\u00170kA\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011&L\u0005\u0003]i\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\r\u001c\n\u0005]\n$\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u0001\u001e\u0011\u0005%Z\u0014B\u0001\u001f\u001b\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\t\u0001\u0015\t\u0005\u0002*\u0001!)\u0001h\u0001a\u0001u\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0011\u00032!R'Q\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002JM\u00051AH]8pizJ\u0011AM\u0005\u0003\u0019F\nq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\n\u00191+Z9\u000b\u00051\u000b\u0004CA)U\u001b\u0005\u0011&BA*\u001f\u0003\u0015!\u0018\u0010]3t\u0013\t)&K\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001Y!\t\t\u0016,\u0003\u0002[%\nAA)\u0019;b)f\u0004X-\u0001\u0005u_N#(/\u001b8h)\u0005i\u0006C\u00010c\u001d\ty\u0006\r\u0005\u0002Hc%\u0011\u0011-M\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bc\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003u\u000b\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007%|G\u000f\u0005\u0002k[6\t1N\u0003\u0002m5\u000591m\u001c3fO\u0016t\u0017B\u00018l\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00029\t\u0001\u0004\t\u0018aA2uqB\u0011!N]\u0005\u0003g.\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003v\u0011\u0001\u0007\u0011.\u0001\u0002fm\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011\u0001p\u001f\t\u0003aeL!A_\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003}\u0013\u0001\u0007\u00010A\u0003j]B,H/\u0001\u0003d_BLHC\u0001!\u0000\u0011\u001dA$\u0002%AA\u0002i\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0006)\u001a!(a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00052\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\tiAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u000f!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tA\u0001\\1oO*\u0011\u0011qE\u0001\u0005U\u00064\u0018-C\u0002d\u0003C\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\f\u0011\u0007A\n\t$C\u0002\u00024E\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001_A\u001d\u0011%\tYDDA\u0001\u0002\u0004\ty#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0002R!a\u0011\u0002Jal!!!\u0012\u000b\u0007\u0005\u001d\u0013'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0013\u0002F\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t&a\u0016\u0011\u0007A\n\u0019&C\u0002\u0002VE\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002<A\t\t\u00111\u0001y\u0003\u0019)\u0017/^1mgR!\u0011\u0011KA/\u0011!\tY$EA\u0001\u0002\u0004A\bf\u0004\u0001\u0002b\u0005\u001d\u0014\u0011NA7\u0003_\n\u0019(!\u001e\u0011\u0007%\n\u0019'C\u0002\u0002fi\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002l\u0005\t9b\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011cSR\u001c\b\u0005\u001e5bi\u0002\n'/\u001a\u0011tKR\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013M]4v[\u0016tG\u000fI3yaJ\u0004\u0013m\u001d\u0011b]\u0002*hn]5h]\u0016$\u0007E\u000e\u001b.E&$\b%\u001b8uK\u001e,'\u000f\f\u0011pe\u0002rU\u000b\u0014'!S\u001a\u0004C\u000f[3!CJ<W/\\3oi\u0002J7\u000f\t(V\u00192s\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005E\u0014\u0001\u000e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)a%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qO\u0001\u0006g9\u0002d\u0006M\u0001\r\u0005&$x/[:f\u0007>,h\u000e\u001e\t\u0003SM\u0019BaEA@kA1\u0011\u0011QADu\u0001k!!a!\u000b\u0007\u0005\u0015\u0015'A\u0004sk:$\u0018.\\3\n\t\u0005%\u00151\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAA>)\t\ti\"A\u0003baBd\u0017\u0010F\u0002A\u0003'CQ\u0001\u000f\fA\u0002i\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001a\u0006}\u0005\u0003\u0002\u0019\u0002\u001cjJ1!!(2\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011U\f\u0002\u0002\u0003\u0007\u0001)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0015\t\u0005\u0003?\tI+\u0003\u0003\u0002,\u0006\u0005\"AB(cU\u0016\u001cG\u000f")
public class BitwiseCount
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitwiseCount bitwiseCount) {
        return BitwiseCount$.MODULE$.unapply(bitwiseCount);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitwiseCount, A> function1) {
        return BitwiseCount$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitwiseCount> compose(Function1<A, Expression> function1) {
        return BitwiseCount$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, BooleanType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String toString() {
        return new StringBuilder(11).append("bit_count(").append(this.child()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "bit_count";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        ExprCode exprCode = BooleanType$.MODULE$.equals(dataType) ? this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(14).append("if (").append((String)c).append(") 1 else 0").toString()) : this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(25).append("java.lang.Long.bitCount(").append((String)c).append(")").toString());
        return exprCode;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Integer n;
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.unboxToBoolean((Object)input) ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0);
        } else if (ByteType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToByte((Object)input)));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToShort((Object)input)));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToInt((Object)input)));
        } else if (LongType$.MODULE$.equals(dataType)) {
            n = BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToLong((Object)input)));
        } else {
            throw new MatchError((Object)dataType);
        }
        return n;
    }

    public BitwiseCount copy(Expression child) {
        return new BitwiseCount(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitwiseCount";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseCount bitwiseCount = (BitwiseCount)x$1;
        Expression expression = this.child();
        Expression expression2 = bitwiseCount.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitwiseCount.canEqual(this)) return false;
        return true;
    }

    public BitwiseCount(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

