/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AddMonths$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, num_months) - Returns the date that is `num_months` after `start_date`.", examples="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 1);\n       2016-09-30\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011>\u0011\u0015Q\u0005\u0001\"\u0011>\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015a\b\u0001\"\u0011~\u0011%\ti\u0001AA\u0001\n\u0003\ty\u0001C\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011Q\u0006\u0001\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003_\u0001\u0011\u0011!C!\u0003cA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\t\u0013\u0005-\u0003!!A\u0005\u0002\u00055\u0003\"CA*\u0001\u0005\u0005I\u0011IA+\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r\u001dI\u0011Q\u0013\u0010\u0002\u0002#\u0005\u0011q\u0013\u0004\t;y\t\t\u0011#\u0001\u0002\u001a\"1Ai\u0006C\u0001\u0003OC\u0011\"!+\u0018\u0003\u0003%)%a+\t\u0013\u00055v#!A\u0005\u0002\u0006=\u0006\"CA[/\u0005\u0005I\u0011QA\\\u0011%\tImFA\u0001\n\u0013\tYMA\u0005BI\u0012luN\u001c;ig*\u0011q\u0004I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\"E\u0005A1-\u0019;bYf\u001cHO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001YA\u001a\u0014\b\u0005\u0002.]5\ta$\u0003\u00020=\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003[EJ!A\r\u0010\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00025u%\u00111(\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ngR\f'\u000f\u001e#bi\u0016,\u0012A\u0010\t\u0003[}J!\u0001\u0011\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0006ti\u0006\u0014H\u000fR1uK\u0002\n\u0011B\\;n\u001b>tG\u000f[:\u0002\u00159,X.T8oi\"\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\r\u001eC\u0005CA\u0017\u0001\u0011\u0015aT\u00011\u0001?\u0011\u0015\u0011U\u00011\u0001?\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001N!\rqe+\u0017\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014BA+6\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002VkA\u0011!,X\u0007\u00027*\u0011ALI\u0001\u0006if\u0004Xm]\u0005\u0003=n\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0019\t\u00035\nL!aY.\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAB\\;mYN\u000bg-Z#wC2$2AZ5l!\t!t-\u0003\u0002ik\t\u0019\u0011I\\=\t\u000b)T\u0001\u0019\u00014\u0002\u000bM$\u0018M\u001d;\t\u000b1T\u0001\u0019\u00014\u0002\r5|g\u000e\u001e5t\u0003%!wnR3o\u0007>$W\rF\u0002pkj\u0004\"\u0001]:\u000e\u0003ET!A\u001d\u0010\u0002\u000f\r|G-Z4f]&\u0011A/\u001d\u0002\t\u000bb\u0004(oQ8eK\")ao\u0003a\u0001o\u0006\u00191\r\u001e=\u0011\u0005AD\u0018BA=r\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa_\u0006A\u0002=\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001\u007f!\ry\u0018q\u0001\b\u0005\u0003\u0003\t\u0019\u0001\u0005\u0002Qk%\u0019\u0011QA\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\u0003\u0003\rM#(/\u001b8h\u0015\r\t)!N\u0001\u0005G>\u0004\u0018\u0010F\u0003G\u0003#\t\u0019\u0002C\u0004=\u001bA\u0005\t\u0019\u0001 \t\u000f\tk\u0001\u0013!a\u0001}\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\rU\rq\u00141D\u0016\u0003\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0005v]\u000eDWmY6fI*\u0019\u0011qE\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0005\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00024A!\u0011QGA \u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012\u0001\u00027b]\u001eT!!!\u0010\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\t9$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002FA\u0019A'a\u0012\n\u0007\u0005%SGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002g\u0003\u001fB\u0011\"!\u0015\u0013\u0003\u0003\u0005\r!!\u0012\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0006E\u0003\u0002Z\u0005}c-\u0004\u0002\u0002\\)\u0019\u0011QL\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002b\u0005m#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001a\u0002nA\u0019A'!\u001b\n\u0007\u0005-TGA\u0004C_>dW-\u00198\t\u0011\u0005EC#!AA\u0002\u0019\fa!Z9vC2\u001cH\u0003BA4\u0003gB\u0001\"!\u0015\u0016\u0003\u0003\u0005\rA\u001a\u0015\u0014\u0001\u0005]\u0014QPA@\u0003\u0007\u000b))!#\u0002\f\u0006=\u0015\u0011\u0013\t\u0004[\u0005e\u0014bAA>=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAA\u0003i{f)\u0016(D?\"\u001aH/\u0019:u?\u0012\fG/\u001a\u0017!]Vlw,\\8oi\"\u001c\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t3bi\u0016\u0004C\u000f[1uA%\u001c\b\u0005\u00198v[~kwN\u001c;ig\u0002\u0004\u0013M\u001a;fe\u0002\u00027\u000f^1si~#\u0017\r^3a]\u0005AQ\r_1na2,7/\t\u0002\u0002\b\u0006Y%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001d.gE:C\u0006I\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c.aej3\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012\u0011QR\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019*A\u00032]Ur\u0003'A\u0005BI\u0012luN\u001c;igB\u0011QfF\n\u0005/\u0005m\u0015\bE\u0004\u0002\u001e\u0006\rfH\u0010$\u000e\u0005\u0005}%bAAQk\u00059!/\u001e8uS6,\u0017\u0002BAS\u0003?\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\t9*\u0001\u0005u_N#(/\u001b8h)\t\t\u0019$A\u0003baBd\u0017\u0010F\u0003G\u0003c\u000b\u0019\fC\u0003=5\u0001\u0007a\bC\u0003C5\u0001\u0007a(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0016Q\u0019\t\u0006i\u0005m\u0016qX\u0005\u0004\u0003{+$AB(qi&|g\u000eE\u00035\u0003\u0003td(C\u0002\u0002DV\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAd7\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAg!\u0011\t)$a4\n\t\u0005E\u0017q\u0007\u0002\u0007\u001f\nTWm\u0019;")
public class AddMonths
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression startDate;
    private final Expression numMonths;

    public static Option<Tuple2<Expression, Expression>> unapply(AddMonths addMonths) {
        return AddMonths$.MODULE$.unapply(addMonths);
    }

    public static Function1<Tuple2<Expression, Expression>, AddMonths> tupled() {
        return AddMonths$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, AddMonths>> curried() {
        return AddMonths$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression numMonths() {
        return this.numMonths;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.numMonths();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object start, Object months) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(BoxesRunTime.unboxToInt((Object)start), BoxesRunTime.unboxToInt((Object)months)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, m) -> new StringBuilder(18).append(dtu).append(".dateAddMonths(").append((String)sd).append(", ").append((String)m).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "add_months";
    }

    public AddMonths copy(Expression startDate, Expression numMonths) {
        return new AddMonths(startDate, numMonths);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.numMonths();
    }

    @Override
    public String productPrefix() {
        return "AddMonths";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.numMonths();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AddMonths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AddMonths)) return false;
        boolean bl = true;
        if (!bl) return false;
        AddMonths addMonths = (AddMonths)x$1;
        Expression expression = this.startDate();
        Expression expression2 = addMonths.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.numMonths();
        Expression expression4 = addMonths.numMonths();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!addMonths.canEqual(this)) return false;
        return true;
    }

    public AddMonths(Expression startDate, Expression numMonths) {
        this.startDate = startDate;
        this.numMonths = numMonths;
        ExpectsInputTypes.$init$(this);
    }
}

