/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZkClientConnectionStrategy {
    private static Logger log = LoggerFactory.getLogger(ZkClientConnectionStrategy.class);
    private List<DisconnectedListener> disconnectedListeners = new ArrayList<DisconnectedListener>();
    private List<ConnectedListener> connectedListeners = new ArrayList<ConnectedListener>();

    public abstract void connect(String var1, int var2, Watcher var3, ZkUpdate var4) throws IOException, InterruptedException, TimeoutException;

    public abstract void reconnect(String var1, int var2, Watcher var3, ZkUpdate var4) throws IOException, InterruptedException, TimeoutException;

    public synchronized void disconnected() {
        for (DisconnectedListener listener : this.disconnectedListeners) {
            try {
                listener.disconnected();
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
        }
    }

    public synchronized void connected() {
        for (ConnectedListener listener : this.connectedListeners) {
            try {
                listener.connected();
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
        }
    }

    public synchronized void addDisconnectedListener(DisconnectedListener listener) {
        this.disconnectedListeners.add(listener);
    }

    public synchronized void addConnectedListener(ConnectedListener listener) {
        this.connectedListeners.add(listener);
    }

    public static abstract class ZkUpdate {
        public abstract void update(SolrZooKeeper var1) throws InterruptedException, TimeoutException, IOException;
    }

    public static interface ConnectedListener {
        public void connected();
    }

    public static interface DisconnectedListener {
        public void disconnected();
    }
}

