/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.topics;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.google.common.hash.Hashing;

public final class TopicList {
    public static final String ALL_TOPICS_PATTERN = ".*";
    private static final String SCHEME_SEPARATOR = "://";
    private static final Pattern SCHEME_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("://"));

    public static List<String> filterTopics(List<String> original, String regex) {
        Pattern topicsPattern = Pattern.compile(regex);
        return TopicList.filterTopics(original, topicsPattern);
    }

    public static List<String> filterTopics(List<String> original, Pattern topicsPattern) {
        Pattern shortenedTopicsPattern = topicsPattern.toString().contains(SCHEME_SEPARATOR) ? Pattern.compile(SCHEME_SEPARATOR_PATTERN.split(topicsPattern.toString())[1]) : topicsPattern;
        return original.stream().map(TopicName::get).map(TopicName::toString).filter(topic -> shortenedTopicsPattern.matcher(SCHEME_SEPARATOR_PATTERN.split((CharSequence)topic)[1]).matches()).collect(Collectors.toList());
    }

    public static List<String> filterSystemTopic(List<String> original) {
        return original.stream().filter(topic -> !SystemTopicNames.isSystemTopic(TopicName.get(topic))).collect(Collectors.toList());
    }

    public static String calculateHash(List<String> topics) {
        return Hashing.crc32c().hashBytes(topics.stream().sorted().collect(Collectors.joining(",")).getBytes(StandardCharsets.UTF_8)).toString();
    }

    public static Set<String> minus(Collection<String> list1, Collection<String> list2) {
        HashSet<String> s1 = new HashSet<String>(list1);
        s1.removeAll(list2);
        return s1;
    }

    private TopicList() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

