/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.operation.DefaultValueAssigner;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.metrics.ScanMetrics;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.table.source.PlanImpl;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.SnapshotManager;

public class SnapshotReaderImpl
implements SnapshotReader {
    private final FileStoreScan scan;
    private final TableSchema tableSchema;
    private final CoreOptions options;
    private final boolean deletionVectors;
    private final SnapshotManager snapshotManager;
    private final ConsumerManager consumerManager;
    private final SplitGenerator splitGenerator;
    private final BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer;
    private final DefaultValueAssigner defaultValueAssigner;
    private final FileStorePathFactory pathFactory;
    private final String tableName;
    private final IndexFileHandler indexFileHandler;
    private ScanMode scanMode = ScanMode.ALL;
    private RecordComparator lazyPartitionComparator;

    public SnapshotReaderImpl(FileStoreScan scan, TableSchema tableSchema, CoreOptions options, SnapshotManager snapshotManager, SplitGenerator splitGenerator, BiConsumer<FileStoreScan, Predicate> nonPartitionFilterConsumer, DefaultValueAssigner defaultValueAssigner, FileStorePathFactory pathFactory, String tableName, IndexFileHandler indexFileHandler) {
        this.scan = scan;
        this.tableSchema = tableSchema;
        this.options = options;
        this.deletionVectors = options.deletionVectorsEnabled();
        this.snapshotManager = snapshotManager;
        this.consumerManager = new ConsumerManager(snapshotManager.fileIO(), snapshotManager.tablePath());
        this.splitGenerator = splitGenerator;
        this.nonPartitionFilterConsumer = nonPartitionFilterConsumer;
        this.defaultValueAssigner = defaultValueAssigner;
        this.pathFactory = pathFactory;
        this.tableName = tableName;
        this.indexFileHandler = indexFileHandler;
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.snapshotManager;
    }

    @Override
    public ConsumerManager consumerManager() {
        return this.consumerManager;
    }

    @Override
    public SplitGenerator splitGenerator() {
        return this.splitGenerator;
    }

    @Override
    public SnapshotReader withSnapshot(long snapshotId) {
        this.scan.withSnapshot(snapshotId);
        return this;
    }

    @Override
    public SnapshotReader withSnapshot(Snapshot snapshot) {
        this.scan.withSnapshot(snapshot);
        return this;
    }

    @Override
    public SnapshotReader withPartitionFilter(Map<String, String> partitionSpec) {
        if (partitionSpec != null) {
            Predicate partitionPredicate = PartitionPredicate.createPartitionPredicate(partitionSpec, this.tableSchema.logicalPartitionType(), this.options.partitionDefaultName());
            this.scan.withPartitionFilter(partitionPredicate);
        }
        return this;
    }

    @Override
    public SnapshotReader withPartitionFilter(Predicate predicate) {
        this.scan.withPartitionFilter(predicate);
        return this;
    }

    @Override
    public SnapshotReader withFilter(Predicate predicate) {
        List<String> partitionKeys = this.tableSchema.partitionKeys();
        int[] fieldIdxToPartitionIdx = this.tableSchema.fields().stream().mapToInt(f -> partitionKeys.indexOf(f.name())).toArray();
        ArrayList<Predicate> partitionFilters = new ArrayList<Predicate>();
        ArrayList<Predicate> nonPartitionFilters = new ArrayList<Predicate>();
        for (Predicate p : PredicateBuilder.splitAnd(this.defaultValueAssigner.handlePredicate(predicate))) {
            Optional<Predicate> mapped = PredicateBuilder.transformFieldMapping(p, fieldIdxToPartitionIdx);
            if (mapped.isPresent()) {
                partitionFilters.add(mapped.get());
                continue;
            }
            nonPartitionFilters.add(p);
        }
        if (partitionFilters.size() > 0) {
            this.scan.withPartitionFilter(PredicateBuilder.and(partitionFilters));
        }
        if (nonPartitionFilters.size() > 0) {
            this.nonPartitionFilterConsumer.accept(this.scan, PredicateBuilder.and(nonPartitionFilters));
        }
        return this;
    }

    @Override
    public SnapshotReader withMode(ScanMode scanMode) {
        this.scanMode = scanMode;
        this.scan.withKind(scanMode);
        return this;
    }

    @Override
    public SnapshotReader withLevelFilter(Filter<Integer> levelFilter) {
        this.scan.withLevelFilter(levelFilter);
        return this;
    }

    @Override
    public SnapshotReader withDataFileTimeMills(long dataFileTimeMills) {
        this.scan.withDataFileTimeMills(dataFileTimeMills);
        return this;
    }

    @Override
    public SnapshotReader withBucket(int bucket) {
        this.scan.withBucket(bucket);
        return this;
    }

    @Override
    public SnapshotReader withBucketFilter(Filter<Integer> bucketFilter) {
        this.scan.withBucketFilter(bucketFilter);
        return this;
    }

    @Override
    public SnapshotReader withMetricRegistry(MetricRegistry registry) {
        this.scan.withMetrics(new ScanMetrics(registry, this.tableName));
        return this;
    }

    @Override
    public SnapshotReader.Plan read() {
        FileStoreScan.Plan plan = this.scan.plan();
        Long snapshotId = plan.snapshotId();
        Map<BinaryRow, Map<Integer, List<DataFileMeta>>> files = FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.ADD));
        if (this.options.scanPlanSortPartition()) {
            LinkedHashMap<BinaryRow, Map<Integer, List<DataFileMeta>>> newFiles = new LinkedHashMap<BinaryRow, Map<Integer, List<DataFileMeta>>>();
            files.entrySet().stream().sorted((o1, o2) -> this.partitionComparator().compare((InternalRow)o1.getKey(), (InternalRow)o2.getKey())).forEach(entry -> {
                Map cfr_ignored_0 = (Map)newFiles.put((BinaryRow)entry.getKey(), (Map<Integer, List<DataFileMeta>>)entry.getValue());
            });
            files = newFiles;
        }
        List<Split> splits = this.generateSplits(snapshotId == null ? 0L : snapshotId, this.scanMode != ScanMode.ALL, this.splitGenerator, files);
        return new PlanImpl(plan.watermark(), plan.snapshotId(), splits);
    }

    private List<DataSplit> generateSplits(long snapshotId, boolean isStreaming, SplitGenerator splitGenerator, Map<BinaryRow, Map<Integer, List<DataFileMeta>>> groupedDataFiles) {
        ArrayList<DataSplit> splits = new ArrayList<DataSplit>();
        Map deletionIndexFilesMap = this.deletionVectors ? this.indexFileHandler.scanPartitions(snapshotId, "DELETION_VECTORS", groupedDataFiles.keySet()) : Collections.emptyMap();
        for (Map.Entry<BinaryRow, Map<Integer, List<DataFileMeta>>> entry : groupedDataFiles.entrySet()) {
            BinaryRow partition = entry.getKey();
            Map<Integer, List<DataFileMeta>> buckets = entry.getValue();
            for (Map.Entry<Integer, List<DataFileMeta>> bucketEntry : buckets.entrySet()) {
                int bucket = bucketEntry.getKey();
                List<DataFileMeta> bucketFiles = bucketEntry.getValue();
                DataSplit.Builder builder = DataSplit.builder().withSnapshot(snapshotId).withPartition(partition).withBucket(bucket).isStreaming(isStreaming);
                List<SplitGenerator.SplitGroup> splitGroups = isStreaming ? splitGenerator.splitForStreaming(bucketFiles) : splitGenerator.splitForBatch(bucketFiles);
                List deletionIndexFiles = deletionIndexFilesMap.getOrDefault(Pair.of(partition, bucket), Collections.emptyList());
                if (deletionIndexFiles.size() > 1) {
                    throw new IllegalArgumentException("Find multiple index files for one bucket: " + deletionIndexFiles);
                }
                IndexFileMeta deletionIndexFile = deletionIndexFiles.isEmpty() ? null : (IndexFileMeta)deletionIndexFiles.get(0);
                for (SplitGenerator.SplitGroup splitGroup : splitGroups) {
                    List<DataFileMeta> dataFiles = splitGroup.files;
                    String bucketPath = this.pathFactory.bucketPath(partition, bucket).toString();
                    builder.withDataFiles(dataFiles).rawConvertible(splitGroup.rawConvertible).withBucketPath(bucketPath);
                    if (this.deletionVectors) {
                        builder.withDataDeletionFiles(this.getDeletionFiles(dataFiles, deletionIndexFile));
                    }
                    splits.add(builder.build());
                }
            }
        }
        return splits;
    }

    @Override
    public List<BinaryRow> partitions() {
        return this.scan.listPartitions();
    }

    @Override
    public List<PartitionEntry> partitionEntries() {
        return this.scan.readPartitionEntries();
    }

    @Override
    public SnapshotReader.Plan readChanges() {
        this.withMode(ScanMode.DELTA);
        FileStoreScan.Plan plan = this.scan.plan();
        Map<BinaryRow, Map<Integer, List<DataFileMeta>>> beforeFiles = FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.DELETE));
        Map<BinaryRow, Map<Integer, List<DataFileMeta>>> dataFiles = FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.ADD));
        return this.toChangesPlan(true, plan, plan.snapshotId() - 1L, beforeFiles, dataFiles);
    }

    private SnapshotReader.Plan toChangesPlan(boolean isStreaming, FileStoreScan.Plan plan, long beforeSnapshotId, Map<BinaryRow, Map<Integer, List<DataFileMeta>>> beforeFiles, Map<BinaryRow, Map<Integer, List<DataFileMeta>>> dataFiles) {
        ArrayList<Split> splits = new ArrayList<Split>();
        HashMap buckets = new HashMap();
        beforeFiles.forEach((part, bucketMap) -> buckets.computeIfAbsent(part, k -> new HashSet()).addAll(bucketMap.keySet()));
        dataFiles.forEach((part, bucketMap) -> buckets.computeIfAbsent(part, k -> new HashSet()).addAll(bucketMap.keySet()));
        Map beforDeletionIndexFilesMap = this.deletionVectors ? this.indexFileHandler.scanPartitions(beforeSnapshotId, "DELETION_VECTORS", beforeFiles.keySet()) : Collections.emptyMap();
        Map deletionIndexFilesMap = this.deletionVectors ? this.indexFileHandler.scanPartitions(plan.snapshotId(), "DELETION_VECTORS", dataFiles.keySet()) : Collections.emptyMap();
        for (Map.Entry entry : buckets.entrySet()) {
            BinaryRow part2 = (BinaryRow)entry.getKey();
            for (Integer bucket : (Set)entry.getValue()) {
                List<DataFileMeta> before = beforeFiles.getOrDefault(part2, Collections.emptyMap()).getOrDefault(bucket, Collections.emptyList());
                List<DataFileMeta> data = dataFiles.getOrDefault(part2, Collections.emptyMap()).getOrDefault(bucket, Collections.emptyList());
                before.removeIf(data::remove);
                DataSplit.Builder builder = DataSplit.builder().withSnapshot(plan.snapshotId()).withPartition(part2).withBucket(bucket).withBeforeFiles(before).withDataFiles(data).isStreaming(isStreaming).withBucketPath(this.pathFactory.bucketPath(part2, bucket).toString());
                if (this.deletionVectors) {
                    List beforeDeletionIndexes = beforDeletionIndexFilesMap.getOrDefault(Pair.of(part2, bucket), Collections.emptyList());
                    IndexFileMeta beforeDeletionIndex = beforeDeletionIndexes.isEmpty() ? null : (IndexFileMeta)beforeDeletionIndexes.get(0);
                    List deletionIndexes = deletionIndexFilesMap.getOrDefault(Pair.of(part2, bucket), Collections.emptyList());
                    IndexFileMeta deletionIndex = deletionIndexes.isEmpty() ? null : (IndexFileMeta)deletionIndexes.get(0);
                    builder.withBeforeDeletionFiles(this.getDeletionFiles(before, beforeDeletionIndex));
                    builder.withDataDeletionFiles(this.getDeletionFiles(data, deletionIndex));
                }
                splits.add(builder.build());
            }
        }
        return new PlanImpl(plan.watermark(), plan.snapshotId(), splits);
    }

    @Override
    public SnapshotReader.Plan readIncrementalDiff(Snapshot before) {
        this.withMode(ScanMode.ALL);
        FileStoreScan.Plan plan = this.scan.plan();
        Map<BinaryRow, Map<Integer, List<DataFileMeta>>> dataFiles = FileStoreScan.Plan.groupByPartFiles(plan.files(FileKind.ADD));
        Map<BinaryRow, Map<Integer, List<DataFileMeta>>> beforeFiles = FileStoreScan.Plan.groupByPartFiles(this.scan.withSnapshot(before).plan().files(FileKind.ADD));
        return this.toChangesPlan(false, plan, before.id(), beforeFiles, dataFiles);
    }

    private RecordComparator partitionComparator() {
        if (this.lazyPartitionComparator == null) {
            this.lazyPartitionComparator = CodeGenUtils.newRecordComparator(this.tableSchema.logicalPartitionType().getFieldTypes());
        }
        return this.lazyPartitionComparator;
    }

    private List<DeletionFile> getDeletionFiles(List<DataFileMeta> dataFiles, @Nullable IndexFileMeta indexFileMeta) {
        ArrayList<DeletionFile> deletionFiles = new ArrayList<DeletionFile>(dataFiles.size());
        LinkedHashMap<String, Pair<Integer, Integer>> deletionRanges = indexFileMeta == null ? null : indexFileMeta.deletionVectorsRanges();
        for (DataFileMeta file : dataFiles) {
            Pair range;
            if (deletionRanges != null && (range = (Pair)deletionRanges.get(file.fileName())) != null) {
                deletionFiles.add(new DeletionFile(this.indexFileHandler.filePath(indexFileMeta).toString(), ((Integer)range.getKey()).intValue(), ((Integer)range.getValue()).intValue()));
                continue;
            }
            deletionFiles.add(null);
        }
        return deletionFiles;
    }
}

