/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.statistics;

import java.util.Arrays;
import java.util.regex.Matcher;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.statistics.CountsFieldStatsCollector;
import org.apache.paimon.statistics.FullFieldStatsCollector;
import org.apache.paimon.statistics.NoneFieldStatsCollector;
import org.apache.paimon.statistics.TruncateFieldStatsCollector;

public interface FieldStatsCollector {
    public void collect(Object var1, Serializer<Object> var2);

    public FieldStats result();

    public FieldStats convert(FieldStats var1);

    public static FieldStatsCollector[] create(Factory[] factories) {
        FieldStatsCollector[] collectors = new FieldStatsCollector[factories.length];
        for (int i = 0; i < factories.length; ++i) {
            collectors[i] = factories[i].create();
        }
        return collectors;
    }

    public static Factory from(String option) {
        String upper;
        switch (upper = option.toUpperCase()) {
            case "NONE": {
                return NoneFieldStatsCollector::new;
            }
            case "FULL": {
                return FullFieldStatsCollector::new;
            }
            case "COUNTS": {
                return CountsFieldStatsCollector::new;
            }
        }
        Matcher matcher = TruncateFieldStatsCollector.TRUNCATE_PATTERN.matcher(upper);
        if (matcher.matches()) {
            String length = matcher.group(1);
            return () -> new TruncateFieldStatsCollector(Integer.parseInt(length));
        }
        throw new IllegalArgumentException("Unexpected option: " + option);
    }

    public static Factory[] createFullStatsFactories(int numFields) {
        Object[] factories = new Factory[numFields];
        Arrays.fill(factories, FullFieldStatsCollector::new);
        return factories;
    }

    public static interface Factory {
        public FieldStatsCollector create();
    }
}

