/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.schema;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeCasts;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.ReassignFieldId;
import org.apache.paimon.types.RowType;

public class SchemaMergingUtils {
    public static TableSchema mergeSchemas(TableSchema currentTableSchema, RowType dataFields, boolean allowExplicitCast) {
        if (currentTableSchema.logicalRowType().equals(dataFields)) {
            return currentTableSchema;
        }
        AtomicInteger highestFieldId = new AtomicInteger(currentTableSchema.highestFieldId());
        RowType newRowType = SchemaMergingUtils.mergeSchemas(currentTableSchema.logicalRowType(), dataFields, highestFieldId, allowExplicitCast);
        return new TableSchema(currentTableSchema.id() + 1L, newRowType.getFields(), highestFieldId.get(), currentTableSchema.partitionKeys(), currentTableSchema.primaryKeys(), currentTableSchema.options(), currentTableSchema.comment());
    }

    public static RowType mergeSchemas(RowType tableSchema, RowType dataSchema, AtomicInteger highestFieldId, boolean allowExplicitCast) {
        return (RowType)SchemaMergingUtils.merge(tableSchema, dataSchema, highestFieldId, allowExplicitCast);
    }

    public static DataType merge(DataType base0, DataType update0, AtomicInteger highestFieldId, boolean allowExplicitCast) {
        DataType update;
        DataType base = base0.copy(true);
        if (base.equals(update = update0.copy(true))) {
            return base0;
        }
        if (base instanceof RowType && update instanceof RowType) {
            List<DataField> baseFields = ((RowType)base).getFields();
            List<DataField> updateFields = ((RowType)update).getFields();
            Map updateFieldMap = updateFields.stream().collect(Collectors.toMap(DataField::name, Function.identity()));
            List<DataField> updatedFields = baseFields.stream().map(baseField -> {
                if (updateFieldMap.containsKey(baseField.name())) {
                    DataField updateField = (DataField)updateFieldMap.get(baseField.name());
                    DataType updatedDataType = SchemaMergingUtils.merge(baseField.type(), updateField.type(), highestFieldId, allowExplicitCast);
                    return new DataField(baseField.id(), baseField.name(), updatedDataType, baseField.description());
                }
                return baseField;
            }).collect(Collectors.toList());
            Map baseFieldMap = baseFields.stream().collect(Collectors.toMap(DataField::name, Function.identity()));
            List newFields = updateFields.stream().filter(field -> !baseFieldMap.containsKey(field.name())).map(field -> SchemaMergingUtils.assignIdForNewField(field, highestFieldId)).collect(Collectors.toList());
            updatedFields.addAll(newFields);
            return new RowType(base.isNullable(), updatedFields);
        }
        if (base instanceof MapType && update instanceof MapType) {
            return new MapType(base.isNullable(), SchemaMergingUtils.merge(((MapType)base).getKeyType(), ((MapType)update).getKeyType(), highestFieldId, allowExplicitCast), SchemaMergingUtils.merge(((MapType)base).getValueType(), ((MapType)update).getValueType(), highestFieldId, allowExplicitCast));
        }
        if (base instanceof ArrayType && update instanceof ArrayType) {
            return new ArrayType(base.isNullable(), SchemaMergingUtils.merge(((ArrayType)base).getElementType(), ((ArrayType)update).getElementType(), highestFieldId, allowExplicitCast));
        }
        if (base instanceof MultisetType && update instanceof MultisetType) {
            return new MultisetType(base.isNullable(), SchemaMergingUtils.merge(((MultisetType)base).getElementType(), ((MultisetType)update).getElementType(), highestFieldId, allowExplicitCast));
        }
        if (base instanceof DecimalType && update instanceof DecimalType) {
            if (base.equals(update)) {
                return base0;
            }
            throw new UnsupportedOperationException(String.format("Failed to merge decimal types with different precision or scale: %s and %s", base, update));
        }
        if (SchemaMergingUtils.supportsDataTypesCast(base, update, allowExplicitCast)) {
            if (DataTypes.getLength(base).isPresent() && DataTypes.getLength(update).isPresent()) {
                if (allowExplicitCast || DataTypes.getLength(base).getAsInt() <= DataTypes.getLength(update).getAsInt()) {
                    return update.copy(base0.isNullable());
                }
                throw new UnsupportedOperationException(String.format("Failed to merge the target type that has a smaller length: %s and %s", base, update));
            }
            if (DataTypes.getPrecision(base).isPresent() && DataTypes.getPrecision(update).isPresent()) {
                if (allowExplicitCast || DataTypes.getPrecision(base).getAsInt() <= DataTypes.getPrecision(update).getAsInt()) {
                    return update.copy(base0.isNullable());
                }
                throw new UnsupportedOperationException(String.format("Failed to merge the target type that has a lower precision: %s and %s", base, update));
            }
            return update.copy(base0.isNullable());
        }
        throw new UnsupportedOperationException(String.format("Failed to merge data types %s and %s", base, update));
    }

    private static boolean supportsDataTypesCast(DataType sourceType, DataType targetType, boolean allowExplicitCast) {
        boolean canImplicitCast = DataTypeCasts.supportsImplicitCast(sourceType, targetType);
        boolean canExplicitCast = allowExplicitCast && DataTypeCasts.supportsExplicitCast(sourceType, targetType);
        return canImplicitCast || canExplicitCast;
    }

    private static DataField assignIdForNewField(DataField field, AtomicInteger highestFieldId) {
        DataType dataType = ReassignFieldId.reassign(field.type(), highestFieldId);
        return new DataField(highestFieldId.incrementAndGet(), field.name(), dataType, field.description());
    }
}

