/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.Comparator;
import java.util.List;
import org.apache.paimon.AbstractFileStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.operation.AppendOnlyFileStoreScan;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.operation.RawFileSplitRead;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.types.RowType;

public class AppendOnlyFileStore
extends AbstractFileStore<InternalRow> {
    private final RowType bucketKeyType;
    private final RowType rowType;
    private final String tableName;

    public AppendOnlyFileStore(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, CoreOptions options, RowType partitionType, RowType bucketKeyType, RowType rowType, String tableName, CatalogEnvironment catalogEnvironment) {
        super(fileIO, schemaManager, schema, options, partitionType, catalogEnvironment);
        this.bucketKeyType = bucketKeyType;
        this.rowType = rowType;
        this.tableName = tableName;
    }

    @Override
    public BucketMode bucketMode() {
        return this.options.bucket() == -1 ? BucketMode.UNAWARE : BucketMode.FIXED;
    }

    @Override
    public AppendOnlyFileStoreScan newScan() {
        return this.newScan("main");
    }

    @Override
    public AppendOnlyFileStoreScan newScan(String branchName) {
        return this.newScan(false, branchName);
    }

    public RawFileSplitRead newRead() {
        return new RawFileSplitRead(this.fileIO, this.schemaManager, this.schema, this.rowType, FileFormatDiscover.of(this.options), this.pathFactory(), this.options.fileIndexReadEnabled());
    }

    public AppendOnlyFileStoreWrite newWrite(String commitUser) {
        return this.newWrite(commitUser, null);
    }

    public AppendOnlyFileStoreWrite newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
        return new AppendOnlyFileStoreWrite(this.fileIO, this.newRead(), this.schema.id(), commitUser, this.rowType, this.pathFactory(), this.snapshotManager(), this.newScan(true, "main").withManifestCacheFilter(manifestFilter), this.options, this.tableName);
    }

    private AppendOnlyFileStoreScan newScan(boolean forWrite, String branchName) {
        ScanBucketFilter bucketFilter = new ScanBucketFilter(this.bucketKeyType){

            @Override
            public void pushdown(Predicate predicate) {
                if (AppendOnlyFileStore.this.bucketMode() != BucketMode.FIXED) {
                    return;
                }
                if (AppendOnlyFileStore.this.bucketKeyType.getFieldCount() == 0) {
                    return;
                }
                List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), AppendOnlyFileStore.this.rowType.getFieldNames(), AppendOnlyFileStore.this.bucketKeyType.getFieldNames());
                if (bucketFilters.size() > 0) {
                    this.setBucketKeyFilter(PredicateBuilder.and(bucketFilters));
                }
            }
        };
        return new AppendOnlyFileStoreScan(this.partitionType, bucketFilter, this.snapshotManager(), this.schemaManager, this.schema, this.manifestFileFactory(forWrite), this.manifestListFactory(forWrite), this.options.bucket(), forWrite, this.options.scanManifestParallelism(), branchName, this.options.fileIndexReadEnabled());
    }

    @Override
    public Comparator<InternalRow> newKeyComparator() {
        return null;
    }
}

