/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.util.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = Executors.defaultThreadFactory();
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix = "pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";

    private DaemonThreadFactory() {
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = DEFAULT_THREAD_FACTORY.newThread(r);
        t.setName(this.namePrefix + this.threadNumber.getAndIncrement());
        t.setDaemon(true);
        return t;
    }

    public static ThreadFactory newDaemonThreadFactory() {
        return new DaemonThreadFactory();
    }

    public static ThreadFactory newDaemonThreadFactory(String name) {
        return new NamedThreadFactory(name);
    }

    public static Thread newDaemonThread(Runnable r) {
        return new DaemonThreadFactory().newThread(r);
    }

    public static Thread newDaemonThread(Runnable r, String name) {
        Thread t = new DaemonThreadFactory().newThread(r);
        t.setName(name);
        return t;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String name;

        private NamedThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return DaemonThreadFactory.newDaemonThread(r, this.name);
        }
    }
}

