/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.Level;
import org.apache.maven.plugin.surefire.report.NullConsoleOutputReceiver;
import org.apache.maven.plugin.surefire.report.NullConsoleReporter;
import org.apache.maven.plugin.surefire.report.NullFileReporter;
import org.apache.maven.plugin.surefire.report.NullStatelessXmlReporter;
import org.apache.maven.plugin.surefire.report.NullStatisticsReporter;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.ReportsMerger;
import org.apache.maven.plugin.surefire.report.TestMethodStats;
import org.apache.maven.plugin.surefire.report.TestSetRunListener;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.util.internal.ObjectUtils;
import org.apache.maven.surefire.extensions.ConsoleOutputReportEventListener;
import org.apache.maven.surefire.extensions.StatelessReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoFileReportEventListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class DefaultReporterFactory
implements ReporterFactory,
ReportsMerger {
    private final Collection<TestSetRunListener> listeners = new ConcurrentLinkedQueue<TestSetRunListener>();
    private final StartupReportConfiguration reportConfiguration;
    private final ConsoleLogger consoleLogger;
    private final Integer forkNumber;
    private RunStatistics globalStats = new RunStatistics();
    private Map<String, List<TestMethodStats>> successTests;
    private Map<String, List<TestMethodStats>> flakyTests;
    private Map<String, List<TestMethodStats>> failedTests;
    private Map<String, List<TestMethodStats>> errorTests;

    public DefaultReporterFactory(StartupReportConfiguration reportConfiguration, ConsoleLogger consoleLogger) {
        this(reportConfiguration, consoleLogger, null);
    }

    public DefaultReporterFactory(StartupReportConfiguration reportConfiguration, ConsoleLogger consoleLogger, Integer forkNumber) {
        this.reportConfiguration = reportConfiguration;
        this.consoleLogger = consoleLogger;
        this.forkNumber = forkNumber;
    }

    public TestReportListener<TestOutputReportEntry> createTestReportListener() {
        TestSetRunListener testSetRunListener = new TestSetRunListener(this.createConsoleReporter(), this.createFileReporter(), this.createSimpleXMLReporter(), this.createConsoleOutputReceiver(), this.createStatisticsReporter(), this.reportConfiguration.isTrimStackTrace(), "plain".equals(this.reportConfiguration.getReportFormat()), this.reportConfiguration.isBriefOrPlainFormat(), this.consoleLogger, this.reportConfiguration.getReporterFactoryOptions().isStatPerSourceName());
        this.addListener(testSetRunListener);
        return testSetRunListener;
    }

    @Override
    public File getReportsDirectory() {
        return this.reportConfiguration.getReportsDirectory();
    }

    private StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> createConsoleReporter() {
        StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> consoleReporter = this.reportConfiguration.instantiateConsoleReporter(this.consoleLogger);
        return (StatelessTestsetInfoConsoleReportEventListener)ObjectUtils.useNonNull(consoleReporter, (Object)((Object)NullConsoleReporter.INSTANCE));
    }

    private StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> createFileReporter() {
        StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> fileReporter = this.reportConfiguration.instantiateFileReporter(this.forkNumber);
        return (StatelessTestsetInfoFileReportEventListener)ObjectUtils.useNonNull(fileReporter, (Object)((Object)NullFileReporter.INSTANCE));
    }

    private StatelessReportEventListener<WrappedReportEntry, TestSetStats> createSimpleXMLReporter() {
        StatelessReportEventListener<WrappedReportEntry, TestSetStats> xmlReporter = this.reportConfiguration.instantiateStatelessXmlReporter(this.forkNumber);
        return (StatelessReportEventListener)ObjectUtils.useNonNull(xmlReporter, (Object)NullStatelessXmlReporter.INSTANCE);
    }

    private ConsoleOutputReportEventListener createConsoleOutputReceiver() {
        ConsoleOutputReportEventListener outputReporter = this.reportConfiguration.instantiateConsoleOutputFileReporter(this.forkNumber);
        return (ConsoleOutputReportEventListener)ObjectUtils.useNonNull((Object)outputReporter, (Object)NullConsoleOutputReceiver.INSTANCE);
    }

    private StatisticsReporter createStatisticsReporter() {
        StatisticsReporter statisticsReporter = this.reportConfiguration.getStatisticsReporter();
        return (StatisticsReporter)ObjectUtils.useNonNull((Object)statisticsReporter, (Object)NullStatisticsReporter.INSTANCE);
    }

    @Override
    public void mergeFromOtherFactories(Collection<DefaultReporterFactory> factories) {
        for (DefaultReporterFactory factory : factories) {
            this.listeners.addAll(factory.listeners);
        }
    }

    final void addListener(TestSetRunListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public RunResult close() {
        this.mergeTestHistoryResult();
        this.runCompleted();
        for (TestSetRunListener listener : this.listeners) {
            listener.close();
        }
        return this.globalStats.getRunResult();
    }

    @Override
    public void runStarting() {
        if (this.reportConfiguration.isPrintSummary()) {
            this.log("");
            this.log("-------------------------------------------------------");
            this.log(" T E S T S");
            this.log("-------------------------------------------------------");
        }
    }

    private void runCompleted() {
        if (this.reportConfiguration.isPrintSummary()) {
            this.log("");
            this.log("Results:");
            this.log("");
        }
        boolean printedFailures = this.printTestFailures(TestResultType.FAILURE);
        boolean printedErrors = this.printTestFailures(TestResultType.ERROR);
        boolean printedFlakes = this.printTestFailures(TestResultType.FLAKE);
        if (this.reportConfiguration.isPrintSummary()) {
            if (printedFailures | printedErrors | printedFlakes) {
                this.log("");
            }
            boolean hasSuccessful = this.globalStats.getCompletedCount() > 0;
            boolean hasSkipped = this.globalStats.getSkipped() > 0;
            this.log(this.globalStats.getSummary(), hasSuccessful, printedFailures, printedErrors, hasSkipped, printedFlakes);
            this.log("");
        }
    }

    public RunStatistics getGlobalRunStatistics() {
        this.mergeTestHistoryResult();
        return this.globalStats;
    }

    static TestResultType getTestResultType(List<ReportEntryType> reportEntries, int rerunFailingTestsCount) {
        if (reportEntries == null || reportEntries.isEmpty()) {
            return TestResultType.UNKNOWN;
        }
        boolean seenSuccess = false;
        boolean seenFailure = false;
        boolean seenError = false;
        for (ReportEntryType resultType : reportEntries) {
            if (resultType == ReportEntryType.SUCCESS) {
                seenSuccess = true;
                continue;
            }
            if (resultType == ReportEntryType.FAILURE) {
                seenFailure = true;
                continue;
            }
            if (resultType != ReportEntryType.ERROR) continue;
            seenError = true;
        }
        if (seenFailure || seenError) {
            if (seenSuccess && rerunFailingTestsCount > 0) {
                return TestResultType.FLAKE;
            }
            return seenError ? TestResultType.ERROR : TestResultType.FAILURE;
        }
        if (seenSuccess) {
            return TestResultType.SUCCESS;
        }
        return TestResultType.SKIPPED;
    }

    private void mergeTestHistoryResult() {
        String testClassMethodName;
        List testMethodStats;
        this.globalStats = new RunStatistics();
        this.successTests = new TreeMap<String, List<TestMethodStats>>();
        this.flakyTests = new TreeMap<String, List<TestMethodStats>>();
        this.failedTests = new TreeMap<String, List<TestMethodStats>>();
        this.errorTests = new TreeMap<String, List<TestMethodStats>>();
        HashMap mergedTestHistoryResult = new HashMap();
        for (TestSetRunListener listener : this.listeners) {
            for (TestMethodStats methodStats2 : listener.getTestMethodStats()) {
                List list = (List)mergedTestHistoryResult.get(methodStats2.getTestClassMethodName());
                if (list == null) {
                    ArrayList<TestMethodStats> arrayList = new ArrayList<TestMethodStats>();
                    arrayList.add(methodStats2);
                    mergedTestHistoryResult.put(methodStats2.getTestClassMethodName(), arrayList);
                    continue;
                }
                list.add(methodStats2);
            }
        }
        int completedCount = 0;
        int skipped = 0;
        HashMap<Object, List> beforeAllFailures = new HashMap<Object, List>();
        block9: for (Map.Entry entry : mergedTestHistoryResult.entrySet()) {
            boolean isActualFailure;
            testMethodStats = (List)entry.getValue();
            testClassMethodName = (String)entry.getKey();
            if ((StringUtils.isBlank((String)testClassMethodName) || testClassMethodName.endsWith(".null")) && (testClassMethodName == null || !testClassMethodName.contains("$")) && (isActualFailure = testMethodStats.stream().anyMatch(stat -> stat.getResultType() == ReportEntryType.ERROR || stat.getResultType() == ReportEntryType.FAILURE))) {
                String className = DefaultReporterFactory.extractClassNameFromMethodName(testClassMethodName);
                if (className == null) continue;
                if (beforeAllFailures.containsKey(className)) {
                    List previousMethodStats = (List)beforeAllFailures.get(className);
                    previousMethodStats.addAll(testMethodStats);
                    beforeAllFailures.put(className, previousMethodStats);
                    continue;
                }
                beforeAllFailures.put(className, new ArrayList(testMethodStats));
                continue;
            }
            ++completedCount;
            ArrayList<ReportEntryType> resultTypes = new ArrayList<ReportEntryType>();
            for (TestMethodStats methodStats3 : testMethodStats) {
                resultTypes.add(methodStats3.getResultType());
            }
            switch (DefaultReporterFactory.getTestResultType(resultTypes, this.reportConfiguration.getRerunFailingTestsCount()).ordinal()) {
                case 3: {
                    int successCount = 0;
                    for (ReportEntryType type : resultTypes) {
                        if (type != ReportEntryType.SUCCESS) continue;
                        ++successCount;
                    }
                    completedCount += successCount - 1;
                    this.successTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case 4: {
                    ++skipped;
                    continue block9;
                }
                case 2: {
                    this.flakyTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case 1: {
                    this.failedTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
                case 0: {
                    this.errorTests.put(testClassMethodName, testMethodStats);
                    continue block9;
                }
            }
            throw new IllegalStateException("Get unknown test result type");
        }
        for (Map.Entry<Object, Object> entry : this.successTests.entrySet()) {
            testMethodStats = (List)entry.getValue();
            testClassMethodName = (String)entry.getKey();
            String className = DefaultReporterFactory.extractClassNameFromMethodName(testClassMethodName);
            if (!beforeAllFailures.containsKey(className)) continue;
            List previousMethodStats = (List)beforeAllFailures.get(className);
            previousMethodStats.addAll(testMethodStats);
            beforeAllFailures.put(className, previousMethodStats);
        }
        for (Map.Entry<Object, Object> entry : beforeAllFailures.entrySet()) {
            String className = (String)entry.getKey();
            List testMethodStats2 = (List)entry.getValue();
            String classNameKey = className + ".<beforeAll>";
            if (this.reportConfiguration.getRerunFailingTestsCount() > 0 && testMethodStats2.stream().anyMatch(methodStats -> methodStats.getTestClassMethodName() != null && !methodStats.getTestClassMethodName().isEmpty() && methodStats.getResultType().equals((Object)ReportEntryType.SUCCESS))) {
                this.flakyTests.put(classNameKey, testMethodStats2);
                continue;
            }
            this.errorTests.put(classNameKey, testMethodStats2);
            ++completedCount;
        }
        this.globalStats.set(completedCount, this.errorTests.size(), this.failedTests.size(), skipped, this.flakyTests.size());
    }

    boolean printTestFailures(TestResultType type) {
        Level level;
        Map<String, List<TestMethodStats>> testStats;
        switch (type.ordinal()) {
            case 1: {
                testStats = this.failedTests;
                level = Level.FAILURE;
                break;
            }
            case 0: {
                testStats = this.errorTests;
                level = Level.FAILURE;
                break;
            }
            case 2: {
                testStats = this.flakyTests;
                level = Level.UNSTABLE;
                break;
            }
            default: {
                return false;
            }
        }
        boolean printed = false;
        if (!testStats.isEmpty()) {
            this.log(type.getLogPrefix(), level);
            printed = true;
        }
        for (Map.Entry<String, List<TestMethodStats>> entry : testStats.entrySet()) {
            List<TestMethodStats> testMethodStats = entry.getValue();
            if (testMethodStats.size() == 1) {
                this.failure("  " + testMethodStats.get(0).getStackTraceWriter().smartTrimmedStackTrace());
                continue;
            }
            this.log(entry.getKey(), level);
            for (int i = 0; i < testMethodStats.size(); ++i) {
                StackTraceWriter failureStackTrace = testMethodStats.get(i).getStackTraceWriter();
                if (failureStackTrace == null) {
                    this.success("  Run " + (i + 1) + ": PASS");
                    continue;
                }
                this.failure("  Run " + (i + 1) + ": " + failureStackTrace.smartTrimmedStackTrace());
            }
            this.log("");
        }
        return printed;
    }

    private static String extractClassNameFromMethodName(String testClassMethodName) {
        if (StringUtils.isBlank((String)testClassMethodName)) {
            return null;
        }
        int lastDotIndex = testClassMethodName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            return testClassMethodName.substring(0, lastDotIndex);
        }
        return null;
    }

    private static String extractClassNameFromStackTrace(TestMethodStats stats) {
        if (stats.getStackTraceWriter() == null) {
            return null;
        }
        String stackTrace = stats.getStackTraceWriter().smartTrimmedStackTrace();
        if (stackTrace == null || stackTrace.isEmpty()) {
            return null;
        }
        int firstWhitespace = stackTrace.indexOf(32);
        if (firstWhitespace > 0) {
            stackTrace = stackTrace.substring(0, firstWhitespace);
        }
        return DefaultReporterFactory.extractClassNameFromMethodName(stackTrace);
    }

    private void log(String s, boolean success, boolean failures, boolean errors, boolean skipped, boolean flakes) {
        Level level = Level.resolveLevel((boolean)success, (boolean)failures, (boolean)errors, (boolean)skipped, (boolean)flakes);
        this.log(s, level);
    }

    private void log(String s, Level level) {
        switch (level) {
            case FAILURE: {
                this.failure(s);
                break;
            }
            case UNSTABLE: {
                this.warning(s);
                break;
            }
            case SUCCESS: {
                this.success(s);
                break;
            }
            default: {
                this.info(s);
            }
        }
    }

    private void log(String s) {
        this.consoleLogger.info(s);
    }

    private void info(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.info(builder.a((CharSequence)s).toString());
    }

    private void warning(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.warning(builder.warning((Object)s).toString());
    }

    private void success(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.info(builder.success((Object)s).toString());
    }

    private void failure(String s) {
        MessageBuilder builder = MessageUtils.buffer();
        this.consoleLogger.error(builder.failure((Object)s).toString());
    }

    static enum TestResultType {
        ERROR("Errors: "),
        FAILURE("Failures: "),
        FLAKE("Flakes: "),
        SUCCESS("Success: "),
        SKIPPED("Skipped: "),
        UNKNOWN("Unknown: ");

        private final String logPrefix;

        private TestResultType(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        public String getLogPrefix() {
            return this.logPrefix;
        }
    }
}

