/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ClassAnalyzer;
import org.apache.maven.shared.dependency.analyzer.DependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ProjectDependencyAnalyzer.class)
public class DefaultProjectDependencyAnalyzer
implements ProjectDependencyAnalyzer {
    @Requirement
    private ClassAnalyzer classAnalyzer;
    @Requirement
    private DependencyAnalyzer dependencyAnalyzer;

    @Override
    public ProjectDependencyAnalysis analyze(MavenProject project) throws ProjectDependencyAnalyzerException {
        try {
            Map<Artifact, Set<String>> artifactClassMap = this.buildArtifactClassMap(project);
            Set<String> dependencyClasses = this.buildDependencyClasses(project);
            Set<Artifact> declaredArtifacts = this.buildDeclaredArtifacts(project);
            Set<Artifact> usedArtifacts = this.buildUsedArtifacts(artifactClassMap, dependencyClasses);
            LinkedHashSet<Artifact> usedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            usedDeclaredArtifacts.retainAll(usedArtifacts);
            Set<Artifact> usedUndeclaredArtifacts = new LinkedHashSet<Artifact>(usedArtifacts);
            usedUndeclaredArtifacts = this.removeAll(usedUndeclaredArtifacts, declaredArtifacts);
            Set<Artifact> unusedDeclaredArtifacts = new LinkedHashSet<Artifact>(declaredArtifacts);
            unusedDeclaredArtifacts = this.removeAll(unusedDeclaredArtifacts, usedArtifacts);
            return new ProjectDependencyAnalysis(usedDeclaredArtifacts, usedUndeclaredArtifacts, unusedDeclaredArtifacts);
        }
        catch (IOException exception) {
            throw new ProjectDependencyAnalyzerException("Cannot analyze dependencies", exception);
        }
    }

    private Set<Artifact> removeAll(Set<Artifact> start, Set<Artifact> remove) {
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>(start.size());
        for (Artifact artifact : start) {
            boolean found = false;
            for (Artifact artifact2 : remove) {
                if (!artifact.getDependencyConflictId().equals(artifact2.getDependencyConflictId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            results.add(artifact);
        }
        return results;
    }

    private Map<Artifact, Set<String>> buildArtifactClassMap(MavenProject project) throws IOException {
        LinkedHashMap<Artifact, Set<String>> artifactClassMap = new LinkedHashMap<Artifact, Set<String>>();
        Set dependencyArtifacts = project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            File file = artifact.getFile();
            if (file == null || !file.getName().endsWith(".jar")) continue;
            URL url = file.toURL();
            Set<String> classes = this.classAnalyzer.analyze(url);
            artifactClassMap.put(artifact, classes);
        }
        return artifactClassMap;
    }

    protected Set<String> buildDependencyClasses(MavenProject project) throws IOException {
        HashSet<String> dependencyClasses = new HashSet<String>();
        String outputDirectory = project.getBuild().getOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(outputDirectory));
        String testOutputDirectory = project.getBuild().getTestOutputDirectory();
        dependencyClasses.addAll(this.buildDependencyClasses(testOutputDirectory));
        return dependencyClasses;
    }

    private Set<String> buildDependencyClasses(String path) throws IOException {
        URL url = new File(path).toURI().toURL();
        return this.dependencyAnalyzer.analyze(url);
    }

    private Set<Artifact> buildDeclaredArtifacts(MavenProject project) {
        Set<Artifact> declaredArtifacts = project.getDependencyArtifacts();
        if (declaredArtifacts == null) {
            declaredArtifacts = Collections.emptySet();
        }
        return declaredArtifacts;
    }

    private Set<Artifact> buildUsedArtifacts(Map<Artifact, Set<String>> artifactClassMap, Set<String> dependencyClasses) {
        HashSet<Artifact> usedArtifacts = new HashSet<Artifact>();
        for (String className : dependencyClasses) {
            Artifact artifact = this.findArtifactForClassName(artifactClassMap, className);
            if (artifact == null) continue;
            usedArtifacts.add(artifact);
        }
        return usedArtifacts;
    }

    protected Artifact findArtifactForClassName(Map<Artifact, Set<String>> artifactClassMap, String className) {
        for (Map.Entry<Artifact, Set<String>> entry : artifactClassMap.entrySet()) {
            if (!entry.getValue().contains(className)) continue;
            return entry.getKey();
        }
        return null;
    }
}

