/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jxr;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.jxr.JXR;
import org.apache.maven.jxr.JavaCodeTransform;
import org.apache.maven.jxr.JxrException;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.jxr.JxrReportUtil;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJxrReport
extends AbstractMavenReport {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.name} ${project.version} Reference")
    private String windowTitle;
    @Parameter(defaultValue="${project.name} ${project.version} Reference")
    private String docTitle;
    @Parameter(property="bottom", defaultValue="\u00a9 {inceptionYear}\u2013{currentYear} {organizationName}")
    private String bottom;
    @Parameter
    private String templateDir;
    @Parameter
    private String stylesheet;
    @Parameter
    private ArrayList<String> excludes;
    @Parameter
    private ArrayList<String> includes;
    @Parameter(property="maven.jxr.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="true")
    private boolean linkJavadoc;
    @Parameter(property="javadocVersion")
    private String javadocVersion;
    private JavaVersion javadocTemplatesVersion;

    protected List<String> pruneSourceDirs(List<String> sourceDirs) {
        ArrayList<String> pruned = new ArrayList<String>(sourceDirs.size());
        for (String dir : sourceDirs) {
            if (pruned.contains(dir) || !this.hasSources(new File(dir))) continue;
            pruned.add(dir);
        }
        return pruned;
    }

    protected void init() {
        block1: {
            ReportPlugin reportPlugin;
            if (this.project.getModel().getReporting() == null) break block1;
            Iterator iterator = Collections.unmodifiableList(this.project.getModel().getReporting().getPlugins()).iterator();
            while (iterator.hasNext() && !"maven-javadoc-plugin".equals((reportPlugin = (ReportPlugin)iterator.next()).getArtifactId())) {
            }
        }
    }

    private boolean hasSources(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            for (File currentFile : dir.listFiles()) {
                if (!(currentFile.isFile() ? currentFile.getName().endsWith(".java") : Character.isJavaIdentifierStart(currentFile.getName().charAt(0)) && this.hasSources(currentFile))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXref(Locale locale, File outputDirectory, List<String> sourceDirs) throws IOException, JxrException {
        FileManager fileManager = new FileManager();
        PackageManager packageManager = new PackageManager(fileManager);
        JavaCodeTransform codeTransform = new JavaCodeTransform(packageManager, fileManager);
        JXR jxr = new JXR(packageManager, codeTransform);
        jxr.setDest(outputDirectory.toPath());
        jxr.setInputEncoding(this.getInputEncoding());
        jxr.setLocale(locale);
        jxr.setOutputEncoding(this.getOutputEncoding());
        jxr.setRevision("HEAD");
        jxr.setJavadocLinkDir(this.constructJavadocLocation());
        if (this.excludes != null && !this.excludes.isEmpty()) {
            jxr.setExcludes(this.excludes.toArray(new String[0]));
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            jxr.setIncludes(this.includes.toArray(new String[0]));
        }
        ClassLoader savedTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            jxr.xref(sourceDirs, this.getTemplateDir(), this.windowTitle, this.docTitle, this.getBottomText());
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedTccl);
        }
        this.copyRequiredResources(outputDirectory);
    }

    private String getBottomText() {
        int currentYear = Calendar.getInstance().get(1);
        String year = String.valueOf(currentYear);
        String inceptionYear = this.project.getInceptionYear();
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}\u2013", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}\u2013", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }

    private void copyRequiredResources(File targetDirectory) {
        block13: {
            if (this.stylesheet != null && !this.stylesheet.isEmpty()) {
                File stylesheetFile = new File(this.stylesheet);
                File targetStylesheetFile = new File(targetDirectory, "stylesheet.css");
                try {
                    if (stylesheetFile.isAbsolute()) {
                        FileUtils.copyFile((File)stylesheetFile, (File)targetStylesheetFile);
                        break block13;
                    }
                    URL stylesheetUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.stylesheet);
                    FileUtils.copyURLToFile((URL)stylesheetUrl, (File)targetStylesheetFile);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"An error occured while copying the stylesheet to the target directory", (Throwable)e);
                }
            } else if (this.javadocTemplatesVersion.isAtLeast("1.8")) {
                this.copyResources(targetDirectory, "jdk8/", "stylesheet.css");
            } else if (this.javadocTemplatesVersion.isAtLeast("1.7")) {
                String[] jdk7Resources = new String[]{"stylesheet.css", "resources/background.gif", "resources/tab.gif", "resources/titlebar.gif", "resources/titlebar_end.gif"};
                this.copyResources(targetDirectory, "jdk7/", jdk7Resources);
            } else if (this.javadocTemplatesVersion.isAtLeast("1.6")) {
                this.copyResources(targetDirectory, "jdk6/", "stylesheet.css");
            } else if (this.javadocTemplatesVersion.isAtLeast("1.4")) {
                this.copyResources(targetDirectory, "jdk4/", "stylesheet.css");
            } else {
                this.copyResources(targetDirectory, "", "stylesheet.css");
            }
        }
    }

    private void copyResources(File targetDirectory, String sourceDirectory, String ... files) {
        try {
            for (String file : files) {
                URL resourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource(sourceDirectory + file);
                File targetResourceFile = new File(targetDirectory, file);
                FileUtils.copyURLToFile((URL)resourceUrl, (File)targetResourceFile);
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"An error occured while copying the resource to the target directory", (Throwable)e);
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jxr-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.init();
        this.setJavadocTemplatesVersion();
        try {
            this.createXref(locale, this.getPluginReportOutputDirectory(), this.constructSourceDirs());
        }
        catch (IOException | JxrException e) {
            throw new MavenReportException("Error while generating the HTML source code of the project.", (Exception)e);
        }
    }

    private String getTemplateDir() {
        if (this.templateDir == null || this.templateDir.isEmpty()) {
            if (this.javadocTemplatesVersion.isAtLeast("1.8")) {
                return "templates/jdk8";
            }
            if (this.javadocTemplatesVersion.isAtLeast("1.7")) {
                return "templates/jdk7";
            }
            if (this.javadocTemplatesVersion.isAtLeast("1.4")) {
                return "templates/jdk4";
            }
            this.getLog().warn((CharSequence)("Unsupported javadocVersion: " + this.javadocTemplatesVersion + ". Fallback to original"));
            return "templates";
        }
        return this.templateDir;
    }

    private void setJavadocTemplatesVersion() {
        JavaVersion javaVersion = JavaVersion.JAVA_SPECIFICATION_VERSION;
        this.javadocTemplatesVersion = this.javadocVersion != null && !this.javadocVersion.isEmpty() ? JavaVersion.parse((String)this.javadocVersion) : javaVersion;
    }

    protected List<String> constructSourceDirs() {
        List<String> sourceDirs = new ArrayList<String>(this.getSourceRoots());
        if (this.isAggregate()) {
            for (MavenProject project : this.reactorProjects) {
                if (!"java".equals(project.getArtifact().getArtifactHandler().getLanguage())) continue;
                sourceDirs.addAll(this.getSourceRoots(project));
            }
        }
        sourceDirs = this.pruneSourceDirs(sourceDirs);
        return sourceDirs;
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        if (this.constructSourceDirs().isEmpty()) {
            return false;
        }
        return !this.isAggregate() || this.project.isExecutionRoot();
    }

    public boolean isExternalReport() {
        return true;
    }

    private Path constructJavadocLocation() throws IOException {
        Path location = null;
        if (this.linkJavadoc) {
            if (this.getJavadocLocation().exists()) {
                location = this.getJavadocLocation().toPath().toAbsolutePath();
            } else {
                String stagingDirectory = System.getProperty("stagingDirectory");
                if (stagingDirectory != null && !stagingDirectory.isEmpty()) {
                    String javadocOutputDir = this.getJavadocLocation().getName();
                    boolean javadocAggregate = JxrReportUtil.isJavadocAggregated(this.project);
                    String structureProject = JxrReportUtil.getStructure(this.project, false);
                    if (this.isAggregate() && javadocAggregate) {
                        location = Paths.get(stagingDirectory, structureProject, javadocOutputDir);
                    }
                    if (!this.isAggregate() && javadocAggregate) {
                        location = Paths.get(stagingDirectory, javadocOutputDir);
                        String hierarchy = this.project.getName();
                        for (MavenProject parent = this.project.getParent(); parent != null; parent = parent.getParent()) {
                            hierarchy = parent.getName();
                        }
                        location = Paths.get(stagingDirectory, hierarchy, javadocOutputDir);
                    }
                    if (this.isAggregate() && !javadocAggregate) {
                        this.getLog().warn((CharSequence)"The JXR plugin is configured to build an aggregated report at the root, not the Javadoc plugin.");
                    }
                    if (!this.isAggregate() && !javadocAggregate) {
                        location = Paths.get(stagingDirectory, structureProject, javadocOutputDir);
                    }
                } else {
                    location = this.getJavadocLocation().toPath();
                }
            }
            if (location == null) {
                this.getLog().warn((CharSequence)"Unable to locate Javadoc to link to - DISABLED");
            }
        }
        return location;
    }

    protected abstract File getPluginReportOutputDirectory();

    protected abstract List<String> getSourceRoots();

    protected abstract List<String> getSourceRoots(MavenProject var1);

    protected abstract File getJavadocLocation();

    protected boolean isAggregate() {
        return false;
    }
}

