/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jdeps;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.jdeps.AbstractJDepsMojo;

@Mojo(name="test-jdkinternals", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public class TestJDKInternalsMojo
extends AbstractJDepsMojo {
    @Parameter(defaultValue="true", property="jdeps.test.failOnWarning")
    private boolean failOnWarning;

    @Override
    protected boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    @Override
    protected String getClassesDirectory() {
        return this.getProject().getBuild().getTestOutputDirectory();
    }

    @Override
    protected Collection<Path> getClassPath() throws DependencyResolutionRequiredException {
        LinkedHashSet<Path> classPath = new LinkedHashSet<Path>(this.getProject().getTestClasspathElements().size());
        for (String elm : this.getProject().getTestClasspathElements()) {
            classPath.add(Paths.get(elm, new String[0]));
        }
        return classPath;
    }
}

