/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.siterenderer.DocumentRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.javadoc.AbstractJavadocMojo;
import org.apache.maven.plugins.javadoc.JavadocModule;
import org.apache.maven.plugins.javadoc.resolver.ResourceResolver;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="javadoc", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class JavadocReport
extends AbstractJavadocMojo
implements MavenMultiPageReport {
    private File reportOutputDirectory;
    @Parameter(property="name")
    private String name;
    @Parameter(property="description")
    private String description;

    @Inject
    public JavadocReport(SiteTool siteTool, ArchiverManager archiverManager, ResourceResolver resourceResolver, RepositorySystem repoSystem, ArtifactHandlerManager artifactHandlerManager, ProjectBuilder mavenProjectBuilder, ToolchainManager toolchainManager) {
        super(siteTool, archiverManager, resourceResolver, repoSystem, artifactHandlerManager, mavenProjectBuilder, toolchainManager);
    }

    public String getName(Locale locale) {
        if (this.name == null || this.name.isEmpty()) {
            return this.getBundle(locale).getString("report.javadoc.name");
        }
        return this.name;
    }

    public String getDescription(Locale locale) {
        if (this.description == null || this.description.isEmpty()) {
            return this.getBundle(locale).getString("report.javadoc.description");
        }
        return this.description;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.generate(sink, null, locale);
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        try {
            this.executeReport(locale);
        }
        catch (RuntimeException | MavenReportException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)("Error while creating javadoc report: " + e.getMessage()), e);
        }
    }

    public String getOutputName() {
        return (this.isTest() ? "test" : "") + "apidocs/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() throws MavenReportException {
        if (this.skip) {
            return false;
        }
        Collection<JavadocModule> sourcePaths = this.getSourcePaths();
        Collection collectedSourcePaths = sourcePaths.stream().flatMap(e -> e.getSourcePaths().stream()).collect(Collectors.toList());
        Map<Path, Collection<String>> files = this.getFiles(collectedSourcePaths);
        return this.canGenerateReport(files);
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
        this.outputDirectory = reportOutputDirectory;
    }

    @Override
    protected String getPluginReportOutputDirectory() {
        return this.getReportOutputDirectory().getAbsolutePath() + "/" + (this.isTest() ? "test" : "") + "apidocs";
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.canGenerateReport()) {
                String reportMojoInfo = this.mojoExecution.getPlugin().getId() + ":" + this.mojoExecution.getGoal();
                this.getLog().info((CharSequence)("Skipping " + reportMojoInfo + " report goal"));
                return;
            }
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Failed to determine whether report can be generated", (Exception)((Object)e));
        }
        File outputDirectory = new File(this.getOutputDirectory());
        String filename = this.getOutputName() + ".html";
        Locale locale = SiteTool.DEFAULT_LOCALE;
        try {
            String reportMojoInfo = this.mojoExecution.getPlugin().getId() + ":" + this.mojoExecution.getGoal();
            DocumentRenderingContext docRenderingContext = new DocumentRenderingContext(outputDirectory, filename, reportMojoInfo);
            SiteRendererSink sink = new SiteRendererSink(docRenderingContext);
            this.generate((Sink)sink, null, locale);
        }
        catch (RuntimeException | MavenReportException e) {
            this.failOnError("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", (Exception)e);
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("javadoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

