/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jarsigner;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.jarsigner.AbstractJarsignerMojo;
import org.apache.maven.shared.jarsigner.JarSignerRequest;
import org.apache.maven.shared.jarsigner.JarSignerSignRequest;
import org.apache.maven.shared.jarsigner.JarSignerUtil;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.Commandline;

@Mojo(name="sign", defaultPhase=LifecyclePhase.PACKAGE)
public class JarsignerSignMojo
extends AbstractJarsignerMojo {
    @Parameter(property="jarsigner.keypass")
    private String keypass;
    @Parameter(property="jarsigner.sigfile")
    private String sigfile;
    @Parameter(property="jarsigner.removeExistingSignatures", defaultValue="false")
    private boolean removeExistingSignatures;
    @Parameter(property="jarsigner.tsa")
    private String tsa;
    @Parameter(property="jarsigner.tsacert")
    private String tsacert;

    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo;
        String string = commandLineInfo = commandLine != null ? commandLine.toString() : null;
        if (commandLineInfo != null) {
            commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
        }
        return commandLineInfo;
    }

    protected void preProcessArchive(File archive) throws MojoExecutionException {
        if (this.removeExistingSignatures) {
            try {
                JarSignerUtil.unsignArchive((File)archive);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to unsign archive " + archive + ": " + e.getMessage(), (Exception)e);
            }
        }
    }

    protected JarSignerRequest createRequest(File archive) throws MojoExecutionException {
        JarSignerSignRequest request = new JarSignerSignRequest();
        request.setSigfile(this.sigfile);
        request.setTsaLocation(this.tsa);
        request.setTsaAlias(this.tsacert);
        request.setKeypass(this.decrypt(this.keypass));
        return request;
    }
}

