/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.jar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.toolchain.Toolchain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
class ToolchainsJdkSpecification {
    private final Logger logger = LoggerFactory.getLogger(ToolchainsJdkSpecification.class);
    private final Map<Path, String> cache = new HashMap<Path, String>();

    ToolchainsJdkSpecification() {
    }

    public synchronized Optional<String> getJDKSpecification(Toolchain toolchain) {
        Optional<Path> javacPath = this.getJavacPath(toolchain);
        return javacPath.map(path -> this.cache.computeIfAbsent((Path)path, this::getSpecForPath));
    }

    private Optional<Path> getJavacPath(Toolchain toolchain) {
        return Optional.ofNullable(toolchain.findTool("javac")).map(x$0 -> Paths.get(x$0, new String[0])).map(this::getCanonicalPath);
    }

    private Path getCanonicalPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            if (path.getParent() != null) {
                return this.getCanonicalPath(path.getParent()).resolve(path.getFileName());
            }
            throw new UncheckedIOException(e);
        }
    }

    private String getSpecForPath(Path path) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(path.toString(), "-version");
            processBuilder.redirectErrorStream(false);
            Process process = processBuilder.start();
            List<String> stdout = this.readOutput(process.getInputStream());
            List<String> stderr = this.readOutput(process.getErrorStream());
            process.waitFor();
            String version = this.tryParseVersion(stdout);
            if (version == null) {
                version = this.tryParseVersion(stderr);
            }
            if (version == null) {
                this.logger.warn("Unrecognized output from {}: stdout: {}, stderr: {}", new Object[]{processBuilder.command(), stdout, stderr});
            }
            return version;
        }
        catch (IOException | IndexOutOfBoundsException e) {
            this.logger.warn("Failed to execute: {} - {}", (Object)path, (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private String tryParseVersion(List<String> versions) {
        for (String version : versions) {
            if (!version.startsWith("javac ")) continue;
            version = (version = version.substring(6)).startsWith("1.") ? version.substring(0, 3) : version.substring(0, 2);
            return version;
        }
        return null;
    }

    private List<String> readOutput(InputStream inputstream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            result.add(line);
        }
        return result;
    }
}

