/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.invoker;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.invoker.InvokerReportRenderer;
import org.apache.maven.plugins.invoker.ReportUtils;
import org.apache.maven.plugins.invoker.model.BuildJob;
import org.apache.maven.plugins.invoker.model.io.xpp3.BuildJobXpp3Reader;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="report", threadSafe=true)
public class InvokerReport
extends AbstractMavenReport {
    @Parameter(defaultValue="${project.build.directory}/invoker-reports", property="invoker.reportsDirectory")
    private File reportsDirectory;
    @Component
    protected I18N i18n;

    protected void executeReport(Locale locale) throws MavenReportException {
        File[] reportFiles = this.getReportFiles();
        BuildJobXpp3Reader buildJobReader = new BuildJobXpp3Reader();
        ArrayList<BuildJob> buildJobs = new ArrayList<BuildJob>(reportFiles.length);
        for (File reportFile : reportFiles) {
            try (XmlStreamReader xmlReader = ReaderFactory.newXmlReader((File)reportFile);){
                buildJobs.add(buildJobReader.read((Reader)xmlReader));
            }
            catch (XmlPullParserException e) {
                throw new MavenReportException("Failed to parse report file: " + reportFile, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MavenReportException("Failed to read report file: " + reportFile, (Exception)e);
            }
        }
        InvokerReportRenderer r = new InvokerReportRenderer(this.getSink(), this.i18n, locale, this.getLog(), buildJobs);
        r.render();
    }

    private String getI18nString(Locale locale, String key) {
        return this.i18n.getString("invoker-report", locale, "report.invoker." + key);
    }

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    public String getOutputName() {
        return "invoker-report";
    }

    private File[] getReportFiles() {
        return ReportUtils.getReportFiles(this.reportsDirectory);
    }

    public boolean canGenerateReport() {
        return this.getReportFiles().length > 0;
    }
}

