/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.XmlWriterUtil;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractEffectiveMojo
extends AbstractHelpMojo {
    protected static void writeXmlFile(File output, String content) throws IOException {
        if (output == null) {
            return;
        }
        output.getParentFile().mkdirs();
        try (XmlStreamWriter out = WriterFactory.newXmlWriter((File)output);){
            out.write(content);
        }
    }

    protected static void writeHeader(XMLWriter writer) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"Generated by Maven Help Plugin");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)"See: https://maven.apache.org/plugins/maven-help-plugin/");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
    }

    protected static void writeComment(XMLWriter writer, String comment) {
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)comment);
        XmlWriterUtil.writeComment((XMLWriter)writer, (String)" ");
        XmlWriterUtil.writeCommentLineBreak((XMLWriter)writer);
    }

    protected static String prettyFormat(String effectiveModel, String encoding, boolean omitDeclaration) {
        SAXBuilder builder = new SAXBuilder();
        builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        try {
            Document effectiveDocument = builder.build((Reader)new StringReader(effectiveModel));
            StringWriter w = new StringWriter();
            Format format = Format.getPrettyFormat();
            if (encoding != null) {
                format.setEncoding(encoding);
            }
            format.setLineSeparator(System.lineSeparator());
            format.setOmitDeclaration(omitDeclaration);
            XMLOutputter out = new XMLOutputter(format);
            out.output(effectiveDocument, (Writer)w);
            return w.toString();
        }
        catch (IOException | JDOMException e) {
            return effectiveModel;
        }
    }

    protected static class SortedProperties
    extends Properties {
        static final long serialVersionUID = -8985316072702233744L;

        protected SortedProperties() {
        }

        @Override
        public Set<Object> keySet() {
            Set<Object> keynames = super.keySet();
            ArrayList<Object> list = new ArrayList<Object>(keynames);
            Collections.sort(list);
            return new LinkedHashSet<Object>(list);
        }
    }
}

