/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.deploy.AbstractDeployMojo;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.artifact.SubArtifact;

@Mojo(name="deploy-file", requiresProject=false, threadSafe=true)
public class DeployFileMojo
extends AbstractDeployMojo {
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="generatePom.description")
    private String description;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="repositoryId", defaultValue="remote-repository", required=true)
    private String repositoryId;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom", defaultValue="true")
    private boolean generatePom;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="types")
    private String types;
    @Parameter(property="classifiers")
    private String classifiers;
    @Parameter(property="files")
    private String files;
    private static final String ILLEGAL_VERSION_CHARS = "\\/:\"<>|?*[](){},";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void initProperties() throws MojoExecutionException {
        if (this.pomFile == null) {
            foundPom = false;
            jarFile = null;
            try {
                pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
                jarFile = new JarFile(this.file);
                jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    entry = jarEntries.nextElement();
                    if (!pomEntry.matcher(entry.getName()).matches()) continue;
                    this.getLog().debug((CharSequence)("Using " + entry.getName() + " as pomFile"));
                    foundPom = true;
                    pomInputStream = null;
                    pomOutputStream = null;
                    try {
                        pomInputStream = jarFile.getInputStream(entry);
                        base = this.file.getName();
                        if (base.indexOf(46) > 0) {
                            base = base.substring(0, base.lastIndexOf(46));
                        }
                        this.pomFile = new File(this.file.getParentFile(), base + ".pom");
                        pomOutputStream = new FileOutputStream(this.pomFile);
                        IOUtil.copy((InputStream)pomInputStream, (OutputStream)pomOutputStream);
                        pomOutputStream.close();
                        pomOutputStream = null;
                        pomInputStream.close();
                        pomInputStream = null;
                        this.processModel(this.readModel(this.pomFile));
                    }
                    catch (Throwable var9_12) {
                        IOUtil.close((InputStream)pomInputStream);
                        IOUtil.close(pomOutputStream);
                        throw var9_12;
                    }
                    IOUtil.close((InputStream)pomInputStream);
                    IOUtil.close((OutputStream)pomOutputStream);
                    break;
                }
                if (foundPom) ** GOTO lbl48
                this.getLog().info((CharSequence)("pom.xml not found in " + this.file.getName()));
            }
            catch (IOException var3_5) {
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException var3_4) {}
                }
            }
        } else {
            this.processModel(this.readModel(this.pomFile));
        }
lbl48:
        // 4 sources

        if (this.packaging == null && this.file != null) {
            this.packaging = this.getExtension(this.file);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactType artifactType;
        boolean isFilePom;
        if (!this.file.exists()) {
            throw new MojoExecutionException(this.file.getPath() + " not found.");
        }
        this.initProperties();
        RemoteRepository remoteRepository = this.getRemoteRepository(this.repositoryId, this.url);
        if (StringUtils.isEmpty((String)remoteRepository.getProtocol())) {
            throw new MojoExecutionException("No transfer protocol found.");
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        if (!(this.isValidId(this.groupId) && this.isValidId(this.artifactId) && this.isValidVersion(this.version))) {
            throw new MojoExecutionException("The artifact information is not valid: uses invalid characters.");
        }
        this.failIfOffline();
        this.warnIfAffectedPackagingAndMaven(this.packaging);
        DeployRequest deployRequest = new DeployRequest();
        deployRequest.setRepository(remoteRepository);
        boolean bl = isFilePom = this.classifier == null && "pom".equals(this.packaging);
        if (!isFilePom && (artifactType = this.session.getRepositorySession().getArtifactTypeRegistry().get(this.packaging)) != null && StringUtils.isEmpty((String)this.classifier) && !StringUtils.isEmpty((String)artifactType.getClassifier())) {
            this.classifier = artifactType.getClassifier();
        }
        Artifact mainArtifact = new DefaultArtifact(this.groupId, this.artifactId, this.classifier, isFilePom ? "pom" : this.getExtension(this.file), this.version).setFile(this.file);
        deployRequest.addArtifact(mainArtifact);
        File artifactLocalFile = this.getLocalRepositoryFile(this.session.getRepositorySession(), mainArtifact);
        if (this.file.equals(artifactLocalFile)) {
            throw new MojoFailureException("Cannot deploy artifact from the local repository: " + this.file);
        }
        File temporaryPom = null;
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile != null) {
                deployRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "", "pom", this.pomFile));
            } else if (this.generatePom) {
                temporaryPom = this.generatePomFile();
                this.getLog().debug((CharSequence)"Deploying generated POM");
                deployRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "", "pom", temporaryPom));
            } else {
                this.getLog().debug((CharSequence)"Skipping deploying POM");
            }
        }
        if (this.sources != null) {
            deployRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "sources", "jar", this.sources));
        }
        if (this.javadoc != null) {
            deployRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, "javadoc", "jar", this.javadoc));
        }
        if (this.files != null) {
            if (this.types == null) {
                throw new MojoExecutionException("You must specify 'types' if you specify 'files'");
            }
            if (this.classifiers == null) {
                throw new MojoExecutionException("You must specify 'classifiers' if you specify 'files'");
            }
            int filesLength = StringUtils.countMatches((String)this.files, (String)",");
            int typesLength = StringUtils.countMatches((String)this.types, (String)",");
            int classifiersLength = StringUtils.countMatches((String)this.classifiers, (String)",");
            if (typesLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'types' (respectively " + filesLength + " and " + typesLength + " entries )");
            }
            if (classifiersLength != filesLength) {
                throw new MojoExecutionException("You must specify the same number of entries in 'files' and 'classifiers' (respectively " + filesLength + " and " + classifiersLength + " entries )");
            }
            int fi = 0;
            int ti = 0;
            int ci = 0;
            for (int i = 0; i <= filesLength; ++i) {
                String extension;
                File file;
                int nci;
                int nti;
                int nfi = this.files.indexOf(44, fi);
                if (nfi == -1) {
                    nfi = this.files.length();
                }
                if ((nti = this.types.indexOf(44, ti)) == -1) {
                    nti = this.types.length();
                }
                if ((nci = this.classifiers.indexOf(44, ci)) == -1) {
                    nci = this.classifiers.length();
                }
                if (!(file = new File(this.files.substring(fi, nfi))).isFile()) {
                    file = new File(this.files.substring(fi, nfi));
                }
                if (file.isFile()) {
                    extension = this.getExtension(file);
                    ArtifactType artifactType2 = this.session.getRepositorySession().getArtifactTypeRegistry().get(this.types.substring(ti, nti).trim());
                    if (artifactType2 != null && !Objects.equals(extension, artifactType2.getExtension())) {
                        extension = artifactType2.getExtension();
                    }
                } else {
                    throw new MojoExecutionException("Specified side artifact " + file + " does not exist");
                }
                deployRequest.addArtifact((Artifact)new SubArtifact(mainArtifact, this.classifiers.substring(ci, nci).trim(), extension, file));
                fi = nfi + 1;
                ti = nti + 1;
                ci = nci + 1;
            }
        } else {
            if (this.types != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'types'");
            }
            if (this.classifiers != null) {
                throw new MojoExecutionException("You must specify 'files' if you specify 'classifiers'");
            }
        }
        try {
            this.repositorySystem.deploy(this.session.getRepositorySession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (temporaryPom != null) {
                temporaryPom.delete();
            }
        }
    }

    private File getLocalRepositoryFile(RepositorySystemSession session, Artifact artifact) {
        String path = session.getLocalRepositoryManager().getPathForLocalArtifact(artifact);
        return new File(session.getLocalRepository().getBasedir(), path);
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    Model readModel(File pomFile) throws MojoExecutionException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            reader.close();
            reader = null;
            Model model2 = model;
            return model2;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("POM not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            fw.close();
            fw = null;
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription(this.description);
        return model;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    String getPackaging() {
        return this.packaging;
    }

    File getFile() {
        return this.file;
    }

    String getClassifier() {
        return this.classifier;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    private String getExtension(File file) {
        String filename = file.getName();
        if (filename.contains(".tar.")) {
            return "tar." + FileUtils.getExtension((String)filename);
        }
        return FileUtils.getExtension((String)filename);
    }

    private boolean isValidId(String id) {
        if (id == null) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.') continue;
            return false;
        }
        return true;
    }

    private boolean isValidVersion(String version) {
        if (version == null) {
            return false;
        }
        for (int i = version.length() - 1; i >= 0; --i) {
            if (ILLEGAL_VERSION_CHARS.indexOf(version.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }
}

