/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugins.dependency.tree.AbstractVerboseGraphSerializer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

class VerboseGraphTgfSerializer
extends AbstractVerboseGraphSerializer {
    VerboseGraphTgfSerializer() {
    }

    @Override
    public String serialize(DependencyNode root) {
        HashSet<String> coordinateStrings = new HashSet<String>();
        HashMap<String, String> coordinateVersionMap = new HashMap<String, String>();
        Map<DependencyNode, String> nodeErrors = this.getNodeConflictMessagesBfs(root, coordinateStrings, coordinateVersionMap);
        StringBuilder nodes = new StringBuilder();
        StringBuilder edges = new StringBuilder("#");
        edges.append("\n");
        Artifact rootArtifact = root.getArtifact();
        nodes.append(root.hashCode()).append(" ").append(rootArtifact.getGroupId()).append(":").append(rootArtifact.getArtifactId()).append(":").append(rootArtifact.getExtension()).append(":").append(rootArtifact.getVersion());
        if (root.getData().containsKey("ContainsModule")) {
            nodes.append(" WARNING: this tree contains a submodule. Once it reaches the submodule will print in nonVerbose fashion, to see the actual submodule verbose output refer to the rest of the output");
        }
        nodes.append("\n");
        for (DependencyNode child : root.getChildren()) {
            edges.append(root.hashCode()).append(" ").append(child.hashCode()).append(" ").append(child.getDependency().getScope()).append("\n");
            this.serializeTgfDfs(child, nodeErrors, nodes, edges);
        }
        return nodes.append((CharSequence)edges).toString();
    }

    private void serializeTgfDfs(DependencyNode node, Map<DependencyNode, String> nodeErrors, StringBuilder nodes, StringBuilder edges) {
        nodes.append(node.hashCode()).append(" ");
        String coordString = "";
        boolean messageAdded = false;
        if (node.getArtifact().getProperties().containsKey("preManagedVersion")) {
            coordString = coordString + " - version managed from " + (String)node.getArtifact().getProperties().get("preManagedVersion");
            messageAdded = true;
        }
        if (node.getArtifact().getProperties().containsKey("preManagedScope")) {
            if (messageAdded) {
                coordString = coordString + "; ";
            } else {
                coordString = coordString + " - ";
                messageAdded = true;
            }
            coordString = coordString + "scope managed from " + (String)node.getArtifact().getProperties().get("preManagedScope");
        }
        coordString = VerboseGraphTgfSerializer.getDependencyCoordinate(node) + coordString;
        if (node.getArtifact().getProperties().containsKey("Cycle")) {
            coordString = messageAdded ? coordString + "; " : coordString + " - ";
            coordString = coordString + "omitted for cycle";
            nodes.append("(").append(coordString).append(")").append("\n");
        } else if (nodeErrors.get(node) != null) {
            nodes.append("(");
            if (messageAdded) {
                nodes.append(coordString).append("; ").append(nodeErrors.get(node));
            } else {
                nodes.append(coordString).append(" - ").append(nodeErrors.get(node));
            }
            nodes.append(")").append("\n");
        } else {
            nodes.append(coordString).append("\n");
            for (DependencyNode child : node.getChildren()) {
                edges.append(node.hashCode()).append(" ").append(child.hashCode()).append(" ");
                if (child.getArtifact().getProperties().get("managedScope") != null) {
                    edges.append((String)child.getArtifact().getProperties().get("managedScope")).append(" managed from ").append((String)child.getArtifact().getProperties().get("preManagedScope"));
                } else {
                    edges.append(child.getDependency().getScope());
                }
                if (child.getArtifact().getProperties().containsKey("Cycle")) {
                    edges.append(" omitted for cycle");
                } else if (nodeErrors.get(child) != null) {
                    edges.append(" ").append(nodeErrors.get(child));
                }
                edges.append("\n");
                this.serializeTgfDfs(child, nodeErrors, nodes, edges);
            }
        }
    }
}

