/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

abstract class AbstractVerboseGraphSerializer {
    protected static final String LINE_START_LAST_CHILD = "\\- ";
    protected static final String LINE_START_CHILD = "+- ";
    protected static final String PRE_MANAGED_SCOPE = "preManagedScope";
    protected static final String PRE_MANAGED_VERSION = "preManagedVersion";
    protected static final String MANAGED_SCOPE = "managedScope";

    AbstractVerboseGraphSerializer() {
    }

    public abstract String serialize(DependencyNode var1);

    protected static String getDependencyCoordinate(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        if (node.getDependency() == null) {
            return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getExtension() + ":" + artifact.getVersion();
        }
        String scope = artifact.getProperties().containsKey(MANAGED_SCOPE) ? (String)artifact.getProperties().get(MANAGED_SCOPE) : node.getDependency().getScope();
        String coords = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getExtension() + ":" + artifact.getVersion();
        if (scope != null && !scope.isEmpty()) {
            coords = coords.concat(":" + scope);
        }
        return coords;
    }

    private static String getVersionlessScopelessCoordinate(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getExtension();
    }

    private static boolean isDuplicateDependencyCoordinate(DependencyNode node, Set<String> coordinateStrings) {
        return coordinateStrings.contains(AbstractVerboseGraphSerializer.getDependencyCoordinate(node));
    }

    private static String versionConflict(DependencyNode node, Map<String, String> coordinateVersionMap) {
        if (coordinateVersionMap.containsKey(AbstractVerboseGraphSerializer.getVersionlessScopelessCoordinate(node))) {
            return coordinateVersionMap.get(AbstractVerboseGraphSerializer.getVersionlessScopelessCoordinate(node));
        }
        return null;
    }

    private static String scopeConflict(DependencyNode node, Set<String> coordinateStrings) {
        Artifact artifact = node.getArtifact();
        List<String> scopes = Arrays.asList("compile", "provided", "runtime", "test", "system");
        for (String scope : scopes) {
            String coordinate = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getExtension() + ":" + artifact.getVersion() + ":" + scope;
            if (!coordinateStrings.contains(coordinate)) continue;
            return scope;
        }
        return null;
    }

    protected Map<DependencyNode, String> getNodeConflictMessagesBfs(DependencyNode root, Set<String> coordinateStrings, Map<String, String> coordinateVersionMap) {
        HashMap<DependencyNode, String> nodeErrors = new HashMap<DependencyNode, String>();
        HashSet<DependencyNode> visitedNodes = new HashSet<DependencyNode>(512);
        LinkedList<DependencyNode> queue = new LinkedList<DependencyNode>();
        visitedNodes.add(root);
        queue.add(root);
        while (!queue.isEmpty()) {
            DependencyNode node = (DependencyNode)queue.poll();
            if (node == null || node.getArtifact() == null) {
                nodeErrors.put(node, "Null Artifact Node");
                break;
            }
            if (AbstractVerboseGraphSerializer.isDuplicateDependencyCoordinate(node, coordinateStrings)) {
                nodeErrors.put(node, "omitted for duplicate");
            } else if (AbstractVerboseGraphSerializer.scopeConflict(node, coordinateStrings) != null) {
                nodeErrors.put(node, "omitted for conflict with " + AbstractVerboseGraphSerializer.scopeConflict(node, coordinateStrings));
            } else if (AbstractVerboseGraphSerializer.versionConflict(node, coordinateVersionMap) != null) {
                nodeErrors.put(node, "omitted for conflict with " + AbstractVerboseGraphSerializer.versionConflict(node, coordinateVersionMap));
            } else if (AbstractVerboseGraphSerializer.versionConflict(node, coordinateVersionMap) != null) {
                nodeErrors.put(node, "omitted for conflict with " + AbstractVerboseGraphSerializer.versionConflict(node, coordinateVersionMap));
            } else if (node.getDependency() != null && node.getDependency().isOptional()) {
                nodeErrors.put(node, "omitted due to optional dependency");
            } else {
                boolean ignoreNode = false;
                nodeErrors.put(node, null);
                if (node.getArtifact() != null) {
                    coordinateVersionMap.put(AbstractVerboseGraphSerializer.getVersionlessScopelessCoordinate(node), node.getArtifact().getVersion());
                }
                for (DependencyNode child : node.getChildren()) {
                    if (!visitedNodes.contains(child)) continue;
                    ignoreNode = true;
                    nodeErrors.put(node, "omitted for introducing a cycle with " + AbstractVerboseGraphSerializer.getDependencyCoordinate(child));
                    node.setChildren(new ArrayList());
                    break;
                }
                if (!ignoreNode) {
                    for (int i = 0; i < node.getChildren().size(); ++i) {
                        DependencyNode child;
                        child = (DependencyNode)node.getChildren().get(i);
                        if (visitedNodes.contains(child)) continue;
                        visitedNodes.add(child);
                        queue.add(child);
                    }
                }
            }
            coordinateStrings.add(AbstractVerboseGraphSerializer.getDependencyCoordinate(node));
        }
        return nodeErrors;
    }
}

