/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.maven.plugin.compiler.SourceDirectory;

final class SourceFile {
    final SourceDirectory directory;
    final Path file;
    final long lastModified;
    boolean isNewOrModified;
    final boolean ignoreModification;
    private Path outputFile;

    SourceFile(SourceDirectory directory, Path file, BasicFileAttributes attrs, boolean ignoreModification) {
        this.directory = directory;
        this.file = file;
        this.lastModified = attrs.lastModifiedTime().toMillis();
        this.ignoreModification = ignoreModification;
        directory.visit(file);
    }

    boolean isStandardOutputFile() {
        return ".java".equals(this.directory.fileKind.extension) && ".class".equals(this.directory.outputFileKind.extension);
    }

    Path getOutputFile() {
        if (this.outputFile == null) {
            this.outputFile = SourceFile.toOutputFile(this.directory.root, this.directory.getOutputDirectory(), this.file, this.directory.fileKind.extension, this.directory.outputFileKind.extension);
        }
        return this.outputFile;
    }

    static Path toOutputFile(Path sourceDirectory, Path outputDirectory, Path file, String extension, String outext) {
        Path output = sourceDirectory.relativize(file);
        String filename = file.getFileName().toString();
        if (filename.endsWith(extension)) {
            filename = filename.substring(0, filename.length() - extension.length());
            filename = filename.concat(outext);
            output = output.resolveSibling(filename);
        }
        return outputDirectory.resolve(output);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceFile) {
            SourceFile other = (SourceFile)obj;
            return this.file.equals(other.file) && this.directory.equals(other.directory);
        }
        return false;
    }

    public int hashCode() {
        return this.directory.hashCode() + 7 * this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }
}

